<?php
/**
 * Report Meetings Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Rep_meetings extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Reports_model');

		$this->load->model('Batches_model');
		$this->load->model('Programs_model');
		$this->load->model('Trainees_model');
		$this->load->model('Companies_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Pertemuan';
         
 		$data['batch_data']   = $this->Reports_model->get_batches_header_select()->result();
		 $data['program_data'] = $this->Reports_model->get_program_header_select()->result();
		 $data['class_data']   = $this->Programs_model->get_data_class()->result();
 		$data['type_data']    = $this->Programs_model->get_data_type()->result();
		
		if(check_roles('1') or check_roles('3')){
			$this->twiggy_display('adm/rep_meetings/index', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data_class()
	{
		$program_name = $this->input->post('program_name');

		$where = [];
		$group_by = 'program_class_name';
		$order_by = 'program_class_sort';

		if(isset($program_name) && $program_name != '' && $program_name != '(Semua)')
		{
			$where['program_header_name'] = trim($program_name);
		}
		
		$result = $this->Reports_model->get_select_advance($where, $group_by, $order_by)->result();
		
		echo json_encode($result);
	}

	public function get_data_type()
	{
		$program_name = $this->input->post('program_name');
		$program_class_name = $this->input->post('program_class_name');

		$where = [];
		$group_by = 'program_type_name';
		$order_by = 'program_type_name';

		if(isset($program_name) && $program_name != '' && $program_name != '(Semua)')
		{
			$where['program_header_name'] = trim($program_name);
		}

		if(isset($program_class_name) && $program_class_name != '' && $program_class_name != '(Semua)')
		{
			$where['c.program_class_name'] = trim($program_class_name);
		}
		
		$result = $this->Reports_model->get_select_advance($where, $group_by, $order_by)->result();
		
		echo json_encode($result);
	}

	public function get_data_batch()
	{
		$program_name = $this->input->post('program_name');
		$program_class_name = $this->input->post('program_class_name');
		$program_type_name = $this->input->post('program_type_name');

		$where = [];
		$group_by = 'batch_header_name';
		$order_by = 'batch_year asc, batch_number';

		if(isset($program_name) && $program_name != '' && $program_name != '(Semua)')
		{
			$where['program_header_name'] = trim($program_name);
		}

		if(isset($program_class_name) && $program_class_name != '' && $program_class_name != '(Semua)')
		{
			$where['c.program_class_name'] = trim($program_class_name);
		}

		if(isset($program_type_name) && $program_type_name != '' && $program_type_name != '(Semua)')
		{
			$where['d.program_type_name'] = trim($program_type_name);
		}
		
		$result = $this->Reports_model->get_select_advance($where, $group_by, $order_by)->result();
		
		echo json_encode($result);
	}
	
	public function get_data_detail()
	{	
		$batch   = $this->input->post("batch");
		$program = $this->input->post("program");
		$programclass = $this->input->post("programclass");
		$programtype = $this->input->post("programtype");
		$fromdate = $this->input->post("fromdate");
		$todate = $this->input->post("todate");
		$status  = $this->input->post("status");

		$where = [];
		if(isset($batch) && $batch != '' && $batch != '(Semua)')
		{
			$where['b.batch_header_name'] = trim($batch);
		}
		if(isset($program) && $program != '' && $program != '(Semua)')
		{
			$where['c.program_header_name'] = trim($program);
        }
		if(isset($programclass) && $programclass != '')
		{
			$where['c.program_header_class_id'] = $programclass;
        }
        if(isset($programtype) && $programtype != '')
		{
			$where['c.program_header_type_id'] = $programtype;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['a.meeting_date >='] = change_format_date($fromdate);
		}

		if(isset($todate) && $todate != '')
		{
			$where['a.meeting_date <='] = change_format_date($todate);
		}
		if(isset($status) && $status != '')
		{	
			if($status == 2){
				$where['a.meeting_date >'] = date_now();
			}elseif($status == 1){
				$where['a.meeting_date <'] = date_now();
			}else{
				$where['a.meeting_date >='] = date_now();
				$where['a.meeting_date ='] = date_now();
			}
		}

		$data = [];
		$get_data = $this->Reports_model->get_meetings_detail($where)->result();
		
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$statuscolor = '';
				if($get_row->meeting_date > date_now()){
					$statuscolor = 'cl-danger';
				}
				if($get_row->meeting_date < date_now()){
					$statuscolor = 'cl-success';
				}
				if($get_row->meeting_date == date_now()){
					$statuscolor = 'cl-info';
				}

				$data[] = array(
					'no'      => $no,
					'batch'   => $get_row->batch_header_name,
					'batch_date'   => indonesian_date($get_row->batch_header_start),
					'program' => $get_row->program_header_name,
					'class'         => $get_row->program_class_name,
					'type'          => $get_row->program_type_name,
					'meeting_number' 	=> $get_row->meeting_number,
					'meeting_date' 		=> indonesian_date($get_row->meeting_date),
					'meeting_duration'	=> $get_row->meeting_duration,
					'meeting_method' 	=> $get_row->meeting_method,
					'meeting_type' 		=> $get_row->meeting_type,
					'meeting_info' 		=> $get_row->meeting_info,
					'statuscolor' 		=> $statuscolor,
				);
				$no++;
			}
		}
		$this->session->set_userdata('where', $where);

		output_json($data);
	}

	public function export_excel() {

		$where = $this->session->userdata('where');

		$get_data = $this->Reports_model->get_meetings_detail($where)->result();

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('LOOP INDONESIA')
							   ->setLastModifiedBy('LOOP INDONESIA')
							   ->setTitle("PERTEMUAN")
							   ->setSubject("PERTEMUAN")
							   ->setDescription("PERTEMUAN")
							   ->setKeywords("PERTEMUAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

		$style_col_success = array(
			'font'  => array(
				'color' => array('rgb' => 'FFFFFF'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '5CB85C')
			)
		);

		$style_col_danger = array(
			'font'  => array(
				'color' => array('rgb' => 'FFFFFF'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'D9534F')
			)
		);

		$style_col_info = array(
			'font'  => array(
				'color' => array('rgb' => 'FFFFFF'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '5BC0DE')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "PERTEMUAN");
	    $excel->getActiveSheet()->mergeCells('A1:K1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

	    // Buat header tabel pada baris ke 3
	    $excel->setActiveSheetIndex(0)->setCellValue('A3', "No");
	    $excel->setActiveSheetIndex(0)->setCellValue('B3', "Batch");
	    $excel->setActiveSheetIndex(0)->setCellValue('C3', "Program");
	    $excel->setActiveSheetIndex(0)->setCellValue('D3', "Jenis");
	    $excel->setActiveSheetIndex(0)->setCellValue('E3', "Kategori");
	    $excel->setActiveSheetIndex(0)->setCellValue('F3', "Pertemuan");
	    $excel->setActiveSheetIndex(0)->setCellValue('G3', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('H3', "Durasi");
		$excel->setActiveSheetIndex(0)->setCellValue('I3', "Metode");
		$excel->setActiveSheetIndex(0)->setCellValue('J3', "Tipe");
		$excel->setActiveSheetIndex(0)->setCellValue('K3', "Keterangan");

	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('F3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('G3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('J3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K3')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 4; // Set baris pertama untuk isi tabel adalah baris ke 4
	    foreach($get_data as $row){ // Lakukan looping pada variabel row
			
			if($row->meeting_date > date_now()){
				$excel->getActiveSheet()->getStyle('A'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('B'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('C'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('D'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('E'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('F'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('G'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('H'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('I'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('J'.$numrow)->applyFromArray($style_col_danger);
				$excel->getActiveSheet()->getStyle('K'.$numrow)->applyFromArray($style_col_danger);
			}
			if($row->meeting_date < date_now()){
				$excel->getActiveSheet()->getStyle('A'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('B'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('C'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('D'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('E'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('F'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('G'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('H'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('I'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('J'.$numrow)->applyFromArray($style_col_success);
				$excel->getActiveSheet()->getStyle('K'.$numrow)->applyFromArray($style_col_success);
			}
			if($row->meeting_date == date_now()){
				$excel->getActiveSheet()->getStyle('A'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('B'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('C'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('D'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('E'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('F'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('G'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('H'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('I'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('J'.$numrow)->applyFromArray($style_col_info);
				$excel->getActiveSheet()->getStyle('K'.$numrow)->applyFromArray($style_col_info);
			}

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $row->batch_header_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $row->program_header_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $row->program_class_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $row->program_type_name);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $row->meeting_number);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, indonesian_date($row->meeting_date));
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $row->meeting_duration);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $row->meeting_method);
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $row->meeting_type);
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, $row->meeting_info);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
	    	$excel->getActiveSheet()->getStyle('A'.$numrow.':K'.$numrow)->applyFromArray($style_row);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		 }
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PERTEMUAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PERTEMUAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
