<?php

/**
 * Purchase Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class stocks extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Stocks_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Items_model');
		$this->load->model('Logs_model');
		$this->load->model('Ppn_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Adjust Stok';

		$this->twiggy_display('adm/stocks/index', $data);
	}

	public function get_data_header()
	{
		$data = [];
		$order = "stock_header_date DESC, stock_header_number DESC";
		$get_data = $this->Stocks_model->stock_header('', $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->stock_header_id,
					'number'      => $get_row->stock_header_number,
					'date'        => indonesian_date($get_row->stock_header_date),
					'supplier'    => '',
					'grand_total' => number_format($get_row->stock_header_sub_total),
					'description' => $get_row->stock_header_description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function get_autonumber()
	{
		$id      = $this->input->post('id');
		$datenow = date('mY');
		$number_generator = '';
		$where   = array('supplier_id' => $id);
		$supplier_data  = $this->Suppliers_model->get_data($where)->row();

		if ($supplier_data) {
			$number_generator = $this->Stocks_model->stock_autonumber($supplier_data->supplier_code);
		}

		$prefix     = $supplier_data->supplier_code;
		$autonumber = $prefix . $datenow . $number_generator;

		$payment_term  = $supplier_data->supplier_payment_term;
		$date          = date_now();

		if ($supplier_data) {
			$payment_due = date('d/m/Y', strtotime($date . ' + ' . $supplier_data->supplier_payment_term . ' days'));
		}

		$response = [
			'autonumber'  => $autonumber,
			'payment_due' => $payment_due
		];

		echo json_encode($response);
	}


	public function edit($id = 'new')
	{
		$title       = "Adjust Stok";
		$header_data = array(null);
		$ppn_amount  = 0;
		// $ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		// $ppn_amount  = (empty($ppn_data) ? 0 : $ppn_data->amount);
		$prefix  = "STO";
		$datenow = date('Ym');
		$number_generator = $this->Stocks_model->stock_autonumber();
		$autonumber = $prefix . $datenow . $number_generator;
		// $autonumber = '';

		$tmstamp   = date("H:i:s");

		$date_text   = date_now();

		if ($id != 'new') {
			$title       = "Adjust Stok";
			$where       = array('stock_header_id' => $id);
			$header_data = $this->Stocks_model->stock_header($where)->row_array();
			$autonumber  = $header_data['stock_header_number'];
			$date_text   = $header_data['stock_header_date'];
			$tmstamp     = time24($header_data['tmstamp_so']);
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['supplier_data'] = $this->Suppliers_model->get_data()->result();
		// $data['ppn_amount']    = $ppn_amount;


		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;
		$data['tmstamp']    = $tmstamp;

		$this->twiggy_display('adm/stocks/edit', $data);
	}

	public function get_data_ppn()
	{
		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : $ppn_data->amount);

		echo json_encode(to_decimal($ppn_amount));
	}

	public function get_data_detail()
	{
		$id = $this->input->post("id");
		$where       = array('stock_detail_header_id' => $id);
		$order       = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Stocks_model->stock_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->stock_detail_id,
					'detail_header_id' => $get_row->stock_detail_header_id,
					'id'               => $get_row->stock_detail_item_id,
					'name'             => $get_row->stock_detail_item_name,
					'lg_unit'          => $get_row->stock_detail_large_unit,
					'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty'      => to_decimal($get_row->stock_detail_large_unit_quantity),
					'lg_unit_prc'      => number_format($get_row->stock_detail_large_unit_price),
					'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
					'result_large'     => $get_row->stock_detail_result_large,
					'md_unit'          => $get_row->stock_detail_medium_unit,
					'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty'      => to_decimal($get_row->stock_detail_medium_unit_quantity),
					'md_unit_prc'      => number_format($get_row->stock_detail_medium_unit_price),
					'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
					'result_medium'    => $get_row->stock_detail_result_medium,
					'sm_unit'          => $get_row->stock_detail_small_unit,
					'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty'      => to_decimal($get_row->stock_detail_small_unit_quantity),
					'sm_unit_prc'      => number_format($get_row->stock_detail_small_unit_price),
					'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
					'result_small'     => $get_row->stock_detail_result_small,
					'discount'         => to_decimal($get_row->stock_detail_discount_percentage),
					'discount_total'   => number_format($get_row->stock_detail_discount_total),
					'total'            => number_format($get_row->stock_detail_total),

					'overprice_lg' => 0,
					'overprice_md' => 0,
					'overprice_sm' => 0,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/stocks/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		$get_data  = $this->Items_model->get_data_search($search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {

			$lg_unit_prc = $get_row->last_purchase_price_large_unit;
			$md_unit_prc = $get_row->last_purchase_price_medium_unit;
			$sm_unit_prc = $get_row->last_purchase_price_small_unit;

			$where_log = array('log_item_id' => $get_row->item_id);
			$order_log = 'log_id desc';
			$getda_log = $this->Logs_model->get_data($where_log, $order_log)->row();
			$total_large = 0;
			$total_medium = 0;
			$total_small = 0;
			if ($getda_log) {
				$lg_unit_prc = $getda_log->log_average_large_unit;
				$md_unit_prc = $getda_log->log_average_medium_unit;
				$sm_unit_prc = $getda_log->log_average_small_unit;
				$therest      = $getda_log->log_total_stock;
				$total_large  = ($getda_log->log_large_unit_contain == 0 ? '-' : floor($getda_log->log_total_stock / $getda_log->log_large_unit_contain));
				$therest      = ($therest - ($total_large * $getda_log->log_large_unit_contain));
				$total_medium = ($getda_log->log_medium_unit_contain == 0 ? '-' : floor($therest / $getda_log->log_medium_unit_contain));
				$therest      = ($therest - ($total_medium * $getda_log->log_medium_unit_contain));
				$total_small  = ($getda_log->log_small_unit_contain == 0 ? '-' : floor($therest / $getda_log->log_small_unit_contain));
			}

			$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'name'             => $get_row->item_name,
				'group_id'         => $get_row->group_id,
				'group_name'       => $get_row->group_name,
				'group_child_id'   => $get_row->group_child_id,
				'group_child_name' => $get_row->group_child_name,
				'lg_unit'          => $get_row->large_unit,
				'lg_unit_stk'          => $total_large,
				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
				'lg_unit_prc'      => number_format($lg_unit_prc),
				'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
				'md_unit'          => $get_row->medium_unit,
				'md_unit_stk'          => $total_medium,
				'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
				'md_unit_prc'      => number_format($md_unit_prc),
				'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
				'sm_unit'          => $get_row->small_unit,
				'sm_unit_stk'          => $total_small,
				'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
				'sm_unit_prc'      => number_format($sm_unit_prc),
				'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
				'btncolor'         => '',
				'btnicon'          => '',
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function save()
	{
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$date           = $this->input->post("date");
		$supplier       = $this->input->post("supplier");
		$sub_total      = $this->input->post("sub_total");
		$ppn_id         = $this->input->post("ppn_id");
		$ppn_percentage = $this->input->post("ppn_percentage");
		$ppn_total      = $this->input->post("ppn_total");
		$grand_total    = $this->input->post("grand_total");
		$description    = $this->input->post("description");

		$tmstamp         = $this->input->post("tmstamp");

		$vuedata = $this->input->post('vuedata');
		$ppn_type = ($ppn_id == NULL ? 0 : 1);

		$payment_due   = $this->input->post("payment_due");
		// $where         = array('supplier_id' => $supplier);
		// $supplier_data = $this->Suppliers_model->get_data($where)->row();
		// if($supplier_data){
		// 	$payment_due = date('Y-m-d', strtotime($date. ' + '. $supplier_data->supplier_payment_term .' days'));
		// }

		$header_id   = $id;
		$header_data = [
			'stock_header_number'         => $number,
			'stock_header_date'           => change_format_date($date),
			'stock_header_payment_due'    => change_format_date($payment_due),
			'stock_header_supplier_id'    => 0,
			'stock_header_sub_total'      => trims($sub_total),
			'stock_header_ppn_id'         => 0,
			'stock_header_ppn_percentage' => 0,
			'stock_header_ppn_total'      => trims($ppn_total),
			'stock_header_grand_total'    => trims($grand_total),
			'stock_header_description'    => $description,
		];

		$detail_data = [];
		$log_data = [];

		// if save $id = new else update data
		if ($vuedata) {
			if ($id == "new") {
				// save header
				$save_header = $this->Stocks_model->save_header($header_data);
				if ($save_header) {
					$header_id = $this->db->insert_id();
					foreach ($vuedata as $row) {
						$detail_data[] = [
							'stock_detail_header_id'            => $header_id,
							'stock_detail_item_id'              => $row['id'],
							'stock_detail_item_name'            => $row['name'],
							'stock_detail_large_unit'           => $row['lg_unit'],
							'stock_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
							'stock_detail_large_unit_price'     => trims($row['lg_unit_prc']),
							'stock_detail_result_large'         => trims($row['result_large']),
							'stock_detail_medium_unit'          => $row['md_unit'],
							'stock_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
							'stock_detail_medium_unit_price'    => trims($row['md_unit_prc']),
							'stock_detail_result_medium'        => trims($row['result_medium']),
							'stock_detail_small_unit'           => $row['sm_unit'],
							'stock_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
							'stock_detail_small_unit_price'     => trims($row['sm_unit_prc']),
							'stock_detail_result_small'         => trims($row['result_small']),
							'stock_detail_discount_percentage'  => trims($row['discount']),
							'stock_detail_discount_total'       => trims($row['discount_total']),
							'stock_detail_total'                => trims($row['total'])
						];

						// $where                 = array('log_item_id' => $row['id']);
						$dtstamp                    = change_format_date($date) . " " . date("H:i:s");
						$where                      = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
						$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
						$last_total_stock           = 0;
						$last_log_total_stock_value = 0;

						if (!empty($log_data_check)) {
							$last_total_stock      		= $log_data_check['log_total_stock'];
							$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
						}

						$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * trims($row['lg_unit_qty'])) + ($row['md_unit_cnt'] * trims($row['md_unit_qty'])) + ($row['sm_unit_cnt'] * trims($row['sm_unit_qty']));
						$log_total_transaction_value = (trims($row['lg_unit_qty']) * trims($row['lg_unit_prc'])) + (trims($row['md_unit_qty']) * trims($row['md_unit_prc'])) + (trims($row['sm_unit_qty']) * trims($row['sm_unit_prc']));
						$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
						$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
						$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
						$log_data[] = [
							'log_type'                            => 'STO',
							'log_transaction_id'                  => $header_id,
							'log_item_id'                         => $row['id'],
							'log_large_unit'                      => $row['lg_unit'],
							'log_large_unit_contain'              => $row['lg_unit_cnt'],
							'log_large_unit_quantity'             => trims($row['lg_unit_qty']),
							'log_large_unit_purchase_price'       => trims($row['lg_unit_prc']),
							'log_medium_unit'                     => $row['md_unit'],
							'log_medium_unit_contain'             => $row['md_unit_cnt'],
							'log_medium_unit_quantity'            => trims($row['md_unit_qty']),
							'log_medium_unit_purchase_price'      => trims($row['md_unit_prc']),
							'log_small_unit'                      => $row['sm_unit'],
							'log_small_unit_contain'              => $row['sm_unit_cnt'],
							'log_small_unit_quantity'             => trims($row['sm_unit_qty']),
							'log_small_unit_purchase_price'       => trims($row['sm_unit_prc']),
							'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
							'log_total_transaction_value'         => $log_total_transaction_value,
							'log_total_stock'                     => $log_total_stock,
							'log_total_stock_value'               => $log_total_stock_value,
							'log_average_large_unit'              => $log_average_large_unit,
							'log_average_medium_unit'             => $log_average_medium_unit,
							'log_average_small_unit'              => $log_average_small_unit,
							'timestamp'                           => $dtstamp
						];

						// $data_item = array(
						// 	'last_purchase_price_large_unit'  => trims($row['lg_unit_prc']),
						// 	'last_purchase_price_medium_unit' => trims($row['md_unit_prc']),
						// 	'last_purchase_price_small_unit'  => trims($row['sm_unit_prc']),
						// );

						// $where_item = $row['id'];

						// $update_item = $this->Items_model->update($where_item, $data_item);
					}

					$save_detail = $this->Stocks_model->save_detail($detail_data, true);

					if ($save_detail) {
						$save_log = $this->Logs_model->save($log_data, true);

						if ($save_log) {
							$update_log = $this->update_log($vuedata, $header_id, $date);
							// $update_log = true;
							if ($update_log) {
								// $s_trx = 'update';
								// $update_master_item = $this->Purchase_orders_model->update_master_item_batch($newprice_data);
								// if($update_master_item)
								// {
								$msg    = "Berhasil menyimpan data";
								$status = "success";
								// }else{
								// 	$msg    = "Gagal menyimpan data #CKP-U01";
								// 	$status = "error";	
								// }
							} else {
								$msg    = "Gagal menyimpan data #CKP-U01";
								$status = "error";
							}
						} else {
							$msg    = "Gagal menyimpan data";
							$status = "error";
						}
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				// This New Update
				$delete_detail = $this->Stocks_model->delete_detail($id);

				if ($delete_detail) {

					// $delete_log = $this->delete_log($id);
					$delete_log = $this->Logs_model->delete(array('log_transaction_id' => $id, 'log_type' => 'STO'));

					if ($delete_log) {
						$save_header = $this->Stocks_model->update_header($id, $header_data);

						if ($save_header) {
							// $header_id = $this->db->insert_id();
							foreach ($vuedata as $row) {
								$detail_data[] = [
									'stock_detail_header_id'            => $header_id,
									'stock_detail_item_id'              => $row['id'],
									'stock_detail_item_name'            => $row['name'],
									'stock_detail_large_unit'           => $row['lg_unit'],
									'stock_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
									'stock_detail_large_unit_price'     => trims($row['lg_unit_prc']),
									'stock_detail_result_large'         => trims($row['result_large']),
									'stock_detail_medium_unit'          => $row['md_unit'],
									'stock_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
									'stock_detail_medium_unit_price'    => trims($row['md_unit_prc']),
									'stock_detail_result_medium'        => trims($row['result_medium']),
									'stock_detail_small_unit'           => $row['sm_unit'],
									'stock_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
									'stock_detail_small_unit_price'     => trims($row['sm_unit_prc']),
									'stock_detail_result_small'         => trims($row['result_small']),
									'stock_detail_discount_percentage'  => trims($row['discount']),
									'stock_detail_discount_total'       => trims($row['discount_total']),
									'stock_detail_total'                => trims($row['total']),
								];

								// $where                 = array('log_item_id' => $row['id'], 'a.timestamp <' => $tmstamp);
								$dtstamp = change_format_date($date) . " " . $tmstamp;
								$where   = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
								$log_data_check        = $this->Logs_model->get_data_last($where)->row_array();
								$last_total_stock      = 0;
								$last_log_total_stock_value = 0;
								$last_log_avg_large = 0;
								$last_log_avg_medium = 0;
								$last_log_avg_small = 0;

								if (!empty($log_data_check)) {
									$last_total_stock           = $log_data_check['log_total_stock'];
									$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
									$last_log_avg_large         = $log_data_check['log_average_large_unit'];
									$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
									$last_log_avg_small         = $log_data_check['log_average_small_unit'];
								}

								$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_medium));
								$small_purchase_price  = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_small));

								$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (trims($row['sm_unit_qty'])));
								$log_total_transaction_value = ((trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((trims($row['md_unit_qty'])) * $medium_purchase_price) + ((trims($row['sm_unit_qty'])) * $small_purchase_price);
								$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
								$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
								$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
								$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
								$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);

								$log_data[] = [
									'log_type'                            => 'STO',
									'log_transaction_id'                  => $header_id,
									'log_item_id'                         => $row['id'],
									'log_large_unit'                      => $row['lg_unit'],
									'log_large_unit_contain'              => $row['lg_unit_cnt'],
									'log_large_unit_quantity'             => trims($row['lg_unit_qty']),
									'log_large_unit_purchase_price'       => trims($row['lg_unit_prc']),
									'log_medium_unit'                     => $row['md_unit'],
									'log_medium_unit_contain'             => $row['md_unit_cnt'],
									'log_medium_unit_quantity'            => trims($row['md_unit_qty']),
									'log_medium_unit_purchase_price'      => trims($row['md_unit_prc']),
									'log_small_unit'                      => $row['sm_unit'],
									'log_small_unit_contain'              => $row['sm_unit_cnt'],
									'log_small_unit_quantity'             => trims($row['sm_unit_qty']),
									'log_small_unit_purchase_price'       => trims($row['sm_unit_prc']),
									'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
									'log_total_transaction_value'         => $log_total_transaction_value,
									'log_total_stock'                     => $log_total_stock,
									'log_total_stock_value'               => $log_total_stock_value,
									'log_average_large_unit'              => $log_average_large_unit,
									'log_average_medium_unit'             => $log_average_medium_unit,
									'log_average_small_unit'              => $log_average_small_unit,
									'timestamp'                           => $dtstamp
								];
							}

							$save_detail = $this->Stocks_model->save_detail($detail_data, true);

							if ($save_detail) {

								$save_log = $this->Logs_model->save($log_data, true);

								if ($save_log) {
									$update_log = $this->update_log($vuedata, $header_id, $date);
									// $update_log = true;
									if ($update_log) {
										// $s_trx = 'update';
										// $checkpoint = $this->checkpoint($s_trx, $header_id, $date, $customer);
										// if($checkpoint)
										// {
										$msg    = "Berhasil menyimpan data";
										$status = "success";
										// }else{
										// 	$msg    = "Gagal menyimpan data #CKP-U01";
										// 	$status = "error";	
										// }
									} else {
										$msg    = "Gagal menyimpan data #CKP-U01";
										$status = "error";
									}
								} else {
									$msg    = "Gagal menyimpan data #LOG-S01";
									$status = "error";
								}
							} else {
								$msg    = "Gagal menyimpan data #LOG-U01";
								$status = "error";
							}
						} else {
							$msg    = "Gagal menyimpan data #HED-U01";
							$status = "error";
						}
					} else {
					}
				} else {
					$msg    = "Gagal menyimpan data #DEL-U01";
					$status = "error";
				}
			}
		} else {
			$msg    = "Gagal menyimpan data";
			$status = "error";
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function update_log($vuedata, $header_id, $date)
	{
		$data_log = [];
		$data_where = [];

		$updateData = array();

		$total_stok = 0;
		$total_stok_rupiah = 0;
		$avg_lg = 0;
		$avg_md = 0;
		$avg_sm = 0;

		foreach ($vuedata as $rowes) {

			$where_1         = array('log_item_id' => $rowes['id']);
			$get_first       = $this->Logs_model->get_data_first($where_1)->row();
			$logs_id         = $get_first->tmslog;

			$total_stok      = $get_first->log_total_stock;
			$total_stok_rupiah = $get_first->log_total_stock_value;

			$avg_lg  = ($get_first->log_average_large_unit);
			$avg_md  = ($get_first->log_average_medium_unit);
			$avg_sm  = ($get_first->log_average_small_unit);

			$log_total_transaction_value = 0;

			$where_2 = array('log_item_id' => $rowes['id'], 'a.timestamp >' => $logs_id);
			$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2, 'a.timestamp asc')->result();

			foreach ($get_data_all_logs_by_item as $row) {


				$total_stok      += $row->log_total_transaction_in_small_unit;

				if ($row->log_type == "BUY" || $row->log_type == "R-SELL") {
					$log_total_transaction_value = (($row->log_large_unit_quantity * ($row->log_large_unit_purchase_price)) + ($row->log_medium_unit_quantity * ($row->log_medium_unit_purchase_price)) + ($row->log_small_unit_quantity * ($row->log_medium_unit_purchase_price)));
				} else {
					$log_total_transaction_value = (($row->log_large_unit_quantity * ($avg_lg)) + ($row->log_medium_unit_quantity * ($avg_md)) + ($row->log_small_unit_quantity * ($avg_sm)));
				}
				$total_stok_rupiah += $log_total_transaction_value;


				$log_average_small_unit  = ($total_stok == 0 ? 0 : ($total_stok_rupiah / $total_stok));
				$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
				$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);

				// $log_total_transaction_value = a;

				if ($row->log_type == "BUY" || $row->log_type == "R-SELL") {
					$avg_lg  = ($log_average_large_unit);
					$avg_md  = ($log_average_medium_unit);
					$avg_sm  = ($log_average_small_unit);
					$data_log[] = array(
						'log_id'                        => $row->log_id,
						// 'log_medium_unit_purchase_price' => $medium_purchase_price,
						// 'log_small_unit_purchase_price'  => $small_purchase_price,
						// 'log_total_transaction_value' => $log_total_transaction_value,
						'log_total_stock'             => $total_stok,
						'log_total_stock_value'       => $total_stok_rupiah,
						'log_average_large_unit'      => $log_average_large_unit,
						'log_average_medium_unit'     => $log_average_medium_unit,
						'log_average_small_unit'      => $log_average_small_unit,
						// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
					);
				} else {

					$data_log[] = array(
						'log_id'                         => $row->log_id,
						'log_large_unit_purchase_price'  => $avg_lg,
						'log_medium_unit_purchase_price' => $avg_md,
						'log_small_unit_purchase_price'  => $avg_sm,
						'log_total_transaction_value'    => $log_total_transaction_value,
						'log_total_stock'                => $total_stok,
						'log_total_stock_value'          => $total_stok_rupiah,
						'log_average_large_unit'         => $log_average_large_unit,
						'log_average_medium_unit'        => $log_average_medium_unit,
						'log_average_small_unit'         => $log_average_small_unit,
						// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
					);
				}
			}
		}

		$after_row_log_update = $this->Logs_model->update_item_batch($data_log);

		return true;
	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach ($id as $row) {
			$where = array('log_type' => 'STO', 'log_transaction_id' => $row);
			$get_data_log = $this->Logs_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {

				// Get Data After This Item ID :::
				$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
				$get_after_data = $this->Logs_model->get_data($where_after)->result();

				if ($get_after_data) {
					foreach ($get_after_data as $row_list_detail) {

						$where_log_delete = array(
							'log_item_id' => $row_list->log_item_id,
							'log_id' => $row_list->log_id
						);

						$delete_logs = $this->Logs_model->delete($where_log_delete);

						// $where_this = array('log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
						$where_this = array('log_id' => $row_list_detail->log_id, 'log_item_id' => $row_list_detail->log_item_id);
						$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;

						$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
						$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
						$one_line_before_total     = 0;
						$one_line_before_log_total = 0;
						$one_line_before_log_avg_large = 0;
						$one_line_before_log_avg_medium = 0;
						$one_line_before_log_avg_small = 0;

						if (!empty($one_line_before_log_data)) {
							$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
							$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
							$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
							$one_line_before_log_avg_medium = $one_line_before_log_data['log_average_medium_unit'];
							$one_line_before_log_avg_small = $one_line_before_log_data['log_average_small_unit'];
						}

						$purchase_price              = $row_list_detail->log_large_unit_purchase_price;
						$log_total_transaction_value = $row_list_detail->log_total_transaction_value;
						$medium_purchase_price       = $row_list_detail->log_medium_unit_purchase_price;
						$small_purchase_price        = $row_list_detail->log_small_unit_purchase_price;
						$log_total_stock             = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
						$log_total_stock_value       = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit     = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
						$log_average_large_unit      = ($log_average_small_unit * $row_list_detail->large_unit_contain);

						if ($row_list_detail->log_type == 'SELL') {
							$purchase_price              = $one_line_before_log_avg_large;
							// $medium_purchase_price       = ($row_list_detail->log_medium_unit_contain == 0 ? 0 : ($one_line_before_log_avg_medium));
							// $small_purchase_price        = ($row_list_detail->log_small_unit_contain == 0 ? 0 : ($one_line_before_log_avg_small));
							$medium_purchase_price       = ($row_list_detail->log_medium_unit_contain == 0 ? 0 : ($one_line_before_log_avg_medium));
							$small_purchase_price        = ($row_list_detail->log_small_unit_contain == 0 ? 0 : ($one_line_before_log_avg_small));
							$log_total_transaction_value = ($row_list_detail->log_large_unit_quantity * $one_line_before_log_avg_large) + ($row_list_detail->log_medium_unit_quantity * $medium_purchase_price) + ($row_list_detail->log_small_unit_quantity * $small_purchase_price);
							$log_total_stock_value       = ($one_line_before_log_total + $log_total_transaction_value);
							$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
							$log_average_medium_unit     = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
							$log_average_large_unit      = ($log_average_small_unit * $row_list_detail->large_unit_contain);
						}
						$after_row_data_update = array(
							'log_id'                         => $row_list_detail->log_id,
							'log_large_unit_purchase_price'  => $purchase_price,
							'log_medium_unit_purchase_price' => $medium_purchase_price,
							'log_small_unit_purchase_price'  => $small_purchase_price,
							'log_total_transaction_value'    => $log_total_transaction_value,
							'log_total_stock'                => $log_total_stock,
							'log_total_stock_value'          => $log_total_stock_value,
							'log_average_large_unit'         => $log_average_large_unit,
							'log_average_medium_unit'        => $log_average_medium_unit,
							'log_average_small_unit'         => $log_average_small_unit
						);

						$after_row_where_update = array(
							'log_id' => $row_list_detail->log_id,
						);

						// echo json_encode($one_line_before_log_data);
						$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
					}
				} else {
					$where_log_delete = array(
						'log_item_id' => $row_list->log_item_id,
						'log_id' => $row_list->log_id
					);

					$delete_logs = $this->Logs_model->delete($where_log_delete);
				}
			}

			$delete_header = $this->Stocks_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Stocks_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header = array('stock_header_id' => $id);
		$where_detail = array('stock_detail_header_id' => $id);

		$header = $this->Stocks_model->stock_header($where_header)->row_array();
		$detail = $this->Stocks_model->stock_detail($where_detail)->result();

		$data['content_title'] = 'Print Stok';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/stocks/print_out', $data);
	}

	public function ex_average($id = '')
	{
		// $where_header = array('stock_header_id' => $id);
		// $where_detail = array('stock_detail_header_id' => $id);

		$order = ("b.item_name, a.log_id ASC");
		$detail = $this->Logs_model->get_data('', $order)->result();

		$data['content_title'] = 'Hasil Perhitungan Average';
		// $data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/stocks/print_avg', $data);
	}

	public function ed_average($id = '')
	{
		$detail = $this->Logs_model->get_data()->result();
		foreach ($detail as $key => $get_row) {
			$data[] = array(
				'log_total_transaction_in_small_unit' => $get_row[$key]->log_total_transaction_in_small_unit,
				'log_total_transaction_value'         => $get_row->log_total_transaction_value,
				'log_total_stock'                     => $get_row->log_total_stock,
				'log_total_stock_value'               => $get_row->log_total_stock_value,
				'log_average_large_unit'              => $get_row->log_average_large_unit,
				'log_average_medium_unit'             => $get_row->log_average_medium_unit,
				'log_average_small_unit'              => $get_row->log_average_small_unit
			);
		}

		echo json_encode($data);
	}
}
