<?php

/**
 * Account_headers Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Account_headers extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Account_headers_model');
		$this->load->model('Account_groups_model');
	}

	public function index()
	{
		$data['content_title'] = 'Header Akun';
		$this->twiggy_display('adm/account_headers/index', $data);
	}

	public function get_data()
	{
		$data = [];
		$get_data = $this->Account_headers_model->get_data()->result();

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'     => $no,
					'id'     => $get_row->account_header_id,
					'number' => $get_row->account_header_number,
					'name'   => $get_row->account_header_name,
					'group'  => $get_row->account_group_name,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function get_data_child()
	{
		$data = [];

		$id		 	= $this->input->post('id');
		$where		= array('a.account_header_id' => $id);

		$get_data 	= $this->Account_headers_model->get_data_child($where)->result();

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'     => $no,
					'id'     => $get_row->account_header_child_id,
					'number' => $get_row->account_header_number . $get_row->account_header_child_number,
					'name'   => $get_row->account_header_child_name,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title    = "Tambah";
		$get_data = array();

		if ($id != 'new') {
			$title    = "Edit";
			$where = array('account_header_id' => $id);
			$get_data = $this->Account_headers_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;
		$data['group_data']      = $this->Account_groups_model->get_data()->result();


		$this->twiggy_display('adm/account_headers/edit', $data);
	}

	public function edit_child($id = 'new', $account_header = '')
	{
		$title    = "Tambah";
		$get_data = array();

		$where    = array('account_header_id' => $account_header);
		$get_data = $this->Account_headers_model->get_data($where)->row_array();

		if ($id != 'new') {
			$title    = "Edit";
			$where = array('account_header_child_id' => $id);
			$get_data = $this->Account_headers_model->get_data_child($where)->row_array();
		}

		$data['id']            = $id;
		$data['account_header_id']      = $get_data['account_header_id'];
		$data['account_header_number']      = $get_data['account_header_number'];
		$data['account_header_name']    = $get_data['account_header_name'];
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/account_headers/edit_child', $data);
	}

	public function save()
	{
		// post
		$id     = $this->input->post('id');
		$number = $this->input->post('number');
		$name   = $this->input->post('name');
		$group  = $this->input->post('group');
		$action = $this->input->post('action');

		$data_save = array(
			'account_header_number' => $number,
			'account_header_name'   => $name,
			'account_group_id'      => $group,
		);

		if ($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Account_headers_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Account_headers_model->update($id, $data_save);
		}

		if ($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		} else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function save_child()
	{
		// post
		$id          = $this->input->post('id');
		$header_id   = $this->input->post('hid');
		$header_name = $this->input->post('hnm');
		$number      = $this->input->post('number');
		$name        = $this->input->post('name');
		$action      = $this->input->post('action');

		$data_save = array(
			'account_header_child_number' => $number,
			'account_header_child_name'   => $name,
			'account_header_id'           => $header_id
		);

		if ($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Account_headers_model->save_child($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Account_headers_model->update_child($id, $data_save);
		}


		// echo $convert;
		// die();
		if ($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert,
				'hid'     => $header_id,
				'hnm'     => $header_name,
			);
		} else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert,
				'hid'     => $header_id,
				'hnm'     => $header_name,
			);
		}

		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_type = $this->Account_headers_model->delete($row);
		}

		if ($delete_type) {
			foreach ($id as $row) {
				$delete_type_child = $this->Account_headers_model->delete_child_account_header($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function delete_child()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_type = $this->Account_headers_model->delete_child($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id()
	{
		$table = 'master_account_headers';
		$name  = $this->input->post('id');
		$where = array('account_header_number' => $name);

		$check = $this->Account_headers_model->check_id($table, $where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

	public function check_child_id()
	{
		$table = 'master_account_header_childs';
		$name  = $this->input->post('id');
		$where = array('account_header_child_number' => $name);

		$check = $this->Account_headers_model->check_id($table, $where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}
}
