<?php
/**
 * Report Debts Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Datalog extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Datalog_model');
		
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Datalog';
        // $data['supplier_data'] = $this->Suppliers_model->get_data()->result();
		
		$this->twiggy_display('adm/datalog/index', $data);
	}

	public function get_data_detail()
	{	
		$search = $this->input->post("search");
// 		$fromdate = $this->input->post("fromdate");
// 		$todate   = $this->input->post("todate");

        $data  = [];
		$where = [];
// 		$order = ("pembelian_header_number ASC");

//         if(isset($supplier) && $supplier != '' && $supplier != '(Semua)')
// 		{
// 			$where['pembelian_header_supplier_id'] = $supplier;
// 		}
// 		if(isset($fromdate) && $fromdate != '')
// 		{
// 			$where['pembelian_header_date >='] = change_format_date($fromdate);
// 		}
// 		if(isset($todate) && $todate != '')
// 		{
// 			$where['pembelian_header_date <='] = change_format_date($todate);
// 		}

// 		$where['status_paid'] = 0;
		
		$get_data = $this->Datalog_model->get_data($search)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
                $utcTime = new DateTime($get_row->Timestamp, new DateTimeZone('UTC'));
                $utcTime->setTimezone(new DateTimeZone('Asia/Jakarta')); // WIB timezone
			    $data[] = array(

					'no'              => $no,
    					'type' => $get_row->Type,
    					'date'   => $utcTime->format('d/m/Y H:i:s'),
    					'nomor'        => $get_row->Nomor,
    					'customer'        => $get_row->customer_name,
    					'item'           => $get_row->Item,
    					'qty'           => $get_row->Qty,
    					'harga'           => number_format($get_row->Harga),
    					'user'           => $get_row->username,
				);
                $no++;
   
			}
		}
	
		output_json($data);
	}



}

?>
