<?php
/**
 * Report Debts Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_debts extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Pembelian_model');
		$this->load->model('Purchase_returns_model');
		$this->load->model('Suppliers_model');
			$this->load->model('Debts_model');
		
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Hutang';
        $data['supplier_data'] = $this->Suppliers_model->get_data()->result();
		
		$this->twiggy_display('adm/report_debts/index', $data);
	}

	public function get_data_detail()
	{	
		$supplier = $this->input->post("supplier");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");

        $data  = [];
		$where = [];
		$order = ("pembelian_header_number ASC");

        if(isset($supplier) && $supplier != '' && $supplier != '(Semua)')
		{
			$where['pembelian_header_supplier_id'] = $supplier;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['pembelian_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['pembelian_header_date <='] = change_format_date($todate);
		}

// 		$where['status_paid'] = 0;
		
		$get_data = $this->Pembelian_model->purchaseorder_header($where, $order)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
    			$where             = array('pembelian_header_id' => $get_row->pembelian_header_id);
    			$where_telah_bayar = array('debt_detail_purchase_order_header_id' => $get_row->pembelian_header_id);
    			$return_total = 0;
    			$paid_total = 0;
    			$disc_total = 0;
    // 			$return_data  = $this->Debts_model->get_sum_retur($where)->row();
    			$paid_data  = $this->Debts_model->get_sum_telah_bayar($where_telah_bayar)->row();
    // 			if ($return_data) {
    // 				$return_total = $return_data->total_retur;
    // 			}
    			if ($paid_data) {
    				$paid_total = $paid_data->total_telah_bayar;
    				$disc_total = $paid_data->total_disc;
    			}
    			$total = ($get_row->pembelian_header_grand_total - $return_total - $paid_total - $disc_total);
				// $total = ($get_row->pembelian_header_grand_total - $return_total);
				if((int)$total > 0){
				    $data[] = array(
    					'no'              => $no,
    					'purchase_number' => $get_row->pembelian_header_number,
    					'purchase_date'   => change_format_date($get_row->pembelian_header_date, 'd/m/Y'),
    					'due_date'        => change_format_date($get_row->pembelian_header_payment_due, 'd/m/Y'),
    					'supplier'        => $get_row->supplier_name,
    					'total'           => number_format($total),
    				);
                    $no++;
				}
			
                
			}
		}
		$this->session->set_userdata('supplier', $supplier);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);

		output_json($data);
	}

	public function export_excel() {

		$supplier = $this->session->userdata('supplier');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order    = ("pembelian_header_number ASC");
		$supplier_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($supplier) && $supplier != '' && $supplier != '(Semua)')
		{
			$where['pembelian_header_supplier_id'] = $supplier;
			$supplier_name = $this->Suppliers_model->get_data(array('supplier_id' => $supplier))->row()->supplier_name;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['pembelian_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['pembelian_header_date <='] = change_format_date($todate);
		}

		$where['status_paid'] = 0;
		
		$get_data = $this->Pembelian_model->purchaseorder_header($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("HUTANG")
							   ->setSubject("HUTANG")
							   ->setDescription("HUTANG")
							   ->setKeywords("HUTANG");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Hutang");
	    $excel->getActiveSheet()->mergeCells('A1:E1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Supplier");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$supplier_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$fromdate_text." - ".$todate_text);

	    $excel->setActiveSheetIndex(0)->setCellValue('A6', "Nomor Pembelian");
	    $excel->setActiveSheetIndex(0)->setCellValue('B6', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('C6', "Jatuh Tempo");
	    $excel->setActiveSheetIndex(0)->setCellValue('D6', "Supplier");
		$excel->setActiveSheetIndex(0)->setCellValue('E6', "Total");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('E6')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 7; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$where        = array('pembelian_header_id' => $get_row->pembelian_header_id);
			$return_total = 0;
			$return_data  = $this->Purchase_returns_model->purchasereturn_header($where)->row();
			if($return_data){
				$return_total = $return_data->purchase_return_header_grand_total;
			}
			$total = ($get_row->pembelian_header_grand_total - $return_total);

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->pembelian_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->pembelian_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, change_format_date($get_row->pembelian_header_payment_due, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->supplier_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, ($total));

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':E'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('E'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HUTANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'HUTANG_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
