<?php
/**
 * Report PPN Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_ppn extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Reports_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function income()
 	{	
        $data['content_title'] = 'Laporan PPN - Masukan';
		
		$this->twiggy_display('adm/report_ppn/income', $data);
	}

	public function outcome()
 	{	
        $data['content_title'] = 'Laporan PPN - Keluaran';
		
		$this->twiggy_display('adm/report_ppn/outcome', $data);
	}

	public function get_data_outcome()
	{	
		$date_1 = $this->input->post("date_1");
		$date_2 = $this->input->post("date_2");

		$data  = [];
		$where = [];
		$total_outcome = 0;

		if(isset($date_1) && $date_1 != '')
		{
			$where['sales_order_header_date >='] = change_format_date($date_1);
		}
		if(isset($date_2) && $date_2 != '')
		{
			$where['sales_order_header_date <='] = change_format_date($date_2);
		}
// 		$where['sales_order_header_ppn_total >'] = 0;
// 		$where['is_hold'] = 0;

		$get_data = $this->Reports_model->get_soheader('', $where, 'sales_order_header_date asc, sales_order_header_number')->result();
		// echo json_encode($get_data);
		// die();
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$data[] = array(
					'no'    => $no,
					'date'  => change_format_date($get_row->sales_order_header_date, 'd/m/Y'),
					'number' => $get_row->sales_order_header_number,
					'total' => number_format($get_row->sales_order_header_ppn_total),
				);
                $no++;
				$total_outcome += $get_row->sales_order_header_ppn_total;
			}
		}

		$response = [
			'data'         => $data,
			'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'total_outcome' => number_format($total_outcome),
		];

		$this->session->set_userdata('date_1', $date_1);
		$this->session->set_userdata('date_2', $date_2);
		$this->session->set_userdata('total_outcome', $total_outcome);

		output_json($response);
	}

	public function get_data_income()
	{	
		$date_1 = $this->input->post("date_1");
		$date_2 = $this->input->post("date_2");

		$data  = [];
		$where = [];
		$total_income = 0;

		if(isset($date_1) && $date_1 != '')
		{
			$where['purchase_order_header_date >='] = change_format_date($date_1);
		}
		if(isset($date_2) && $date_2 != '')
		{
			$where['purchase_order_header_date <='] = change_format_date($date_2);
		}
		$where['purchase_order_header_ppn_total >'] = 0;

		$get_data = $this->Reports_model->get_poheader('', $where, 'purchase_order_header_date asc, purchase_order_header_number')->result();
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$data[] = array(
					'no'     => $no,
					'date'   => change_format_date($get_row->purchase_order_header_date, 'd/m/Y'),
					'number' => $get_row->purchase_order_header_number,
					'total'  => number_format($get_row->purchase_order_header_ppn_total),
				);
                $no++;
				$total_income += $get_row->purchase_order_header_ppn_total;
			}
		}

		$response = [
			'data'         => $data,
			'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'total_income' => number_format($total_income),
		];

		$this->session->set_userdata('date_1', $date_1);
		$this->session->set_userdata('date_2', $date_2);
		$this->session->set_userdata('total_income', $total_income);

		output_json($response);
	}

	public function export_excel_income() {

		$date_1 = $this->session->userdata('date_1');
		$date_2 = $this->session->userdata('date_2');
		$total_income   = $this->session->userdata('total_income');

		$where    = [];
		$order    = ("purchase_order_header_number ASC");
		$supplier_name = '-';

		$date_text1 = ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y'));
		$date_text2 = ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y'));

        if(isset($date_1) && $date_1 != '')
		{
			$where['purchase_order_header_date >='] = change_format_date($date_1);
		}
		if(isset($date_2) && $date_2 != '')
		{
			$where['purchase_order_header_date <='] = change_format_date($date_2);
		}
		$where['purchase_order_header_ppn_total >'] = 0;
		
		$get_data = $this->Reports_model->get_poheader('', $where, 'purchase_order_header_date asc, purchase_order_header_number')->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PPN Masukan")
							   ->setSubject("PPN Masukan")
							   ->setDescription("PPN Masukan")
							   ->setKeywords("PPN Masukan");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		$style_foo = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "PPN Masukan");
	    $excel->getActiveSheet()->mergeCells('A1:C1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$date_text1." - ".$date_text2);

	    $excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('B5', "Nomor");
	    $excel->setActiveSheetIndex(0)->setCellValue('C5', "Masukan");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C5')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 6; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, change_format_date($get_row->purchase_order_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->purchase_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, ($get_row->purchase_order_header_ppn_total));

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':C'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('C'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}

		$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, "Total");
		$excel->getActiveSheet()->mergeCells('A'.$numrow.':B'.$numrow);
		$excel->getActiveSheet()->getStyle('A'.$numrow.':B'.$numrow)->applyFromArray($style_foo);

		// $excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, number_format($total));
		$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $total_income);
		$excel->getActiveSheet()->getStyle('C'.$numrow)->applyFromArray($style_foo);
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HUTANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PPNMasukan_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_excel_outcome() {

		$date_1 = $this->session->userdata('date_1');
		$date_2 = $this->session->userdata('date_2');
		$total_outcome   = $this->session->userdata('total_outcome');

		$where    = [];
		

		$date_text1 = ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y'));
		$date_text2 = ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y'));

        if(isset($date_1) && $date_1 != '')
		{
			$where['sales_order_header_date >='] = change_format_date($date_1);
		}
		if(isset($date_2) && $date_2 != '')
		{
			$where['sales_order_header_date <='] = change_format_date($date_2);
		}
		$where['sales_order_header_ppn_total >'] = 0;
		$where['is_hold'] = 0;

		$get_data = $this->Reports_model->get_soheader('', $where, 'sales_order_header_date asc, sales_order_header_number')->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PPN Keluaran")
							   ->setSubject("PPN Keluaran")
							   ->setDescription("PPN Keluaran")
							   ->setKeywords("PPN Keluaran");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		$style_foo = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "PPN Keluaran");
	    $excel->getActiveSheet()->mergeCells('A1:C1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$date_text1." - ".$date_text2);

	    $excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('B5', "Nomor");
	    $excel->setActiveSheetIndex(0)->setCellValue('C5', "Masukan");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C5')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 6; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, change_format_date($get_row->sales_order_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->sales_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, ($get_row->sales_order_header_ppn_total));

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':C'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('C'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}

		$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, "Total");
		$excel->getActiveSheet()->mergeCells('A'.$numrow.':B'.$numrow);
		$excel->getActiveSheet()->getStyle('A'.$numrow.':B'.$numrow)->applyFromArray($style_foo);

		// $excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, number_format($total));
		$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $total_outcome);
		$excel->getActiveSheet()->getStyle('C'.$numrow)->applyFromArray($style_foo);
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HUTANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PPNKeluaran_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
