<?php
/**
 * Report Profits by Date Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class TrialBalance extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Reports_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Neraca';
		$data['date_now'] =  date_now();
		$this->twiggy_display('adm/trial_balance/index', $data);
	}

	public function get_data_detail()
	{	
		$date_1 = $this->input->post("date_1");
		$date_2 = $this->input->post("date_2");

		$dataDebet  = [];
		$dataKredit  = [];
		
        $total_debet = 0;
        $total_kredit = 0;
	
// 		$get_data_aktiva = $this->Reports_model->get_data_aktiva(change_format_date($date_1), change_format_date($date_2),"")->result();
	    $get_data_debet = $this->Reports_model->get_data_all_account_debet(change_format_date($date_1), change_format_date($date_2),"")->result();
		$get_data_kredit = $this->Reports_model->get_data_all_account_kredit(change_format_date($date_1), change_format_date($date_2),"")->result();
		$total_sales   = 0;
		$total_capital = 0;
		$total_return = 0;
		$total_expense = 0;
		$total_gain = 0;
		$total_hpp = 0;
		$total_margin  = 0;
		$total_return_pembelian = 0;
        $total_sales_return = 0;
        $total_sales_return_pembelian = 0;
        $expense = 0;
       
		foreach($get_data_debet as $get_row_debet)
		{	
		    $dataDebet[] = array(

			'nama_akun'    => $get_row_debet->nama_akun,
			'expense'   => number_format($get_row_debet->total),
		    );
		    $total_debet += $get_row_debet->total;

		}
		foreach($get_data_kredit as $get_row_kredit)
		{	
		    $dataKredit[] = array(

			'nama_akun'    => $get_row_kredit->nama_akun,
			'expense'   => number_format(abs($get_row_kredit->total)),
		    );
		    $total_kredit += abs($get_row_kredit->total);

		}
		
		
			
		$response = [
			'dataAktiva'          => $dataDebet,
			'dataLiabilites'          => $dataKredit,
			'total_aktiva' => number_format($total_debet),
			'total_liabilities'  => number_format(abs($total_kredit)),
		];

		// $this->session->set_userdata('date_1', $date_1);
		// $this->session->set_userdata('date_2', $date_2);
		// $this->session->set_userdata('total_income', $total_income);

		output_json($response);
	}

}

?>
