<?php

/**
 * Point Requirements Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Journals_model extends Model
{

	public function journal_autonumber()
	{
		$sql = $this->db;

		$sql->select('RIGHT(journal_headers.journal_header_number, 4) as serial_number', FALSE);
		$sql->where('MONTH(journal_header_date) = MONTH(CURRENT_DATE())');
		$sql->order_by('journal_header_number', 'DESC');
		$sql->limit(1);
		$query = $sql->get('journal_headers');
		if ($query->num_rows() <> 0) {
			$data = $query->row();
			$serial_number = intval($data->serial_number) + 1;
		} else {
			$serial_number = 0001;
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function journal_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('journal_headers a');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
    // $where = '',
	public function journal_header_advance($where = '',$where2 = '',$where3 = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('journal_headers a');

		if ($where != '' || $where2 != '') {
            $sql->group_start();
            $sql->where('journal_header_trx_type', $where);
            $sql->or_where('journal_header_trx_type', $where2);
            $sql->group_end();
        }
		
		if($where3 != ''){
		    $sql->where($where3);
		}
	

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function journal_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('journal_details a');
		$sql->join('master_accounts b', 'b.account_id = a.journal_detail_account_id', 'inner');

// 		$sql->join('master_account_types c', 'c.account_type_id = b.account_type_id', 'inner');
		$sql->join('master_account_headers d', 'd.account_header_id = b.account_header_id', 'inner');

		$sql->join('master_account_header_childs e', 'e.account_header_child_id = b.account_header_child_id', 'inner');
		$sql->join('master_account_groups f', 'f.account_group_id = d.account_group_id', 'inner');


		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function journal_detail_advance($select_sum = false, $where = '', $order = '', $group_by = '')
	{
		$sql = $this->db;
		if ($select_sum) {
			$sql->select('*, coalesce(sum(journal_detail_debit),0) as ttl_debit, coalesce(sum(journal_detail_credit),0) as ttl_credit');
		} else {
			$sql->select('*');
		}
		$sql->from('journal_details a');
		$sql->join('journal_headers b', 'b.journal_header_id = a.journal_detail_header_id', 'left');
		$sql->join('master_accounts c', 'c.account_id = a.journal_detail_account_id', 'left');

// 		$sql->join('master_account_types d', 'd.account_type_id = c.account_type_id', 'inner');
		$sql->join('master_account_headers e', 'e.account_header_id = c.account_header_id', 'inner');

		$sql->join('master_account_header_childs f', 'f.account_header_child_id = c.account_header_child_id', 'inner');
		$sql->join('master_account_groups g', 'g.account_group_id = e.account_group_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function truncate_header()
	{
		return $this->db->empty_table("journal_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("journal_details");
	}

	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('journal_headers', $data);
		}

		return $this->db->insert('journal_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('journal_details', $data);
		}

		return $this->db->insert('journal_details', $data);
	}

	public function update_header($id, $data)
	{
		$this->db->where('journal_header_id', $id);
		return $this->db->update('journal_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("journal_header_id", $id);
		return $this->db->delete("journal_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("journal_detail_header_id", $id);
		return $this->db->delete("journal_details");
	}

	public function delete_headerbytrxid($id, $type)
	{
		$this->db->where("journal_header_trx_id", $id);
		$this->db->where("journal_header_trx_type", $type);
		return $this->db->delete("journal_headers");
	}

	public function delete_detailbytrxid($id, $type)
	{
		$this->db->where("journal_detail_trx_id", $id);
		$this->db->where("journal_detail_trx_type", $type);
		return $this->db->delete("journal_details");
	}
}
