<?php

/**
 * Purchase Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Stocks_model extends Model
{

	public function stock_autonumber()
	{
		$sql = $this->db;

		$sql->select('RIGHT(stock_headers.stock_header_number, 2) as serial_number', FALSE);
		$sql->where('MONTH(stock_header_date) = MONTH(CURRENT_DATE())');
		// $sql->where('SUBSTR(stock_headers.stock_header_number, 1, 2) = "'.$supp_code.'"');
		$sql->order_by('stock_header_number', 'DESC');
		$sql->limit(1);
		$query = $sql->get('stock_headers');
		if ($query->num_rows() <> 0) {
			$data = $query->row();
			$serial_number = intval($data->serial_number) + 1;
		} else {
			$serial_number = 01;
		}

		$serial_number_generate = str_pad($serial_number, 2, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function stock_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, a.stock_timestamp as tmstamp_so');
		$sql->from('stock_headers a');
		$sql->join('master_warehouses b', 'b.warehouse_id = a.stock_header_warehouse_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function stock_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('stock_details a');
		$sql->join('master_items b', 'b.item_id = a.stock_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function stock_detail_advance($where = '', $order = '', $group_by = '', $where_hed = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('stock_details a');
		$sql->join('stock_headers b', 'b.stock_header_id = a.stock_detail_header_id', 'left');
		$sql->join('master_items c', 'c.item_id = a.stock_detail_item_id', 'left');
		$sql->join('master_suppliers d', 'd.supplier_id = b.stock_header_supplier_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function stock_detail_sum($where = '', $order = '', $group_by = '', $where_hed = '')
	{
		$sql = $this->db;

		$sql->select('*, sum(stock_detail_result_large + stock_detail_result_medium + stock_detail_result_small) as result');
		$sql->from('stock_details a');
		$sql->join('stock_headers b', 'b.stock_header_id = a.stock_detail_header_id', 'left');
		$sql->join('master_items c', 'c.item_id = a.stock_detail_item_id', 'left');
		$sql->join('master_suppliers d', 'd.supplier_id = b.stock_header_supplier_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function stock_headersearch($type = '', $supplier = '', $search = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('stock_headers a');
		// $sql->join('master_suppliers b', 'b.supplier_id = a.stock_header_supplier_id', 'inner');

		if ($search != '') {
			$sql->like('stock_header_number', $search);
			$sql->or_like('stock_header_date', $search);
		}

		$sql->where('stock_header_supplier_id', $supplier);
		$sql->where('status_paid', 0);
		$sql->order_by('stock_header_number ASC');

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('stock_headers', $data);
		}

		return $this->db->insert('stock_headers', $data);
	}
	
	public function save_dump($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('transactionTbl', $data);
		}

		return $this->db->insert('transactionTbl', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('stock_details', $data);
		}

		return $this->db->insert('stock_details', $data);
	}

	public function update_header($id, $data)
	{
		$this->db->where('stock_header_id', $id);
		return $this->db->update('stock_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("stock_header_id", $id);
		return $this->db->delete("stock_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("stock_detail_header_id", $id);
		return $this->db->delete("stock_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("stock_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("stock_details");
	}
}
