/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
 window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
        urlPrintOut: window.APP.siteUrl + 'adm/penerimaan/print_out/',
        urlList: window.APP.siteUrl + 'adm/penerimaan/get_embed',
        urlRequestData: window.APP.siteUrl + 'adm/penerimaan/get_data_detail',
		urlDeleteData: window.APP.siteUrl + 'adm/penerimaan/delete_item',

		// initial
		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: [],
					dataHistory: [],
					ppn_id: '',
					prefix: '',
					number: '',
					ppn_amount: 0,
					overprice: false,
					searchTerm:'',
				},
				computed: {
                    filteredData: function () {
                        var vue = this;
                        return vue.detailData.filter(function (item) {
                            return Object.values(item).some(function (val) {
                                return String(val).toLowerCase().includes(vue.searchTerm.toLowerCase());
                            });
                        });
                    }
                },
				methods: {
					detailAdd: function () {
						// show modal
						$(that.elModal).modal("show");
						
						$.ajax({
							url: that.urlList,
							success: function (response) {
								$(that.elModalC).html(response);
							}
						});

						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								// var ii = $('.check-sub');
								ii.prop('checked', false);

							}, 100);
						}

						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete2: function (row, idx) {
						var vue = this;
							

							Swal.fire({
								title: 'Anda yakin?',
								text: "Ingin menghapus data ini?",
								type: 'warning',
								showCancelButton: true,
								confirmButtonColor: '#3085d6',
								cancelButtonColor: '#d33',
								confirmButtonText: 'Ya, Hapus!',
								cancelButtonText: 'Batal'
							}).then((result) => {
								if (result.value) {
									$.ajax({
										type: "POST",
										dataType: 'json',
										url: that.urlDeleteData,
										data: {
											id: $("#id").val(),
											item: vue.detailData[idx],
											total:row.total
										},
										success: function (response) {
											window.FORM.showNotification(response.message, response.status);
											// parentThis.elDatatable.ajax.reload();
											// console.log("deleted");
											vue.detailData.splice(idx, 1);
										}
									});
								}
							})	
							
						vue.countSubTotal();
					},
					detailHistory: function (row, idx) {
						var vue = this;
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: window.APP.siteUrl + 'adm/penerimaan/get_history_detail',
								data: {
									id: $("#id").val(),
									item_id: vue.detailData[idx]
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									vue.$set(vue, 'dataHistory', response['data']);
								}
							});
					},

                    handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();

                    	$.ajax({
                    		url: that.urlRequestData,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
                    },

					handleNumber: function () {
						var vue = this;

						$("#supplier-select").change(function (e) {
							var id = $(e.target).val();
							$.ajax({
								type: "POST",
								url: window.APP.siteUrl + 'adm/penerimaan/get_autonumber',
								dataType: "JSON",
								data: {
									id: id
								},
								success: function (data) {
								// 	$("#number").val(data['autonumber']);
									$("#payment-due-text").val(data['payment_due']);
								},
							});			
						});
					},
					handlePurchase: function () {
						var vue = this;

						$("#purchase-select").change(function (e) {
							var id = $(e.target).val();
							$.ajax({
								type: "POST",
								url: window.APP.siteUrl + 'adm/penerimaan/get_purchase_detail',
								dataType: "JSON",
								data: {
									id: id
								},
								success: function (data) {
									vue.$set(vue, 'detailData', data['data']);
									
									$('#supplier-select').val(data['supplier']).change();
									$('#warehouse-select').val(data['warehouse']).change();
								// $(that.elVue).unblock();
								},
							});			
						});
					},
				// 	handleHistory: function () {
				// 		var vue = this;

				// 		$("#purchase-select").change(function (e) {
				// 			var id = $(e.target).val();
				// 			$.ajax({
				// 				type: "POST",
				// 				url: window.APP.siteUrl + 'adm/penerimaan/get_history_detail',
				// 				dataType: "JSON",
				// 				data: {
				// 					id: id
				// 				},
				// 				success: function (data) {
				// 					vue.$set(vue, 'dataHistory', data['data']);
									
				// 				// 	$('#supplier-select').val(data['supplier']).change();
				// 				// 	$('#warehouse-select').val(data['warehouse']).change();
				// 				// $(that.elVue).unblock();
				// 				},
				// 			});			
				// 		});
				// 	},
					handleSearch: function () {
						var vue = this;

				// 		$("#purchase-select").change(function (e) {
							var id = $("#purchase-select").val();
							var search = $("#search").val();
							$.ajax({
								type: "POST",
								url: window.APP.siteUrl + 'adm/penerimaan/get_purchase_detail',
								dataType: "JSON",
								data: {
									id: id,
									search:search
								},
								success: function (data) {
									vue.$set(vue, 'detailData', data['data']);
									$('#supplier-select').val(data['supplier']).change();
								// $(that.elVue).unblock();
								},
							});			
				// 		});
					},

					handlePrice: function(row, field_name, value) {
						var vue = this;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						
						vue.$set(row, field_name, value);

						if(field_name == 'lg_unit_prc'){
							if(parseFloat(row.lg_unit_prc.replace(/[^\w\s]/gi, '')) > parseFloat(row.lg_unit_slg.replace(/[^\w\s]/gi, ''))){
								toastr.warning('Harga beli melebihi harga jual!')
								vue.$set(row, 'overprice_lg', 1);
							}else{
								vue.$set(row, 'overprice_lg', 0);
							}
						}

						if(field_name == 'md_unit_prc'){
							if(parseFloat(row.md_unit_prc.replace(/[^\w\s]/gi, '')) > parseFloat(row.md_unit_slg.replace(/[^\w\s]/gi, ''))){
								toastr.warning('Harga beli melebihi harga jual!')
								vue.$set(row, 'overprice_md', 1);
							}else{
								vue.$set(row, 'overprice_md', 0);
							}

							var isi_besar   = row.lg_unit_cnt;
							var isi_sedang  = row.md_unit_cnt;
							var isi_kecil   = row.sm_unit_cnt;
							var harga_sedang = row.md_unit_prc.replace(/[^\w\s]/gi, '');

							
							var harga_kecil  = harga_sedang/isi_sedang;
							var harga_besar = harga_kecil * isi_besar;

							vue.$set(row, 'sm_unit_prc', Math.round(harga_kecil).toLocaleString("en-US"));
							vue.$set(row, 'lg_unit_prc', Math.round(harga_besar).toLocaleString("en-US"));
						}

						if(field_name == 'sm_unit_prc'){
							if(parseFloat(row.sm_unit_prc.replace(/[^\w\s]/gi, '')) > parseFloat(row.sm_unit_slg.replace(/[^\w\s]/gi, ''))){
								toastr.warning('Harga beli melebihi harga jual!')
								vue.$set(row, 'overprice_sm', 1);
							}else{
								vue.$set(row, 'overprice_sm', 0);
							}

							var isi_besar   = row.lg_unit_cnt;
							var isi_sedang  = row.md_unit_cnt;
							var isi_kecil   = row.sm_unit_cnt;
							var harga_kecil = row.sm_unit_prc.replace(/[^\w\s]/gi, '');

							
							var harga_sedang  = harga_kecil * isi_sedang;
							var harga_besar = harga_kecil * isi_besar;

							vue.$set(row, 'md_unit_prc', Math.round(harga_sedang).toLocaleString("en-US"));
							vue.$set(row, 'lg_unit_prc', Math.round(harga_besar).toLocaleString("en-US"));
						}
						
						vue.handleCount(row, field_name, value);
					},
					
					handleCount: function (row, field_name, value) {
						var vue = this;
						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						var discount = 0;
						var sub_total = 0;
						
				// 		if(row.lg_unit_qty_po != 0){
				// 		    if(row.lg_unit_qty > row.lg_unit_qty_po){
    // 						    toastr.warning('Qty terima melebihi qty po');
    // 						    console.log(row.lg_unit_qty_po);
    // 						  //  row.lg_unit_qty = row.lg_unit_qty_po;
    // 						  //  vue.$set(row, 'lg_unit_qty', row.lg_unit_qty_po);
    // 							vue.$set(row, 'overprice_lg', 1);
    // 							console.log(row.lg_unit_qty);
    // 						}else{
    // 						  //  vue.$set(row, 'lg_unit_qty', row.lg_unit_qty);
    // 							vue.$set(row, 'overprice_lg', 0);
    // 						}
    						
    // 						if(row.md_unit_qty > row.md_unit_qty_po){
    // 						    toastr.warning('Qty terima melebihi qty po')
    // 							vue.$set(row, 'md_unit_qty', row.md_unit_qty_po);
    // 						}
				// 		}

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);

							if(row.sm_unit_cnt > 0){
								auto_smprc = (row.lg_unit_prc.replace(/[^\w\s]/gi, '') / row.lg_unit_cnt);
								auto_mdprc = (auto_smprc * row.md_unit_cnt);

								vue.$set(row, 'sm_unit_prc', Math.round(auto_smprc).toLocaleString("en-US"));
								vue.$set(row, 'md_unit_prc', Math.round(auto_mdprc).toLocaleString("en-US"));

								result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
								vue.$set(row, 'result_small', result_small);
								result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
								vue.$set(row, 'result_medium', result_medium);
							}else if(row.md_unit_cnt > 0 && row.sm_unit_cnt == 0){
								auto_mdprc = (row.lg_unit_prc.replace(/[^\w\s]/gi, '') / row.lg_unit_cnt);
								vue.$set(row, 'md_unit_prc', Math.round(auto_mdprc).toLocaleString("en-US"));
								vue.$set(row, 'sm_unit_prc', 0);

								result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
								vue.$set(row, 'result_medium', result_medium);
							}else{
								vue.$set(row, 'sm_unit_prc', 0);
								vue.$set(row, 'md_unit_prc', 0);
							}
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);

							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);

							if(row.sm_unit_cnt > 0){
								result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
								vue.$set(row, 'result_small', result_small);
							}
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);

							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);
							
							result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_small', result_small);
						}

						// result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						// result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						// result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));
						vue.$set(row, 'subtotal', total.toLocaleString("en-US"));
				// 		var discount1 = parseInt(total) * row.disc1 / 100;
				// 	    total -= discount1;
				// 	    console.log(total);
				// 	    var discount2 = parseInt(total) * row.disc2 / 100;
				// 	    total -= discount2;
				// 	    console.log(total);
				// 	    var discount3 = parseInt(total) * row.disc3 / 100;
				// 		total -= discount3;
				// 		discount = total * row.discount / 100;
						sub_total = total;
						vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
						vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));
						console.log(row.lg_unit_qty);
						console.log(sub_total);
						// vue.$set(row, 'total', total.toLocaleString("en-US"));
						vue.$set(row, field_name, value);
					},

					countSubTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}

						return totalAmmount.toLocaleString("en-US");
					},

					handleCheckboxPPN: function () {
						var vue = this;
						// var a = $("#ppn_id").val();
						
						vue.countGrandTotal();
					},
					
					countGrandTotal: function () {
						var vue = this;

						// var ppn_amount = $('#ppn_amount').val();
						var totalAmmount = 0;
						var ppnTotal = 0;
						var grandTotal = 0;
						var items = vue.detailData;

						var id = $("#id").val();

						$.ajax({
                    		url: window.APP.siteUrl + 'adm/penerimaan/get_data_ppn',
							type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
                    		success: function (response) {
								vue.$set(vue, 'ppn_amount', response);
                    		}
                    	});

						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}
						
						if(vue.ppn_id == true){
							ppnTotal = totalAmmount * (vue.ppn_amount/100);
							grandTotal = (totalAmmount + ppnTotal);
						}else{
							ppnTotal = 0;
							grandTotal = (totalAmmount + ppnTotal);
						}
						if ($("#ppn_id").val() == "1") {
							$("#ppn_id").val("1");
						}else{
							$("#ppn_id").val("0");
						}
						$("#ppn_total").val(ppnTotal.toLocaleString("en-US"));
						return grandTotal.toLocaleString("en-US");
					},

					countOverprice: function () {
						var vue = this;

						var grandTotal = 0;
						var totalAmmountLg = 0;
						var totalAmmountMd = 0;
						var totalAmmountSm = 0;
						var items = vue.detailData;

						for (var i in items) {
							totalAmmountLg += (Number(items[i].overprice_lg));
							totalAmmountMd += (Number(items[i].overprice_md));
							totalAmmountSm += (Number(items[i].overprice_sm));
						}
						
						grandTotal = (totalAmmountLg + totalAmmountMd + totalAmmountSm);

						if(Number(grandTotal) > 0){
							vue.$set(vue, 'overprice', true);
						}else{
							vue.$set(vue, 'overprice', false);
						}

						return Number(grandTotal);
					},

					handleCheckbox: function () {

						$('#edit-table').on('click', '#check-sub', function () {
							var row     = ($('#edit-table tr').length - 2);
							var checked = $('#edit-table').find('input[class="check-sub"]:checked');
			
							if(row == checked.length){
								$('#check-all').prop('checked', true);
							}else{
								$('#check-all').prop('checked', false);
							}
						});
			
					},

					handleForm2: function () {
						var vue = this;
			
						window.DATETIME.initDatePicker();
			
						$(that.elForm).validate();
			
						$(that.elForm).ajaxForm({
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
								$("#savebutton").attr('disabled','disabled');
			
								if (vue.detailData.length == 0) {
									toastr.warning('Silahkan isi data terlebih dahulu!')
									$(that.elVue).unblock();
									return false;
								}
							},
							data: {
								vuedata: vue.detailData
							},
							dataType: "json",
							success: function (response) {
								$(that.elVue).unblock();

								window.FORM.showNotification(response.message, response.status);

								if (response.status == "success") {
									
									setTimeout(function () {
									    setTimeout(function () {
										window.location.href = window.APP.siteUrl + 'adm/penerimaan/export_excel/'+response.id
									    }, 1500);
										window.location.href = window.APP.siteUrl + 'adm/penerimaan/'
									}, 500);
								}
			
							}
						});
			
					},
                     
				},
				mounted: function () {
                    var vue = this;
					var id = $("#id").val();
					
					$.ajax({
						url: window.APP.siteUrl + 'adm/penerimaan/get_data_ppn',
						success: function (response) {
							vue.$set(vue, 'ppn_amount', response);
						}
					});
					
                    if(id != 'new'){
						vue.handleData();
					}
					vue.handleNumber();
					vue.handlePurchase();
				// 	vue.handleHistory();
					vue.handleCheckbox();
					
					setTimeout(function () {
						// $(that.elForm).validate();

						// $(that.elVue).block({
						// 	message: '<h4>Please Wait..</h4>'
						// });

						that.handleForm();
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);
						
						var ppn_id = $("#ppn_id").val();
						if(ppn_id == "1"){
							$("#ppn_id").attr("checked", true);
							vue.$set(vue, 'ppn_id', true);
						}else{
							$("#ppn_id").attr("checked", false);
							vue.$set(vue, 'ppn_id', false);
						}

						// $(that.elVue).unblock();
					}, 1500);
				}
			});

		},

		// form
		handleForm: function () {
			var that = this;

			window.DATETIME.initDatePicker();

			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				beforeSend: function () {
					$(that.elVue).block({
						message: '<h4>Please Wait..</h4>'
					});

					if (that.initVue.detailData.length == 0) {
						toastr.warning('Silahkan isi data terlebih dahulu!')
						$(that.elVue).unblock();
						return false;
					}
				},
				data: {
					vuedata: that.initVue.detailData
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					window.FORM.showNotification(response.message, response.status);

					// if (response.status == "success") {
					// 	setTimeout(function () {
					// 		window.location.href = window.APP.siteUrl + 'adm/penerimaan/'
					// 	}, 1500);
					// }

				}
			});

        },
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);