/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elCustomer: '.select-customer',
		elFromDate: '.fromdate',
		elToDate: '.todate',
		elModal: ".master-modal",
		elModalC: ".master-modal-content",
		elUser: '.select-user',

urlHistory: window.APP.siteUrl + 'adm/Report_pembayaran_credits/history',

		urlRequestData: window.APP.siteUrl + 'adm/Report_pembayaran_credits/get_data_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					customer: '',
					fromdate: '',
					grand_total: '',
					todate: '',
					detailData: [],
					searchTerm:'',
				},
				computed: {
                    filteredData: function () {
                        var vue = this;
                        return vue.detailData.filter(function (item) {
                            return Object.values(item).some(function (val) {
                                return String(val).toLowerCase().includes(vue.searchTerm.toLowerCase());
                            });
                        });
                    }
                },
				methods: {
				    detailAdd: function (id) {
						// show modal
						$(that.elModal).modal("show");
						
						$.ajax({
							url: that.urlHistory + '/'+id,
							success: function (response) {
								$(that.elModalC).html(response);
							}
						});

						$('input[type="checkbox"]').prop('checked', false);
					},
					getData: function () {
						var vue = this;
						var val_customer  = $(that.elCustomer).val();
						var val_fromdate      = $(that.elFromDate).val();
						var val_todate      = $(that.elToDate).val();
						var val_user  = $(that.elUser).val();


						var text_customer = $(that.elCustomer + ' option:selected').text();
						
						vue.$set(vue, 'customer', text_customer);
						// vue.$set(vue, 'date', val_date);

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'customer': val_customer,
								'user':val_user,
								'fromdate': val_fromdate,
								'todate'  : val_todate
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response['data']);
								vue.$set(vue, 'grand_total', response['grand_total']);
								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/Report_pembayaran_credits/export_excel';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);