<?php
/**
 * Report Graduations Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Rep_graduations extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Reports_model');

		$this->load->model('Batches_model');
		$this->load->model('Programs_model');
		$this->load->model('Trainees_model');
		$this->load->model('Companies_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Kelulusan';
         
 		$data['batch_data']   = $this->Reports_model->get_batches_header_select()->result();
 		$data['program_data'] = $this->Reports_model->get_program_header_select()->result();
 		$data['trainee_data'] = $this->Trainees_model->get_data()->result();
 		$data['company_data'] = $this->Companies_model->get_data()->result();
		
		if(check_roles('1') or check_roles('3')){
			$this->twiggy_display('adm/rep_graduations/index', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data_batch()
	{
		$program_name = $this->input->post('program_name');

		$where = [];
		$group_by = 'batch_header_name';
		$order_by = 'batch_year asc, batch_number';

		if(isset($program_name) && $program_name != '' && $program_name != '(Semua)')
		{
			$where['program_header_name'] = trim($program_name);
		}
		
		$result = $this->Reports_model->get_select_advance($where, $group_by, $order_by)->result();
		
		echo json_encode($result);
	}

	public function get_data_company()
	{
		$program_name = $this->input->post('program_name');
		$batch_name = $this->input->post('batch_name');

		$where = [];
		$group_by = 'x.company_id';
		$order_by = 'f.company_name';
		
		if(isset($program_name) && $program_name != '' && $program_name != '(Semua)')
		{
			$where['program_header_name'] = trim($program_name);
		}

		if(isset($batch_name) && $batch_name != '' && $batch_name != '(Semua)')
		{
			$where['a.batch_header_name'] = trim($batch_name);
		}
		
		$result = $this->Reports_model->get_select_advance($where, $group_by, $order_by)->result();
		
		echo json_encode($result);
	}

	public function get_data_trainee()
	{
		$program_name = $this->input->post('program_name');
		$batch_name = $this->input->post('batch_name');
		$company_name = $this->input->post('company_name');

		$where = [];
		$group_by = 'x.trainee_id';
		$order_by = 'e.trainee_name';
		
		if(isset($program_name) && $program_name != '' && $program_name != '(Semua)')
		{
			$where['program_header_name'] = trim($program_name);
		}

		if(isset($batch_name) && $batch_name != '' && $batch_name != '(Semua)')
		{
			$where['a.batch_header_name'] = trim($batch_name);
		}

		if(isset($company_name) && $company_name != '' && $company_name != '(Semua)')
		{
			$where['f.company_name'] = trim($company_name);
		}
		
		$result = $this->Reports_model->get_select_advance($where, $group_by, $order_by)->result();
		
		echo json_encode($result);
	}

	public function get_data_detail()
	{	
		$batch   = $this->input->post("batch");
		$program = $this->input->post("program");
		$trainee = $this->input->post("trainee");
		$company = $this->input->post("company");
		$status  = $this->input->post("status");

		$where = [];
		if(isset($batch) && $batch != '' && $batch != '(Semua)')
		{
			$where['b.batch_header_name'] = trim($batch);
		}
		// if(isset($program) && $program != '')
		// {
		// 	$where['a.program_id'] = $program;
		// }
		if(isset($program) && $program != '' && $program != '(Semua)')
		{
			$where['c.program_header_name'] = trim($program);
        }
		if(isset($trainee) && $trainee != '')
		{
			$where['a.trainee_id'] = $trainee;
		}
		if(isset($company) && $company != '')
		{
			$where['a.company_id'] = $company;
		}
		if(isset($status) && $status != '')
		{
			$where['a.status'] = $status;
		}

		$data = [];
		$get_data = $this->Reports_model->get_graduations_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$status = ($get_row->status == 1 ? "Lulus" : "Belum Lulus");
				$info   = ($get_row->late == 1 ? "Melewati masa belajar" : "");

				$data[] = array(
					'no'      => $no,
					'batch'   => $get_row->batch_header_name,
					'program' => $get_row->program_header_name,
					'trainee' => $get_row->trainee_name,
					'company' => $get_row->company_name,
					'info_detail' => $get_row->info,
					'certificate_number' => $get_row->certificate_number,
					'status'  => $status,
					'info'    => $info,
				);
				$no++;
			}
		}
		$this->session->set_userdata('where', $where);

		output_json($data);
	}

	public function export_excel() {

		$where = $this->session->userdata('where');

		$get_data = $this->Reports_model->get_graduations_detail($where)->result();

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('LOOP INDONESIA')
							   ->setLastModifiedBy('LOOP INDONESIA')
							   ->setTitle("KELULUSAN")
							   ->setSubject("KELULUSAN")
							   ->setDescription("KELULUSAN")
							   ->setKeywords("KELULUSAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "KELULUSAN");
	    $excel->getActiveSheet()->mergeCells('A1:I1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

	    // Buat header tabel pada baris ke 3
	    $excel->setActiveSheetIndex(0)->setCellValue('A3', "No");
	    $excel->setActiveSheetIndex(0)->setCellValue('B3', "Batch");
	    $excel->setActiveSheetIndex(0)->setCellValue('C3', "Program");
	    $excel->setActiveSheetIndex(0)->setCellValue('D3', "Peserta");
	    $excel->setActiveSheetIndex(0)->setCellValue('E3', "Perusahaan");
	    $excel->setActiveSheetIndex(0)->setCellValue('F3', "Status");
	    $excel->setActiveSheetIndex(0)->setCellValue('G3', "No. Sertifikat");
		$excel->setActiveSheetIndex(0)->setCellValue('H3', "Keterangan");
		$excel->setActiveSheetIndex(0)->setCellValue('I3', "Info");

	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('F3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('G3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H3')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I3')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 4; // Set baris pertama untuk isi tabel adalah baris ke 4
	    foreach($get_data as $row){ // Lakukan looping pada variabel row
			$status = ($row->status == 1 ? "Lulus" : "Belum Lulus");
			$info   = ($row->late == 1 ? "Melewati masa belajar" : "");

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $row->batch_header_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $row->program_header_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $row->trainee_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $row->company_name);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $status);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $row->certificate_number);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $row->info);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $info);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
	    	$excel->getActiveSheet()->getStyle('A'.$numrow.':I'.$numrow)->applyFromArray($style_row);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		 }
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("KELULUSAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'KELULUSAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
