<?php
/**
 * Sales Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Sales_orders extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model

		$this->load->model('Transfer_model');
		$this->load->model('Warehouses_model');

		$this->load->model('Sales_orders_model');
		$this->load->model('Configuration_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
		$this->load->model('Logs_model');
		$this->load->model('Wholesale_prices_model');
		$this->load->model('Special_prices_model');
		$this->load->model('Ptsreqs_model');
		$this->load->model('Log_points_model');
		$this->load->model('Users_model');
		$this->load->model('Ppn_model');
		$this->load->model('Group_prices_model');

		$this->load->model('Groups_model');
		$this->load->model('Units_model');
		$this->load->model('Users_model');

	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Penjualan';
		
		$this->twiggy_display('adm/sales_orders/index', $data);
	}
	 
	public function get_data_header()
	{	
		$data = [];
		// $order = "is_hold DESC";
		$order = "is_hold DESC, sales_order_header_date DESC, sales_order_header_number DESC";
		$get_data = $this->Sales_orders_model->salesorder_header('', $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$is_hold = ($get_row->is_hold == 0 ? '<i class="fas fa-circle text-success"></i>' : '<i class="fas fa-circle text-warning"></i>');

				$fak_1 = ($get_row->faktur_1 == "0" ? "" : $get_row->faktur_1);
				$fak_2 = ($get_row->faktur_2 == "0" ? "" : $get_row->faktur_2);
				$fak_3 = ($get_row->faktur_3 == "0" ? "" : $get_row->faktur_3);

				$faktur = trim($fak_1.", ".$fak_2.", ".$fak_3, ", ");

				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->sales_order_header_id,
					'number'      => $get_row->sales_order_header_number,
					'faktur'      => $faktur,
					'date'        => indonesian_date($get_row->sales_order_header_date),
					'date_paid'   => indonesian_date($get_row->printed_date),
					'customer'    => $get_row->customer_name,
					'grand_total' => number_format($get_row->sales_order_header_grand_total),
					'description' => $get_row->sales_order_header_description,
					'is_hold'     => $is_hold,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

	public function get_payment_term()
	{
		$customer         = $this->input->post('customer');
		$sales_order_date = change_format_date($this->input->post('sales_order_date'));

		$where        = array('customer_id' => $customer);
		$payment_term = $this->Customers_model->get_data($where)->row()->customer_payment_term;
		$payment_due  = date("Y-m-d", strtotime('+' ."$payment_term". ' days', strtotime($sales_order_date)));
		
		$response = [
            'payment_term' => $payment_term,
            'payment_due'  => change_format_date($payment_due, 'd/m/Y')
		];
		
		echo json_encode($response);
	}

	public function get_payment_term_by_days()
	{
		$payment_term     = $this->input->post('payment_term');
		$sales_order_date = change_format_date($this->input->post('sales_order_date'));

		$payment_due  = date("Y-m-d", strtotime('+' ."$payment_term". ' days', strtotime($sales_order_date)));
		
		$response = [
            'payment_due'  => change_format_date($payment_due, 'd/m/Y')
		];
		
		echo json_encode($response);
	}

	public function get_wholesale_price()
	{
		$customer       = $this->input->post('customer');
		$item           = $this->input->post('item');
		$quantity_large = $this->input->post('quantity_large');

		$where_special_price    = array('a.customer_id' => $customer, 'a.item_id' => $item);
		$get_data_special_price = $this->Special_prices_model->get_data($where_special_price)->result();

		$group_customer_id    = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->group_customer_id;
		$where_group_price    = array('a.group_customer_id' => $group_customer_id, 'a.item_id' => $item, 'a.price !=' => 0);
		$get_data_group_price = $this->Group_prices_model->get_data_group_price($where_group_price)->row();

		// echo json_encode($get_data_group_price);
		// die();
		$price = 0;
		if(!empty($get_data_group_price)){
			return false;
		}elseif(!empty($get_data_special_price)){
			return false;
		}else{
			$get_wholesale_price = $this->Wholesale_prices_model->get_data_range($item, $quantity_large)->row_array();
			if(!empty($get_wholesale_price)){
				$price = $get_wholesale_price['price'];
			}else{
				$where_last_price    = array('item_id' => $item);
				$get_data_last_price = $this->Items_model->get_data($where_last_price)->row_array();
				$price               = $get_data_last_price['last_selling_price_large_unit'];
			}
			echo json_encode(number_format($price));
		}
	}

 	public function edit($id = 'new')
	{
		$title = "Tambah Penjualan";
		$header_data = array(null);

		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));

		$prefix  = "J";
		$datenow = date('ym');
		$number_generator = $this->Sales_orders_model->salesorder_autonumber();
		$autonumber = $prefix.$datenow.'-'.$number_generator;

		$date_text       = date_now();
		$printed_date_text = date_now();
		$paid_total      = 0;
		$change_total    = 0;
		$remaining_total = 0;

		$tmstamp   = date("H:i:s");

	    if($id != 'new')
	    {
			$title           = "Edit Penjualan";
			$where           = array('sales_order_header_id' => $id);
			$header_data     = $this->Sales_orders_model->salesorder_header($where)->row_array();
			$autonumber      = $header_data['sales_order_header_number'];
			$date_text       = $header_data['sales_order_header_date'];
			$printed_date_text = $header_data['printed_date'];
			$paid_total      = number_format($header_data['sales_order_header_paid_total']);
			$change_total    = number_format($header_data['sales_order_header_change_total']);
			$remaining_total = number_format($header_data['sales_order_header_remaining_total']);
			$tmstamp     = time24($header_data['tmstamp_so']);
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['customer_data'] = $this->Customers_model->get_data()->result();

		
		$data['autonumber']      = $autonumber;
		$data['date_text']       = $date_text;
		$data['printed_date_text']       = $printed_date_text;
		$data['paid_total']      = $paid_total;
		$data['change_total']    = $change_total;
		$data['remaining_total'] = $remaining_total;
		$data['ppn_amount']      = $ppn_amount;
		$data['tmstamp']    = $tmstamp;

		$this->twiggy_display('adm/sales_orders/edit', $data);
	}

	public function get_data_ppn()
	{
		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : $ppn_data->amount);

		echo json_encode(to_decimal($ppn_amount));
	}

	public function get_data_detail()
	{	
		$id    = $this->input->post("id");
		$where = array('sales_order_detail_header_id' => $id);
		// $order = array('item_name' => 'asc');

		$data = [];
		$is_hold  = $this->Sales_orders_model->salesorder_header(array('sales_order_header_id' => $id))->row()->is_hold;
		$get_data = $this->Sales_orders_model->salesorder_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if(count($get_data) > 0)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				// $total_stock     = 0;
				// $where_stock     = array('log_item_id' => $get_row->item_id);
				// $get_data_stock  = $this->Logs_model->get_data_last($where_stock)->row_array();
				// if($get_data_stock){
				// 	$total_stock = $get_data_stock['log_total_stock'];
				// }
				
				$in_stock = 0;
				$ou_stock = 0;
				$total_stock = 0;

				$warehouse = $this->Warehouses_model->get_data(array('is_default' => 1))->row()->warehouse_id;

				$get_stock_in = $this->Transfer_model->transfer_advance(array('header_to' => $warehouse, 'item_id' => $get_row->item_id), 'item_id, header_to')->row();
				$get_stock_ou = $this->Transfer_model->transfer_advance(array('header_from' => $warehouse, 'item_id' => $get_row->item_id), 'item_id, header_from')->row();

				if($get_stock_in){
					$in_stock = (($get_stock_in->large_qty * $get_row->large_unit_contain) + ($get_stock_in->medium_qty * $get_row->medium_unit_contain) + ($get_stock_in->small_qty * $get_row->small_unit_contain));
				}

				if($get_stock_ou){
					$ou_stock = (($get_stock_ou->large_qty * $get_row->large_unit_contain) + ($get_stock_ou->medium_qty * $get_row->medium_unit_contain) + ($get_stock_ou->small_qty * $get_row->small_unit_contain));
				}

				$total_stock = $in_stock - $ou_stock;
				
				$ppn_status_color = "";
				if($get_row->sales_order_detail_ppn_status == '1'){
					$ppn_status_color = "";
				}elseif($get_row->sales_order_detail_ppn_status == '2'){
					$ppn_status_color = "bg-success";
				}else{
					$ppn_status_color = "bg-warning";
				}

				$total_stock_stored = ($total_stock + (($get_row->sales_order_detail_large_unit_quantity * $get_row->large_unit_contain) +
										($get_row->sales_order_detail_medium_unit_quantity * $get_row->medium_unit_contain) +
										($get_row->sales_order_detail_small_unit_quantity * $get_row->small_unit_contain)));
										
				$dsctype = 'B';
				if($get_row->sales_order_detail_large_unit_discount > 0){
					$dsctype = 'B';
				}elseif($get_row->sales_order_detail_medium_unit_discount > 0){
					$dsctype = 'S';
				}else{
					$dsctype = 'K';
				}

				$therest      = $total_stock;
				$total_large  = ($get_row->large_unit_contain == 0 ? '0' : floor($total_stock / $get_row->large_unit_contain));
				$therest      = ($therest - ($total_large * $get_row->large_unit_contain));
				$total_medium = ($get_row->medium_unit_contain == 0 ? '0' : floor($therest / $get_row->medium_unit_contain));
				$therest      = ($therest - ($total_medium * $get_row->medium_unit_contain));
				$total_small  = ($get_row->small_unit_contain == 0 ? '0' : floor($therest / $get_row->small_unit_contain));
				
				$data[] = array(
					'no'                 => $no,
					'detail_id'          => $get_row->sales_order_detail_id,
					'detail_header_id'   => $get_row->sales_order_detail_header_id,
					'id'                 => $get_row->sales_order_detail_item_id,
					'name'               => $get_row->sales_order_detail_item_name,
					'lg_unit'            => $get_row->sales_order_detail_large_unit,
					'lg_unit_cnt'        => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty'        => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'lg_unit_qtys'        => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'lg_unit_prc'        => number_format($get_row->sales_order_detail_large_unit_price + $get_row->sales_order_detail_large_unit_discount),
					'result_large'       => $get_row->sales_order_detail_result_large,
					'md_unit'            => $get_row->sales_order_detail_medium_unit,
					'md_unit_cnt'        => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty'        => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'md_unit_qtys'        => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'md_unit_prc'        => number_format($get_row->sales_order_detail_medium_unit_price + $get_row->sales_order_detail_medium_unit_discount),
					'result_medium'      => $get_row->sales_order_detail_result_medium,
					'sm_unit'            => $get_row->sales_order_detail_small_unit,
					'sm_unit_cnt'        => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty'        => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'sm_unit_qtys'        => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'sm_unit_prc'        => number_format($get_row->sales_order_detail_small_unit_price + $get_row->sales_order_detail_small_unit_discount),
					'result_small'       => $get_row->sales_order_detail_result_small,
					'ppn_status'         => $get_row->sales_order_detail_ppn_status,
					'ppn_status_color'   => $ppn_status_color,
					'total'              => number_format($get_row->sales_order_detail_total),
					'ppn_total'          => to_decimal($get_row->sales_order_detail_ppn_total),
					'total_stock'        => to_decimal($total_stock),
					'total_stock_stored' => to_decimal($total_stock_stored),
					'lg_unit_dsc'        => number_format($get_row->sales_order_detail_large_unit_discount),
					'md_unit_dsc'        => number_format($get_row->sales_order_detail_medium_unit_discount),
					'sm_unit_dsc'        => number_format($get_row->sales_order_detail_small_unit_discount),
					'dsctype' => $dsctype,
					'ttls_lg' => $total_large,
					'ttls_md' => $total_medium,
					'ttls_sm' => $total_small,
				);
				$no++;
			}
		}else{
			$where_header   = array('sales_order_header_id' => $id);
			$header         = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
			$tax_percentage = $header['ppn_amount'];

			$where_restore = array('log_type' => 'SELL', 'log_transaction_id' => $id);
			$restore       = $this->Logs_model->get_data($where_restore)->result();

			$no = 1;
			foreach($restore as $get_row)
			{
				
				$total_stock     = 0;
				$where_stock     = array('log_item_id' => $get_row->log_item_id);
				$get_data_stock  = $this->Logs_model->get_data_last($where_stock)->row_array();
				if($get_data_stock){
					$total_stock = $get_data_stock['log_total_stock'];
				}

				$ppn_status_color = "";
				if($get_row->ppn_status == '1'){
					$ppn_status_color = "";
				}elseif($get_row->ppn_status == '2'){
					$ppn_status_color = "bg-success";
				}else{
					$ppn_status_color = "bg-warning";
				}

				$total_stock_stored = ($total_stock + ((abs($get_row->log_large_unit_quantity) * $get_row->log_large_unit_contain) +
										(abs($get_row->log_medium_unit_quantity) * $get_row->log_medium_unit_contain) +
										(abs($get_row->log_small_unit_quantity) * $get_row->log_small_unit_contain)));

				$res_lg = abs($get_row->log_large_unit_quantity) * $get_row->log_large_unit_selling_price;
				$res_md = abs($get_row->log_medium_unit_quantity) * $get_row->log_medium_unit_selling_price;
				$res_sm = abs($get_row->log_small_unit_quantity) * $get_row->log_small_unit_selling_price;

				$res_total = $res_lg + $res_md + $res_sm;

				$grand_total = $res_total;
				$ppn_total = 0;
				
				if($get_row->ppn_status == 2){
					$grand_total = $res_total + ($res_total * ($tax_percentage/100));
					$ppn_total = ($res_total * ($tax_percentage/100));
				}

				$data[] = array(
					'no'                 => $no,
					'detail_id'          => $get_row->log_id,
					'detail_header_id'   => $get_row->log_transaction_id,
					'id'                 => $get_row->log_item_id,
					'name'               => $get_row->item_name,
					'lg_unit'            => $get_row->log_large_unit,
					'lg_unit_cnt'        => to_decimal($get_row->log_large_unit_contain),
					'lg_unit_qty'        => to_decimal(abs($get_row->log_large_unit_quantity)),
					'lg_unit_prc'        => number_format($get_row->log_large_unit_selling_price),

					'result_large'       => $res_lg,

					'md_unit'            => $get_row->log_medium_unit,
					'md_unit_cnt'        => to_decimal($get_row->log_medium_unit_contain),
					'md_unit_qty'        => to_decimal(abs($get_row->log_medium_unit_quantity)),
					'md_unit_prc'        => number_format($get_row->log_medium_unit_selling_price),

					'result_medium'      => $res_md,

					'sm_unit'            => $get_row->log_small_unit,
					'sm_unit_cnt'        => to_decimal($get_row->log_small_unit_contain),
					'sm_unit_qty'        => to_decimal(abs($get_row->log_small_unit_quantity)),
					'sm_unit_prc'        => number_format($get_row->log_small_unit_selling_price),

					'result_small'       => $res_sm,

					'ppn_status'         => $get_row->ppn_status,
					'ppn_status_color'   => $ppn_status_color,

					'total'              => number_format($grand_total),

					'ppn_total'          => to_decimal($ppn_total),

					'total_stock'        => to_decimal($total_stock),
					'total_stock_stored' => to_decimal($total_stock_stored),
				);
				$no++;
			}

		}

		$response = [
            'data'         => $data,
			'isHold'       => $is_hold,
            'recordsTotal' => count($data)
        ];

        output_json($response);

		// output_json($data);
	}

	public function get_data_detail2()
	{	
		$id    = $this->input->post("id");
		$where = array('sales_order_detail_header_id' => $id);
		// $order = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Sales_orders_model->salesorder_detail_ori($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
			$no = 1;
			foreach($get_data as $get_row)
			{

				$total_stock     = 0;
				$where_stock     = array('log_item_id' => $get_row->item_id);
				$get_data_stock  = $this->Logs_model->get_data_last($where_stock)->row_array();
				if($get_data_stock){
					$total_stock = $get_data_stock['log_total_stock'];
				}

				$ppn_status_color = "";
				if($get_row->sales_order_detail_ppn_status == '1'){
					$ppn_status_color = "";
				}elseif($get_row->sales_order_detail_ppn_status == '2'){
					$ppn_status_color = "bg-success";
				}else{
					$ppn_status_color = "bg-warning";
				}

				$total_stock_stored = ($total_stock + (($get_row->sales_order_detail_large_unit_quantity * $get_row->large_unit_contain) +
										($get_row->sales_order_detail_medium_unit_quantity * $get_row->medium_unit_contain) +
										($get_row->sales_order_detail_small_unit_quantity * $get_row->small_unit_contain)));
				$data[] = array(
					'no'                 => $no,
					'detail_id'          => $get_row->sales_order_detail_id,
					'detail_header_id'   => $get_row->sales_order_detail_header_id,
					'id'                 => $get_row->sales_order_detail_item_id,
					'name'               => $get_row->sales_order_detail_item_name,
					'lg_unit'            => $get_row->sales_order_detail_large_unit,
					'lg_unit_cnt'        => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty'        => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'lg_unit_prc'        => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'       => $get_row->sales_order_detail_result_large,
					'md_unit'            => $get_row->sales_order_detail_medium_unit,
					'md_unit_cnt'        => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty'        => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'md_unit_prc'        => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'      => $get_row->sales_order_detail_result_medium,
					'sm_unit'            => $get_row->sales_order_detail_small_unit,
					'sm_unit_cnt'        => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty'        => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'sm_unit_prc'        => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'       => $get_row->sales_order_detail_result_small,
					'ppn_status'         => $get_row->sales_order_detail_ppn_status,
					'ppn_status_color'   => $ppn_status_color,
					'total'              => number_format($get_row->sales_order_detail_total),
					'ppn_total'          => to_decimal($get_row->sales_order_detail_ppn_total),
					'total_stock'        => to_decimal($total_stock),
					'total_stock_stored' => to_decimal($total_stock_stored),
				);
				$no++;
			}


		output_json($data);
	}

	public function get_embed()
	{
		$data = [];

		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));

		$data['content_title'] = 'Data Barang';
		$data['ppn_amount']    = $ppn_amount;
		$this->twiggy_display('adm/sales_orders/embed', $data);
	}

	public function get_data_embed()
	{
		$data     = [];
		$response = [];
		$search   = $this->input->post('search');
		$customer = $this->input->post('customer');

		$get_data = $this->Items_model->get_data_search($search)->result();

		$no = 0;
		foreach($get_data as $get_row)
		{	
			$large_unit_price  = $get_row->last_selling_price_large_unit;
			$medium_unit_price = $get_row->last_selling_price_medium_unit;
			$small_unit_price  = $get_row->last_selling_price_small_unit;

			$where_special_price    = array('a.customer_id' => $customer, 'a.item_id' => $get_row->item_id);
			$get_data_special_price = $this->Special_prices_model->get_data($where_special_price)->row();

			$group_customer_id    = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->group_customer_id;
			$where_group_price    = array('a.group_customer_id' => $group_customer_id, 'a.item_id' => $get_row->item_id, 'a.price !=' => 0);
			$get_data_group_price = $this->Group_prices_model->get_data_group_price($where_group_price)->row();

			if($get_data_special_price){
				$large_unit_price = $get_data_special_price->price;
			}

			if($get_data_group_price){
				$large_unit_price = $get_data_group_price->price;
			}

			// $total_stock     = 0;
			// $where_stock     = array('log_item_id' => $get_row->item_id);
			// $get_data_stock  = $this->Logs_model->get_data_last($where_stock)->row_array();
			// if($get_data_stock){
			// 	$total_stock = $get_data_stock['log_total_stock'];
			// }

			$in_stock = 0;
			$ou_stock = 0;
			$total_stock = 0;

			$warehouse = $this->Warehouses_model->get_data(array('is_default' => 1))->row()->warehouse_id;

			$get_stock_in = $this->Transfer_model->transfer_advance(array('header_to' => $warehouse, 'item_id' => $get_row->item_id), 'item_id, header_to')->row();
			$get_stock_ou = $this->Transfer_model->transfer_advance(array('header_from' => $warehouse, 'item_id' => $get_row->item_id), 'item_id, header_from')->row();

			if($get_stock_in){
				$in_stock = (($get_stock_in->large_qty * $get_row->large_unit_contain) + ($get_stock_in->medium_qty * $get_row->medium_unit_contain) + ($get_stock_in->small_qty * $get_row->small_unit_contain));
			}

			if($get_stock_ou){
				$ou_stock = (($get_stock_ou->large_qty * $get_row->large_unit_contain) + ($get_stock_ou->medium_qty * $get_row->medium_unit_contain) + ($get_stock_ou->small_qty * $get_row->small_unit_contain));
			}

			$total_stock = $in_stock - $ou_stock;

			$ppn_status_color = "";
			if($get_row->ppn_status == '1'){
				$ppn_status_color = "";
			}elseif($get_row->ppn_status == '2'){
				$ppn_status_color = "bg-success";
			}else{
				$ppn_status_color = "bg-warning";
			}

			$bg_min_stock = "";
			$left_stock_large = 0;
			$left_stock_large = (to_decimal($total_stock)/to_decimal($get_row->large_unit_contain));
			if($left_stock_large <= to_decimal($get_row->minimum_stock)){
				$bg_min_stock = "bg-danger";
			}

			//
			$data[] = array(
					'no'                 => $no,
					'id'                 => $get_row->item_id,
					'name'               => $get_row->item_name,
					'group_id'           => $get_row->group_id,
					'group_name'         => $get_row->group_name,
					'group_child_id'     => $get_row->group_child_id,
					'group_child_name'   => $get_row->group_child_name,
					'lg_unit'            => $get_row->large_unit,
					'lg_unit_cnt'        => to_decimal($get_row->large_unit_contain),
					'lg_unit_prc'        => number_format($large_unit_price),
					'md_unit'            => $get_row->medium_unit,
					'md_unit_cnt'        => to_decimal($get_row->medium_unit_contain),
					'md_unit_prc'        => number_format($medium_unit_price),
					'sm_unit'            => $get_row->small_unit,
					'sm_unit_cnt'        => to_decimal($get_row->small_unit_contain),
					'sm_unit_prc'        => number_format($small_unit_price),
					'total_stock'        => to_decimal($total_stock),
					'total_stock_stored' => to_decimal($total_stock),
					'minimum_stock'      => to_decimal($get_row->minimum_stock),
					'bg_min_stock'       => $bg_min_stock,
					'ppn_total'          => 0,
					'ppn_status'         => $get_row->ppn_status,
					'ppn_status_color'   => $ppn_status_color,
					'lg_unit_hpp'        => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_purchase_price_large_unit) : 0),
					'md_unit_hpp'        => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_purchase_price_medium_unit) : 0),
					'sm_unit_hpp'        => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_purchase_price_small_unit) : 0),
					'btncolor'           => '',
					'btnicon'            => ''
			);

			$no++;
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
		
	}

	public function save()
	{	
		
		date_default_timezone_set('Asia/Jakarta');

		$id              = $this->input->post('id');
		$number          = $this->input->post("number");
		$date            = $this->input->post("date");
		$printed_date_text = $this->input->post("printed_date");
		$customer        = $this->input->post("customer");
		$payment_method  = $this->input->post("payment_method");
		$payment_term    = $this->input->post("payment_term");
		$payment_due     = $this->input->post("payment_due");
		$grand_total     = $this->input->post("grand_total");
		$ppn_total       = $this->input->post("ppn_total");
		$paid_total      = $this->input->post("paid_total");
		$change_total    = $this->input->post("change_total");
		$remaining_total = $this->input->post("remaining_total");
		$description     = $this->input->post("description");

		$hold_status     = $this->input->post("hold_status");
		$ppn_amount      = $this->input->post("ppn_amount");

		$tmstamp         = $this->input->post("tmstamp");


		$btn_action = $this->input->post("btn_action");

		$user_id = logged_user('id');
		
		$vuedata = $this->input->post('vuedata');

		// echo json_encode($vuedata);
		// die();

		$payment_term_data = ($payment_term == "" ? "0" : $payment_term);
		$payment_due_data  = ($payment_due == "" ? "0000-00-00" : change_format_date($payment_due));
		$status_paid 	   = ($payment_method == 'Tunai' ? 1 : 0);
		$is_hold = 0;
		$printed_date = date_now();

		if($hold_status == 0){
			$printed_date = change_format_date($printed_date_text);
		}

		if($btn_action == 'hold'){ 
			$status_paid = 0; 
			$is_hold = 1; 
			// $printed_date = "0000-00-00";
		}

		$header_id   = $id;
		$default_warehouse = $this->Warehouses_model->get_data(array('is_default' => '1'))->row_array();
		$transfer_number   = $this->Transfer_model->transfer_autonumber();
		$prefix            = 'TF';
		$datenow           = date('ym');
		$autonumber        = $prefix.$datenow.'-'.$transfer_number;

		$header_data = [
			'sales_order_header_number'          => $number,
			'sales_order_header_date'            => change_format_date($date),
			'sales_order_header_customer_id'     => $customer,
			'sales_order_header_payment_method'  => $payment_method,
			'sales_order_header_payment_term'    => $payment_term_data,
			'sales_order_header_payment_due'     => $payment_due_data,
			'sales_order_header_grand_total'     => trims($grand_total),
			'sales_order_header_ppn_total'       => trims($ppn_total),
			'sales_order_header_paid_total'      => trims($paid_total),
			'sales_order_header_change_total'    => trims($change_total),
			'sales_order_header_remaining_total' => trims($remaining_total),
			'sales_order_header_description'     => $description,
			'sales_order_header_user_id'         => $user_id,
			'status_paid'                        => $status_paid,
			'is_hold'                            => $is_hold,
			'printed_date'                       => $printed_date,
			'ppn_amount'                         => $ppn_amount
		];

		$trheader_data = [
			'header_number' => $autonumber,
			'header_date'   => change_format_date($date),
			'header_from'   => $default_warehouse['warehouse_id'],
			'header_to'     => 0
		];

		$trdetail_data = [];
		$detail_data = [];
		$log_data = [];

		$prefix_date = date('ym');

		if(isset($id) && $id != '' && $id != NULL){
			if($vuedata){
				if($id == "new")
				{
					// save header

					$outofstock = array();
					foreach($vuedata as $row)
					{   
						$lg_cnt = 0;
						$md_cnt = 0;
						$sm_cnt = 0;

						$lg_cnt = to_decimal($row['lg_unit_cnt']);
						$md_cnt = to_decimal($row['md_unit_cnt']);
						$sm_cnt = to_decimal($row['sm_unit_cnt']);

						$total_stock    = 0;
						$where_stock    = array('log_item_id' => $row['id']);
						$get_data_stock = $this->Logs_model->get_data_last($where_stock)->row_array();
						if($get_data_stock){
							$total_stock = to_decimal($get_data_stock['log_total_stock']);
						}

						$remaining_stock = $total_stock - (($lg_cnt * $row['lg_unit_qty']) + ($md_cnt * $row['md_unit_qty']) + ($sm_cnt * $row['sm_unit_qty']));

						
						if($remaining_stock < 0){
							$outofstock[] = $row['name'];
						}
						
					}
					if(count($outofstock) > 0){
						$item_name = implode(', ', $outofstock);

						$msg = $item_name;
						$status = "outofstock";
					}else{

					$check_avail = $this->Sales_orders_model->salesorder_header(array('sales_order_header_date' => change_format_date($date), 'sales_order_header_customer_id' => $customer, 'sales_order_header_grand_total' => trims($grand_total)))->row_array();
					if(!empty($check_avail) && $check_avail['customer_name'] != "umum"){
						$msg    = "Data sudah ada!";
						$status = "error";	
					}else{
						$save_header = $this->Sales_orders_model->save_header($header_data);
						
						if($save_header)
						{
							$header_id = $this->db->insert_id();
							$save_trheader = $this->Transfer_model->save_header($trheader_data);
							$trheader_id = $this->db->insert_id();
							$no_1 = 0;
							$no_2 = 0;
							$no_3 = 0;
							$faktur_1 = 0;
							$faktur_2 = 0;
							$faktur_3 = 0;
							foreach($vuedata as $row)
							{	
								$faktur = $this->Ppn_model->get_data_ppn_status(array('ppn_status_id' => $row['ppn_status']))->row_array();
								if($row['ppn_status'] == 1){
									$no_1++;
									$faktur_1 = $faktur['abbrv'].$prefix_date.'-'.sprintf("%04d", $faktur['number'] + 1);
								}
								if($row['ppn_status'] == 2){
									$no_2++;
									$faktur_2 = $faktur['abbrv'].$prefix_date.'-'.sprintf("%04d", $faktur['number'] + 1);
								}
								if($row['ppn_status'] == 3){
									$no_3++;
									$faktur_3 = $faktur['abbrv'].$prefix_date.'-'.sprintf("%04d", $faktur['number'] + 1);
								}
								$detail_data[] = [
									'sales_order_detail_header_id'            => $header_id,
									'sales_order_detail_item_id'              => $row['id'],
									'sales_order_detail_item_name'            => $row['name'],
									'sales_order_detail_large_unit'           => $row['lg_unit'],
									'sales_order_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
									'sales_order_detail_large_unit_price'     => trims($row['lg_unit_prc']) - trims($row['lg_unit_dsc']),
									'sales_order_detail_result_large'         => trims($row['result_large']),
									'sales_order_detail_medium_unit'          => $row['md_unit'],
									'sales_order_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
									'sales_order_detail_medium_unit_price'    => trims($row['md_unit_prc']) - trims($row['md_unit_dsc']),
									'sales_order_detail_result_medium'        => trims($row['result_medium']),
									'sales_order_detail_small_unit'           => $row['sm_unit'],
									'sales_order_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
									'sales_order_detail_small_unit_price'     => trims($row['sm_unit_prc']) - trims($row['sm_unit_dsc']),
									'sales_order_detail_result_small'         => trims($row['result_small']),
									'sales_order_detail_ppn_status'           => $row['ppn_status'],
									'sales_order_detail_ppn_total'            => trims($row['ppn_total']),
									'sales_order_detail_total'                => trims($row['total']),
									'sales_order_detail_large_unit_discount'  => trims($row['lg_unit_dsc']),
									'sales_order_detail_medium_unit_discount' => trims($row['md_unit_dsc']),
									'sales_order_detail_small_unit_discount'  => trims($row['sm_unit_dsc']),
									'sales_order_detail_faktur' => $faktur['abbrv'].$prefix_date.'-'.sprintf("%04d", $faktur['number'] + 1)
								];

								$trdetail_data[] = [
									'header_id'      => $trheader_id,
									'transaction_id' => $header_id,
									'item_id'        => $row['id'],
									'lg_qty'         => trims($row['lg_unit_qty']),
									'md_qty'         => trims($row['md_unit_qty']),
									'sm_qty'         => trims($row['sm_unit_qty']),
									'status'         => "SELL",
								];
		
								// $where                      = array('log_item_id' => $row['id']);
								$dtstamp                    = change_format_date($date). " " .date("H:i:s");
								$where                      = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
								$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
								$last_total_stock           = 0;
								$last_log_total_stock_value = 0;
								$last_log_avg_large         = 0;
								$last_log_avg_medium        = 0;
								$last_log_avg_small         = 0;
		
								if(!empty($log_data_check)){
									$last_total_stock           = $log_data_check['log_total_stock'];
									$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
									$last_log_avg_large         = $log_data_check['log_average_large_unit'];
									$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
									$last_log_avg_small         = $log_data_check['log_average_small_unit'];
								}
		
								$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_medium));
								$small_purchase_price  = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_small));
		
								$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
								$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
								$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
								$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
								$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
								$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
								$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
		
								$log_data[] = [
									'log_type'                            => 'SELL',
									'log_transaction_id'                  => $header_id,
									'log_item_id'                         => $row['id'],
									'log_large_unit'                      => $row['lg_unit'],
									'log_large_unit_contain'              => $row['lg_unit_cnt'],
									'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
									'log_large_unit_purchase_price'       => $last_log_avg_large,
									'log_large_unit_selling_price'        => trims($row['lg_unit_prc']) - trims($row['lg_unit_dsc']),
									'log_medium_unit'                     => $row['md_unit'],
									'log_medium_unit_contain'             => $row['md_unit_cnt'],
									'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
									'log_medium_unit_purchase_price'      => $medium_purchase_price,
									'log_medium_unit_selling_price'       => trims($row['md_unit_prc']) - trims($row['md_unit_dsc']),
									'log_small_unit'                      => $row['sm_unit'],
									'log_small_unit_contain'              => $row['sm_unit_cnt'],
									'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
									'log_small_unit_purchase_price'       => $small_purchase_price,
									'log_small_unit_selling_price'        => trims($row['sm_unit_prc']) - trims($row['sm_unit_dsc']),
									'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
									'log_total_transaction_value'         => $log_total_transaction_value,
									'log_total_stock'                     => $log_total_stock,
									'log_total_stock_value'               => $log_total_stock_value,
									'log_average_large_unit'              => $log_average_large_unit,
									'log_average_medium_unit'             => $log_average_medium_unit,
									'log_average_small_unit'              => $log_average_small_unit,
									'timestamp'                           => $dtstamp
								];

							}
							
							$save_detail = $this->Sales_orders_model->save_detail($detail_data, true);
							$save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);

							if($save_detail)
							{	
								$save_log = $this->Logs_model->save($log_data, true);
		
								if($save_log)
								{	
									// $s_trx = 'new';
									// $checkpoint = $this->checkpoint($s_trx, $header_id, $date, $customer);
									// if($checkpoint)
									// {
									// 	$msg    = "Berhasil menyimpan data";
									// 	$status = "success";
									// }else{
									// 	$msg    = "Gagal menyimpan data #CKP-S01";
									// 	$status = "error";	
									// }
									$update_log = $this->update_log($vuedata, $header_id, $date);
										// $update_log = true;
									if($update_log)
									{	
										// $s_trx = 'update';
										// $update_master_item = $this->Purchase_orders_model->update_master_item_batch($newprice_data);
										// if($update_master_item)
										// {
											

											if($no_1 > 0){
												$update_pstatus = $this->Ppn_model->update_ppn_status(1);
											}
											if($no_2 > 0){
												$update_pstatus = $this->Ppn_model->update_ppn_status(2);
											}
											if($no_3 > 0){
												$update_pstatus = $this->Ppn_model->update_ppn_status(3);
											}

											$u_faktur = [
												'faktur_1' => $faktur_1,
												'faktur_2' => $faktur_2,
												'faktur_3' => $faktur_3,
											];
											$save_header = $this->Sales_orders_model->update_header($header_id, $u_faktur);

											$msg    = "Berhasil menyimpan data";
											$status = "success";
										// }else{
										// 	$msg    = "Gagal menyimpan data #CKP-U01";
										// 	$status = "error";	
										// }
									}else{
										$msg    = "Gagal menyimpan data #CKP-U01";
										$status = "error";	
									}
								}
								else
								{
									$msg    = "Gagal menyimpan data #LOG-S01";
									$status = "error";	
								}
							}
							else
							{
								$msg    = "Gagal menyimpan data #DET-S01";
								$status = "error";	
							}
						}
						else
						{
							$msg    = "Gagal menyimpan data #HED-S01";
							$status = "error";	
						}
					}

					}
					
				}else{
					
					$outofstock = array();
					foreach($vuedata as $row)
					{   
						$lg_cnt = 0;
						$md_cnt = 0;
						$sm_cnt = 0;

						$lg_cnt = to_decimal($row['lg_unit_cnt']);
						$md_cnt = to_decimal($row['md_unit_cnt']);
						$sm_cnt = to_decimal($row['sm_unit_cnt']);

						$total_stock    = 0;
						$where_stock    = array('log_item_id' => $row['id']);
						$get_data_stock = $this->Logs_model->get_data_last($where_stock)->row_array();
						if($get_data_stock){
							$total_stock = to_decimal($get_data_stock['log_total_stock']);
						}
						$total_stock_stt = (($lg_cnt * $row['lg_unit_qtys']) + ($md_cnt * $row['md_unit_qtys']) + ($sm_cnt * $row['sm_unit_qtys']));
						$remaining_stock = ($total_stock + $total_stock_stt) - (($lg_cnt * $row['lg_unit_qty']) + ($md_cnt * $row['md_unit_qty']) + ($sm_cnt * $row['sm_unit_qty']));

						
						if($remaining_stock < 0){
							$outofstock[] = $row['name'];
						}
						
					}
					if(count($outofstock) > 0){
						$item_name = implode(', ', $outofstock);

						$msg = $item_name;
						$status = "outofstock";
					}else{

					// This New Update
					$id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $id, 'status' => 'SELL'))->row()->header_id;

					$delete_detail = $this->Sales_orders_model->delete_detail($id);

					$tf_delheader = $this->Transfer_model->delete_header($id_transfer);
					$tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);

					if ($delete_detail) {
						
						// $delete_log = $this->delete_log($id);
						$delete_log = $this->Logs_model->delete(array('log_transaction_id' => $id, 'log_type' => 'SELL'));

						if($delete_log){
							$save_header = $this->Sales_orders_model->update_header($id, $header_data);
	
						if($save_header)
						{
							// $header_id = $this->db->insert_id();
							$save_trheader = $this->Transfer_model->save_header($trheader_data);
							$trheader_id = $this->db->insert_id();
							$no_1 = 0;
							$no_2 = 0;
							$no_3 = 0;
							$faktur_1 = 0;
							$faktur_2 = 0;
							$faktur_3 = 0;
							$faktur_detail = 0;

							foreach($vuedata as $row)
							{
								$faktur = $this->Ppn_model->get_data_ppn_status(array('ppn_status_id' => $row['ppn_status']))->row_array();
								$header_faktur = $this->Sales_orders_model->salesorder_header(array('sales_order_header_id' => $header_id))->row_array();
								if($row['ppn_status'] == 1){
									
									if($header_faktur['faktur_1'] == "0"){
										$no_1++;
										$faktur_1 = $faktur['abbrv'].$prefix_date.'-'.sprintf("%04d", $faktur['number'] + 1);
									}else{
										$faktur_1 = $header_faktur['faktur_1'];
									}
									$faktur_detail = $faktur_1;
								}
								if($row['ppn_status'] == 2){
									
									if($header_faktur['faktur_2'] == "0"){
										$no_2++;
										$faktur_2 = $faktur['abbrv'].$prefix_date.'-'.sprintf("%04d", $faktur['number'] + 1);
										
									}else{
										$faktur_2 = $header_faktur['faktur_2'];
									}
									$faktur_detail = $faktur_2;
								}
								if($row['ppn_status'] == 3){
									
									if($header_faktur['faktur_3'] == "0"){
										$no_3++;
										$faktur_3 = $faktur['abbrv'].$prefix_date.'-'.sprintf("%04d", $faktur['number'] + 1);
										
									}else{
										$faktur_3 = $header_faktur['faktur_3'];
									}
									$faktur_detail = $faktur_3;
								}

								
								
								$detail_data[] = [
									'sales_order_detail_header_id'            => $header_id,
									'sales_order_detail_item_id'              => $row['id'],
									'sales_order_detail_item_name'            => $row['name'],
									'sales_order_detail_large_unit'           => $row['lg_unit'],
									'sales_order_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
									'sales_order_detail_large_unit_price'     => trims($row['lg_unit_prc']) - trims($row['lg_unit_dsc']),
									'sales_order_detail_result_large'         => trims($row['result_large']),
									'sales_order_detail_medium_unit'          => $row['md_unit'],
									'sales_order_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
									'sales_order_detail_medium_unit_price'    => trims($row['md_unit_prc']) - trims($row['md_unit_dsc']),
									'sales_order_detail_result_medium'        => trims($row['result_medium']),
									'sales_order_detail_small_unit'           => $row['sm_unit'],
									'sales_order_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
									'sales_order_detail_small_unit_price'     => trims($row['sm_unit_prc']) - trims($row['sm_unit_dsc']),
									'sales_order_detail_result_small'         => trims($row['result_small']),
									'sales_order_detail_ppn_status'           => $row['ppn_status'],
									'sales_order_detail_ppn_total'            => trims($row['ppn_total']),
									'sales_order_detail_total'                => trims($row['total']),
									'sales_order_detail_large_unit_discount'  => trims($row['lg_unit_dsc']),
									'sales_order_detail_medium_unit_discount' => trims($row['md_unit_dsc']),
									'sales_order_detail_small_unit_discount'  => trims($row['sm_unit_dsc']),
									'sales_order_detail_faktur' => $faktur_detail
								];
								
								// $where                 = array('log_item_id' => $row['id'], 'a.timestamp <' => $tmstamp);
								$dtstamp                    = change_format_date($date). " " .$tmstamp;
								$where                      = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
								$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
								$last_total_stock           = 0;
								$last_log_total_stock_value = 0;
								$last_log_avg_large         = 0;
								$last_log_avg_medium        = 0;
								$last_log_avg_small         = 0;
		
								if(!empty($log_data_check)){
									$last_total_stock           = $log_data_check['log_total_stock'];
									$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
									$last_log_avg_large         = $log_data_check['log_average_large_unit'];
									$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
									$last_log_avg_small         = $log_data_check['log_average_small_unit'];
								}
		
								$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_medium));
								$small_purchase_price  = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_small));
		
								$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
								$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
								$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
								$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
								$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
								$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
								$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
		
								$log_data[] = [
									'log_type'                            => 'SELL',
									'log_transaction_id'                  => $header_id,
									'log_item_id'                         => $row['id'],
									'log_large_unit'                      => $row['lg_unit'],
									'log_large_unit_contain'              => $row['lg_unit_cnt'],
									'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
									'log_large_unit_purchase_price'       => $last_log_avg_large,
									'log_large_unit_selling_price'        => trims($row['lg_unit_prc']) - trims($row['lg_unit_dsc']),
									'log_medium_unit'                     => $row['md_unit'],
									'log_medium_unit_contain'             => $row['md_unit_cnt'],
									'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
									'log_medium_unit_purchase_price'      => $medium_purchase_price,
									'log_medium_unit_selling_price'       => trims($row['md_unit_prc']) - trims($row['md_unit_dsc']),
									'log_small_unit'                      => $row['sm_unit'],
									'log_small_unit_contain'              => $row['sm_unit_cnt'],
									'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
									'log_small_unit_purchase_price'       => $small_purchase_price,
									'log_small_unit_selling_price'        => trims($row['sm_unit_prc']) - trims($row['sm_unit_dsc']),
									'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
									'log_total_transaction_value'         => $log_total_transaction_value,
									'log_total_stock'                     => $log_total_stock,
									'log_total_stock_value'               => $log_total_stock_value,
									'log_average_large_unit'              => $log_average_large_unit,
									'log_average_medium_unit'             => $log_average_medium_unit,
									'log_average_small_unit'              => $log_average_small_unit,
									'timestamp'                           => $dtstamp
								];

								$trdetail_data[] = [
									'header_id'      => $trheader_id,
									'transaction_id' => $header_id,
									'item_id'        => $row['id'],
									'lg_qty'         => trims($row['lg_unit_qty']),
									'md_qty'         => trims($row['md_unit_qty']),
									'sm_qty'         => trims($row['sm_unit_qty']),
									'status'         => "SELL",
								];
								
							}
	
							$save_detail = $this->Sales_orders_model->save_detail($detail_data, true);
							$save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);
							
							// echo $no_1;
							// 	echo $no_2;
							// 	echo $no_3;
							// 	die();
								
							if($save_detail)
							{

								$save_log = $this->Logs_model->save($log_data, true);
	
								if($save_log)
								{	
									$update_log = $this->update_log($vuedata, $header_id, $date);
									// $update_log = true;
									if($update_log)
									{	
										if($no_1 > 0){
											$update_pstatus = $this->Ppn_model->update_ppn_status(1);
										}
										if($no_2 > 0){
											$update_pstatus = $this->Ppn_model->update_ppn_status(2);
										}
										if($no_3 > 0){
											$update_pstatus = $this->Ppn_model->update_ppn_status(3);
										}

										$u_faktur = [
											'faktur_1' => $faktur_1,
											'faktur_2' => $faktur_2,
											'faktur_3' => $faktur_3,
										];
										$save_header = $this->Sales_orders_model->update_header($header_id, $u_faktur);

										// $s_trx = 'update';
										// $checkpoint = $this->checkpoint($s_trx, $header_id, $date, $customer);
										// if($checkpoint)
										// {
											$msg    = "Berhasil menyimpan data";
											$status = "success";
										// }else{
										// 	$msg    = "Gagal menyimpan data #CKP-U01";
										// 	$status = "error";	
										// }
									}else{
										$msg    = "Gagal menyimpan data #CKP-U01";
										$status = "error";	
									}
								}
								else
								{
									$msg    = "Gagal menyimpan data #LOG-S01";
									$status = "error";	
								}
								
							}
							else
							{
								$msg    = "Gagal menyimpan data #LOG-U01";
								$status = "error";	
							}
						}
						else{
							$msg    = "Gagal menyimpan data #HED-U01";
							$status = "error";
						}
						}else{

						}
	
					}
					else{
						$msg    = "Gagal menyimpan data #DEL-U01";
						$status = "error";
					}

					}
				}
			}else{
				$msg    = "Gagal menyimpan data, detail tidak terbaca.";
				$status = "error";
			}
		}else{
			$msg    = "Gagal menyimpan data, id tidak terbaca.";
			$status = "error";
		}

		$response = [
			'message'    => $msg,
			'status'     => $status,
			'id'         => $header_id,
			'btn_action' => $btn_action
		];
		output_json($response);

	}

	public function update_log($vuedata, $header_id='', $date='')
	{	
		$data_log = [];
		$data_where = [];

		$updateData = array();

		$total_stok = 0;
		$total_stok_rupiah = 0;
		$avg_lg = 0;
		$avg_md = 0;
		$avg_sm = 0;

		foreach($vuedata as $rowes)
		{
			
			$where_1         = array('log_item_id' => $rowes['id']);
			$get_first       = $this->Logs_model->get_data_first($where_1)->row();
			$logs_id         = $get_first->tmslog;

			$total_stok      = $get_first->log_total_stock;
			$total_stok_rupiah = $get_first->log_total_stock_value;

			$avg_lg  = ($get_first->log_average_large_unit);
			$avg_md  = ($get_first->log_average_medium_unit);
			$avg_sm  = ($get_first->log_average_small_unit);

			$log_total_transaction_value = 0;
		
			$where_2 = array('log_item_id' => $rowes['id'], 'a.timestamp >' => $logs_id);
			$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2, 'a.timestamp asc')->result();

			foreach ($get_data_all_logs_by_item as $row) {


				$total_stok      += $row->log_total_transaction_in_small_unit;
				
				if($row->log_type == "BUY" || $row->log_type == "R-SELL"){
					$log_total_transaction_value = (($row->log_large_unit_quantity * ($row->log_large_unit_purchase_price)) + ($row->log_medium_unit_quantity * ($row->log_medium_unit_purchase_price)) + ($row->log_small_unit_quantity * ($row->log_medium_unit_purchase_price)));
				}else{
					$log_total_transaction_value = (($row->log_large_unit_quantity * ($avg_lg)) + ($row->log_medium_unit_quantity * ($avg_md)) + ($row->log_small_unit_quantity * ($avg_sm)));
				}
				$total_stok_rupiah += $log_total_transaction_value;
				

				$log_average_small_unit  = ($total_stok == 0 ? 0 : ($total_stok_rupiah / $total_stok));
				$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
				$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);

				// $log_total_transaction_value = a;

				if($row->log_type == "BUY" || $row->log_type == "R-SELL"){
					$avg_lg  = ($log_average_large_unit);
					$avg_md  = ($log_average_medium_unit);
					$avg_sm  = ($log_average_small_unit);
					$data_log[] = array(
						'log_id'                        => $row->log_id,
						// 'log_medium_unit_purchase_price' => $medium_purchase_price,
						// 'log_small_unit_purchase_price'  => $small_purchase_price,
						// 'log_total_transaction_value' => $log_total_transaction_value,
						'log_total_stock'             => $total_stok,
						'log_total_stock_value'       => $total_stok_rupiah,
						'log_average_large_unit'      => $log_average_large_unit,
						'log_average_medium_unit'     => $log_average_medium_unit,
						'log_average_small_unit'      => $log_average_small_unit,
						// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
					);
				}else{					

					$data_log[] = array(
						'log_id'                         => $row->log_id,
						'log_large_unit_purchase_price'  => $avg_lg,
						'log_medium_unit_purchase_price' => $avg_md,
						'log_small_unit_purchase_price'  => $avg_sm,
						'log_total_transaction_value'    => $log_total_transaction_value,
						'log_total_stock'                => $total_stok,
						'log_total_stock_value'          => $total_stok_rupiah,
						'log_average_large_unit'         => $log_average_large_unit,
						'log_average_medium_unit'        => $log_average_medium_unit,
						'log_average_small_unit'         => $log_average_small_unit,
						// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
					);
				}
				

				
			}
			
			
		}

		$after_row_log_update = $this->Logs_model->update_item_batch($data_log);

		return true;
	}

	public function delete()
	{
		$id = $this->input->post('id');
		// echo json_encode($id);
		// die();
		$data_log = [];
		foreach($id as $row)
		{	
			$where = array('log_type' => 'SELL', 'log_transaction_id' => $row);
			$get_data_log = $this->Logs_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {

				// Get Data After This Item ID :::
				$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
				$get_after_data = $this->Logs_model->get_data($where_after)->result();

				if($get_after_data){
					foreach ($get_after_data as $row_list_detail) {
					
						$where_log_delete = array(
							'log_item_id' => $row_list->log_item_id, 
							'log_id' => $row_list->log_id
						);

						$delete_logs = $this->Logs_model->delete($where_log_delete);
						
						$where_this = array('log_id' => $row_list_detail->log_id, 'log_item_id' => $row_list_detail->log_item_id);
						$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
						// The Keys
						// $where_this = array('log_type' => 'SELL', 'log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
						// $log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
						
						$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
						$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
						$one_line_before_total     = 0;
						$one_line_before_log_total = 0;
						$one_line_before_log_avg_large = 0;

						if(!empty($one_line_before_log_data)){
							$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
							$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
							$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
						}

						$log_total_stock	     = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
						$log_total_stock_value   = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
						// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
						$log_average_large_unit  = ($log_average_small_unit * $row_list_detail->large_unit_contain);

						$after_row_data_update = array(
							'log_id'                  => $row_list_detail->log_id,
							'log_total_stock'         => $log_total_stock,
							'log_total_stock_value'   => $log_total_stock_value,
							'log_average_large_unit'  => $log_average_large_unit,
							'log_average_medium_unit' => $log_average_medium_unit,
							'log_average_small_unit'  => $log_average_small_unit
						);

						$after_row_where_update = array(
							'log_id' => $row_list_detail->log_id,
						);

						$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
					}
				}else{
					$where_log_delete = array(
						'log_item_id' => $row_list->log_item_id, 
						'log_id' => $row_list->log_id
					);

					$delete_logs = $this->Logs_model->delete($where_log_delete);
				}
			}

			$delete_header = $this->Sales_orders_model->delete_header($row);

			$s_trx = 'delete';
			$checkpoint = $this->checkpoint($s_trx, $row);
						
			if($delete_header){
				$delete_type = $this->Sales_orders_model->delete_detail($row);
			}

			$id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $row, 'status' => 'SELL'))->row()->header_id;

			$tf_delheader = $this->Transfer_model->delete_header($id_transfer);
			$tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function delete_item()
	{
		$id        = $this->input->post('id');
		$item      = $this->input->post('item');
		$data_item = [];

		$delete_type = $this->Sales_orders_model->delete_detail_advance(array('sales_order_detail_header_id' => $id, 'sales_order_detail_item_id' => $item['id']));
		if($delete_type){
			$delete_log = $this->Logs_model->delete(array('log_transaction_id' => $id, 'log_type' => 'SELL', 'log_item_id' => $item['id']));
		}

		$data_item = array($item);
		$this->update_log($data_item);

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function delete_log($id)
	{
		// $id = $this->input->post('id');
		$data_log = [];
		// foreach($id as $row)
		// {	
			$where = array('log_type' => 'SELL', 'log_transaction_id' => $id);
			$get_data_log = $this->Logs_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {

				// Get Data After This Item ID :::
				$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
				$get_after_data = $this->Logs_model->get_data($where_after)->result();

				if($get_after_data){
					foreach ($get_after_data as $row_list_detail) {
					
						$where_log_delete = array(
							'log_item_id' => $row_list->log_item_id, 
							'log_id' => $row_list->log_id
						);

						$delete_logs = $this->Logs_model->delete($where_log_delete);
						
						$where_this = array('log_id' => $row_list_detail->log_id, 'log_item_id' => $row_list_detail->log_item_id);
						$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
						// The Keys
						// $where_this = array('log_type' => 'SELL', 'log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
						// $log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
						
						$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
						$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
						$one_line_before_total     = 0;
						$one_line_before_log_total = 0;
						$one_line_before_log_avg_large = 0;

						if(!empty($one_line_before_log_data)){
							$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
							$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
							$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
						}

						$log_total_stock	     = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
						$log_total_stock_value   = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
						// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
						$log_average_large_unit  = ($log_average_small_unit * $row_list_detail->large_unit_contain);

						$after_row_data_update = array(
							'log_id'                  => $row_list_detail->log_id,
							'log_total_stock'         => $log_total_stock,
							'log_total_stock_value'   => $log_total_stock_value,
							'log_average_large_unit'  => $log_average_large_unit,
							'log_average_medium_unit' => $log_average_medium_unit,
							'log_average_small_unit'  => $log_average_small_unit
						);

						$after_row_where_update = array(
							'log_id' => $row_list_detail->log_id,
						);

						$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
					}
				}else{
					$where_log_delete = array(
						'log_item_id' => $row_list->log_item_id, 
						'log_id' => $row_list->log_id
					);

					$delete_logs = $this->Logs_model->delete($where_log_delete);
				}
			}

			// $delete_header = $this->Sales_orders_model->delete_header($row);

			// $s_trx = 'delete';
			// $checkpoint = $this->checkpoint($s_trx, $id);
						
			// if($checkpoint){
				$delete_type = $this->Sales_orders_model->delete_detail($id);
			// }
		// }

		return true;
	}

	public function print_out_backup($id)
	{	
		$where_header = array('sales_order_header_id' => $id);
		$where_detail = array('sales_order_detail_header_id' => $id);

		$header = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$detail = $this->Sales_orders_model->salesorder_detail($where_detail)->result();

		$data['content_title'] = 'Print Penjualan';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/sales_orders/print_out', $data);
	}

	public function print_out($id)
	{	
		date_default_timezone_set('Asia/Jakarta');
		$where_header = array('sales_order_header_id' => $id);
		$where_config1 = array('ppn_status' => '1', 'is_active' => '1');
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');
		$where_config3 = array('ppn_status' => '3', 'is_active' => '1');
		
		$header          = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$config_receipt1 = $this->Configuration_model->get_data_invoice($where_config1)->row_array();
		$config_receipt2 = $this->Configuration_model->get_data_invoice($where_config2)->row_array();
		$config_receipt3 = $this->Configuration_model->get_data_invoice($where_config3)->row_array();
		// $user_handle = $this->Users_model->get_data_advance($header['sales_order_header_user_id'])->row()->fullname;
		$customer_name = $header['customer_name'];
		$customer_ktp  = $header['customer_ktp'];
		$customer_npwp = $header['customer_npwp'];

		$printed_date = $header['printed_date'];
		if($printed_date == '0000-00-00'){
			$printed_date = $header['sales_order_header_date'];
		}
		
		// $printed_date = date('H:i:s');
		$get_data     = $this->Sales_orders_model->ppn_status('', 'FIELD(ppn_status_id, "3", "1", "2")')->result();
		
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $k => $get_row)
			{
				$response[] = [
					'number' => $no,
					'ppn_id'     => $get_row->ppn_status_id,
					'ppn_name'   => $get_row->ppn_status_name
				];

				$where_detail = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => $get_row->ppn_status_id);
				$temp = $this->Sales_orders_model->salesorder_detail2($where_detail, 'large_unit_pr asc, medium_unit_pr asc, small_unit_pr asc')->result();
				$a = 0;
				$b = 0;
				$c = 0;
				$d = 0;
				$np = 0;

				foreach ($temp as $key => $value) {

					$dppTotal = $value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small;

					$dppTotalRnd = round($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small, -2);
					$ppnTotal = $value->sales_order_detail_ppn_total;
					$tax_percentage = ($ppnTotal/$dppTotal) * 100;

					$price_large   = $value->sales_order_detail_large_unit_price + ($value->sales_order_detail_large_unit_price * ($tax_percentage/100));
					$result_large  = (round($price_large) * $value->sales_order_detail_large_unit_quantity);
					$price_medium  = $value->sales_order_detail_medium_unit_price + ($value->sales_order_detail_medium_unit_price * ($tax_percentage/100));
					$result_medium = (round($price_medium) * $value->sales_order_detail_medium_unit_quantity);
					$price_small   = $value->sales_order_detail_small_unit_price + ($value->sales_order_detail_small_unit_price * ($tax_percentage/100));
					$result_small  = (round($price_small) * $value->sales_order_detail_small_unit_quantity);


					$response[$k]['detail'][$key] = array(	
						'item_name'       => $value->sales_order_detail_item_name,
						'unit_large'      => $value->sales_order_detail_large_unit,
						'quantity_large'  => to_decimal($value->sales_order_detail_large_unit_quantity),
						'price_large'     => number_format($price_large),
						'result_large'    => number_format($result_large),
						'unit_medium'     => $value->sales_order_detail_medium_unit,
						'quantity_medium' => to_decimal($value->sales_order_detail_medium_unit_quantity),
						'price_medium'    => number_format($price_medium),
						'result_medium'   => number_format($result_medium),
						'unit_small'      => $value->sales_order_detail_small_unit,
						'quantity_small'  => to_decimal($value->sales_order_detail_small_unit_quantity),
						'price_small'     => number_format($price_small),
						'result_small'    => number_format($result_small),
						'dppTotal'        => number_format($np += (round($value->sales_order_detail_result_large,-2) + round($value->sales_order_detail_result_medium,-2) + round($value->sales_order_detail_result_small,-2))),
						'dppTotalppn'     => number_format((round($a += $value->sales_order_detail_total, -2)/1.1)),
						'ppnTotal'        => number_format((round($b += $value->sales_order_detail_total, -2)/1.1)*10/100),
						'ppndppTotal'     => number_format(round($d += ($dppTotal + $ppnTotal), -2)),
						'grandTotal'      => number_format(round($c += ($value->sales_order_detail_total), -2))
					);

				}
				$no++;
			}
		}
		

		// echo json_encode($response);
		// die();
		$ppn_not_exist = false;
		$nonppn_not_exist = false;
		$special_not_exist = false;
		error_reporting(E_ALL ^ E_NOTICE);
		if (($response[2]['detail']) == undefined or count($response[2]['detail']) == 0) {
			$ppn_not_exist = true;
		}
		
		if (($response[1]['detail']) == undefined or count($response[1]['detail']) == 0) {
			$nonppn_not_exist = true;
		}

		if (($response[0]['detail']) == undefined or count($response[0]['detail']) == 0) {
			$special_not_exist = true;
		}
		
		$data['content_title']     = 'Print Penjualan';
		$data['header']            = $header;
		$data['config_receipt1']   = $config_receipt1;
		$data['config_receipt2']   = $config_receipt2;
		$data['config_receipt3']   = $config_receipt3;
		$data['customer_name']     = $customer_name;
		$data['customer_nik']      = $customer_ktp;
		$data['customer_npwp']     = $customer_npwp;
		$data['printed_date']      = $printed_date;
		$data['maintenance_data']  = $get_data;
		$data['get_data']          = $response;
		$data['ppn_not_exist']     = $ppn_not_exist;
		$data['nonppn_not_exist']  = $nonppn_not_exist;
		$data['special_not_exist'] = $special_not_exist;

		$this->twiggy_display('adm/sales_orders/receipt', $data);
	}

	public function printout_invoice($id)
	{	
		$truncate_stored_invoice = $this->Sales_orders_model->truncate_stored_invoice();
		$fill_stored_invoice     = $this->stored_invoice($id);
		$this->session->set_userdata('so_id', $id);

		date_default_timezone_set('Asia/Jakarta');
		$where_header = array('sales_order_header_id' => $id);
		$where_config1 = array('ppn_status' => '1', 'is_active' => '1');
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');
		$where_config3 = array('ppn_status' => '3', 'is_active' => '1');
		
		$header          = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$config_receipt1 = $this->Configuration_model->get_data_invoice($where_config1)->row_array();
		$config_receipt2 = $this->Configuration_model->get_data_invoice($where_config2)->row_array();
		$config_receipt3 = $this->Configuration_model->get_data_invoice($where_config3)->row_array();
		// $user_handle = $this->Users_model->get_data_advance($header['sales_order_header_user_id'])->row()->fullname;
		$customer_name = $header['customer_name'];
		$customer_ktp  = $header['customer_ktp'];
		$customer_npwp = $header['customer_npwp'];

		$printed_date = $header['printed_date'];
		if($printed_date == '0000-00-00'){
			$printed_date = $header['sales_order_header_date'];
		}
		
		// $printed_date = date('H:i:s');
		$get_data     = $this->Sales_orders_model->ppn_status('', 'FIELD(ppn_status_id, "3", "1", "2")')->result();
		$get_data1     = $this->Sales_orders_model->ppn_status(array("ppn_status_id" => "1"))->result();
		$get_data2     = $this->Sales_orders_model->ppn_status(array("ppn_status_id" => "2"))->result();
		$get_data3     = $this->Sales_orders_model->ppn_status(array("ppn_status_id" => "3"))->result();
		
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $k => $get_row)
			{
				$response[] = [
					'number' => $no,
					'ppn_id'     => $get_row->ppn_status_id,
					'ppn_name'   => $get_row->ppn_status_name
				];

				$where_detail = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => $get_row->ppn_status_id);
				$temp = $this->Sales_orders_model->salesorder_detail3($where_detail, 'unit_priority')->result();
				$a = 0;
				$b = 0;
				$c = 0;
				$d = 0;
				$np = 0;

				foreach ($temp as $key => $value) {

					$dppTotal = $value->sales_order_detail_result;

					// $dppTotalRnd = round($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small, -2);
					$ppnTotal       = $value->sales_order_detail_ppn_total;
					$tax_percentage = $value->ppn_amount;

					$price_large    = $value->sales_order_detail_unit_price;
					if($value->sales_order_detail_ppn_status == 2){
						$price_large   = $value->sales_order_detail_unit_price + ($value->sales_order_detail_unit_price * ($tax_percentage/100));
					}
					$result_large  = (round($price_large) * $value->sales_order_detail_unit_quantity);


					$response[$k]['detail'][$key] = array(	
						'item_name'       => $value->sales_order_detail_item_name,
						'unit_large'      => $value->sales_order_detail_unit,
						'quantity_large'  => to_decimal($value->sales_order_detail_unit_quantity),
						'price_large'     => number_format($price_large),
						'result_large'    => number_format($result_large),
						'dppTotal'        => number_format(round($np += ($value->sales_order_detail_result), -2)),
						'dppTotalppn'     => number_format((round($a += $value->sales_order_detail_total, -2)/1.1)),
						'ppnTotal'        => number_format((round($b += $value->sales_order_detail_total, -2)/1.1)*10/100),
						'ppndppTotal'     => number_format(round($d += ($dppTotal + $ppnTotal), -2)),
						'grandTotal'      => number_format(round($c += ($value->sales_order_detail_total), -2))
					);

				}
				$no++;
			}
		}

		if($get_data1)
		{
			$no = 1;
			foreach($get_data1 as $k => $get_row)
			{
				$response[] = [
					'number' => $no,
					'ppn_id'     => $get_row->ppn_status_id,
					'ppn_name'   => $get_row->ppn_status_name
				];

				$where_detail = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => $get_row->ppn_status_id);
				$temp = $this->Sales_orders_model->salesorder_detail3($where_detail, 'unit_priority')->result();
				$a = 0;
				$b = 0;
				$c = 0;
				$d = 0;
				$np = 0;

				foreach ($temp as $key => $value) {

					$dppTotal = $value->sales_order_detail_result;

					// $dppTotalRnd = round($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small, -2);
					$ppnTotal       = $value->sales_order_detail_ppn_total;
					$tax_percentage = $value->ppn_amount;

					$price_large    = $value->sales_order_detail_unit_price;
					if($value->sales_order_detail_ppn_status == 2){
						$price_large   = $value->sales_order_detail_unit_price + ($value->sales_order_detail_unit_price * ($tax_percentage/100));
					}
					$result_large  = (($price_large) * $value->sales_order_detail_unit_quantity);


					$response1[$k]['detail'][$key] = array(	
						'item_name'       => $value->sales_order_detail_item_name,
						'unit_large'      => $value->sales_order_detail_unit,
						'quantity_large'  => to_decimal($value->sales_order_detail_unit_quantity),
						'price_large'     => number_format($price_large),
						'result_large'    => number_format($result_large),
						'dppTotal'        => number_format(round($np += ($value->sales_order_detail_result), 2)),
						'dppTotalppn'     => number_format((round($a += $value->sales_order_detail_total, 2)/1.1)),
						'ppnTotal'        => number_format((round($b += $value->sales_order_detail_total, 2)/1.1)*10/100),
						'ppndppTotal'     => number_format(round($d += ($dppTotal + $ppnTotal), 2)),
						'grandTotal'      => number_format(round($c += ($value->sales_order_detail_total), 2))
					);

					// $response1[$k]['detail'][$key] = array(	
					// 	'item_name'       => $value->sales_order_detail_item_name,
					// 	'unit_large'      => $value->sales_order_detail_unit,
					// 	'quantity_large'  => to_decimal($value->sales_order_detail_unit_quantity),
					// 	'price_large'     => number_format($price_large),
					// 	'result_large'    => number_format($result_large),
					// 	'dppTotal'        => number_format(($np += ($value->sales_order_detail_total))),
					// 	'dppTotalppn'     => number_format((($a += $value->sales_order_detail_total)/1.1)),
					// 	'ppnTotal'        => number_format((($b += $value->sales_order_detail_total)/1.1)*10/100),
					// 	'ppndppTotal'     => number_format(($d += ($dppTotal + $ppnTotal))),
					// 	'grandTotal'      => number_format(($c += ($value->sales_order_detail_total)))
					// );

				}
				$no++;
			}
		}

		if($get_data2)
		{
			$no = 1;
			foreach($get_data2 as $k => $get_row)
			{
				$response[] = [
					'number' => $no,
					'ppn_id'     => $get_row->ppn_status_id,
					'ppn_name'   => $get_row->ppn_status_name
				];

				$where_detail = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => $get_row->ppn_status_id);
				$temp = $this->Sales_orders_model->salesorder_detail3($where_detail, 'unit_priority')->result();
				$a = 0;
				$b = 0;
				$ax = 0;
				$bx = 0;
				$c = 0;
				$d = 0;
				$np = 0;

				foreach ($temp as $key => $value) {

					$dppTotal = $value->sales_order_detail_total;

					// $dppTotalRnd = round($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small, -2);
					$ppnTotal       = (($value->sales_order_detail_total)/1.1)*10/100;
					$tax_percentage = $value->ppn_amount;

					$price_large    = round($value->sales_order_detail_unit_price, 1);
					if($value->sales_order_detail_ppn_status == 2){
						$price_large   = round($value->sales_order_detail_unit_price + ($value->sales_order_detail_unit_price * ($tax_percentage/100)) , -1);
					}
					$result_large  = (($price_large) * $value->sales_order_detail_unit_quantity);


					$response2[$k]['detail'][$key] = array(	
						'item_name'       => $value->sales_order_detail_item_name,
						'unit_large'      => $value->sales_order_detail_unit,
						'quantity_large'  => to_decimal($value->sales_order_detail_unit_quantity),
						'price_large'     => number_format($price_large),
						'result_large'    => number_format($result_large),
						'dppTotal'        => number_format(($np += ($value->sales_order_detail_total))),
						'dppTotalppn'     => number_format((($a += $result_large)/1.1)),
						'dppTotalppnx'     => ((($ax += $result_large)/1.1)),
						'ppnTotal'        => number_format((($b += $value->sales_order_detail_total)/1.1)*10/100),
						'ppnTotalx'        => ((($bx += $value->sales_order_detail_total)/1.1)*10/100),

						'ppndppTotal'     => number_format(($d +=($result_large)/1.1) + (($value->sales_order_detail_total)/1.1)*10/100),

						'grandTotal'      => number_format(($c += ($value->sales_order_detail_total)))
					);

				}
				$no++;
			}
		}

		if($get_data3)
		{
			$no = 1;
			foreach($get_data3 as $k => $get_row)
			{
				$response[] = [
					'number' => $no,
					'ppn_id'     => $get_row->ppn_status_id,
					'ppn_name'   => $get_row->ppn_status_name
				];

				$where_detail = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => $get_row->ppn_status_id);
				$temp = $this->Sales_orders_model->salesorder_detail3($where_detail, 'unit_priority')->result();
				$a = 0;
				$b = 0;
				$c = 0;
				$d = 0;
				$np = 0;

				foreach ($temp as $key => $value) {

					$dppTotal = $value->sales_order_detail_result;

					// $dppTotalRnd = round($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small, -2);
					$ppnTotal       = $value->sales_order_detail_ppn_total;
					$tax_percentage = $value->ppn_amount;

					$price_large    = $value->sales_order_detail_unit_price;
					if($value->sales_order_detail_ppn_status == 2){
						$price_large   = $value->sales_order_detail_unit_price + ($value->sales_order_detail_unit_price * ($tax_percentage/100));
					}
					$result_large  = (round($price_large) * $value->sales_order_detail_unit_quantity);


					$response3[$k]['detail'][$key] = array(	
						'item_name'       => $value->sales_order_detail_item_name,
						'unit_large'      => $value->sales_order_detail_unit,
						'quantity_large'  => to_decimal($value->sales_order_detail_unit_quantity),
						'price_large'     => number_format($price_large),
						'result_large'    => number_format($result_large),
						'dppTotal'        => number_format(round($np += ($value->sales_order_detail_result), -2)),
						'dppTotalppn'     => number_format((round($a += $value->sales_order_detail_total, -2)/1.1)),
						'ppnTotal'        => number_format((round($b += $value->sales_order_detail_total, -2)/1.1)*10/100),
						'ppndppTotal'     => number_format(round($d += ($dppTotal + $ppnTotal), -2)),
						'grandTotal'      => number_format(round($c += ($value->sales_order_detail_total), -2))
					);

				}
				$no++;
			}
		}
		

		// echo json_encode($response);
		// die();
		$ppn_not_exist = false;
		$nonppn_not_exist = false;
		$special_not_exist = false;
		error_reporting(E_ALL ^ E_NOTICE);
		if (($response[2]['detail']) == undefined or count($response[2]['detail']) == 0) {
			$ppn_not_exist = true;
		}
		
		if (($response[1]['detail']) == undefined or count($response[1]['detail']) == 0) {
			$nonppn_not_exist = true;
		}

		if (($response[0]['detail']) == undefined or count($response[0]['detail']) == 0) {
			$special_not_exist = true;
		}
		
		$data['content_title']     = 'Print Penjualan';
		$data['header']            = $header;
		$data['config_receipt1']   = $config_receipt1;
		$data['config_receipt2']   = $config_receipt2;
		$data['config_receipt3']   = $config_receipt3;
		$data['customer_name']     = $customer_name;
		$data['customer_nik']      = $customer_ktp;
		$data['customer_npwp']     = $customer_npwp;
		$data['printed_date']      = $printed_date;
		$data['maintenance_data']  = $get_data;
		$data['get_data']          = $response;
		$data['get_data1']         = $response1;
		$data['get_data2']         = $response2;
		$data['get_data3']         = $response3;
		$data['ppn_not_exist']     = $ppn_not_exist;
		$data['nonppn_not_exist']  = $nonppn_not_exist;
		$data['special_not_exist'] = $special_not_exist;

		// $this->twiggy_display('adm/sales_orders/receipt', $data);
		$this->twiggy_display('adm/sales_orders/invoice', $data);
	}

	public function stored_invoice($id)
	{	
		$detail_data = [];
		
		$where    = array('sales_order_detail_header_id' => $id);
		$order    = array('item_name' => 'asc');
		$get_data = $this->Sales_orders_model->salesorder_detail($where, 'b.item_name asc')->result();

		$where_header   = array('sales_order_header_id' => $id);
		$header_data    = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$tax_percentage = ($header_data['ppn_amount']);

		foreach($get_data as $get_row)
		{

			if($get_row->sales_order_detail_large_unit_quantity > 0){
				$ppn_total_large = 0;
				$total_large     = $get_row->sales_order_detail_total;
				
				if($get_row->sales_order_detail_ppn_status == "2"){
					$ppn_total_large = $get_row->sales_order_detail_result_large * ($tax_percentage/100);
					$total_large     = $get_row->sales_order_detail_result_large + $ppn_total_large;
				}

				$detail_data[] = [
					'sales_order_detail_header_id'     => $get_row->sales_order_detail_header_id,
					'sales_order_detail_item_id'       => $get_row->sales_order_detail_item_id,
					'sales_order_detail_item_name'     => $get_row->sales_order_detail_item_name,
					'sales_order_detail_unit'          => $get_row->sales_order_detail_large_unit,
					'sales_order_detail_unit_quantity' => $get_row->sales_order_detail_large_unit_quantity,
					'sales_order_detail_unit_price'    => $get_row->sales_order_detail_large_unit_price,
					'sales_order_detail_result'        => $get_row->sales_order_detail_result_large,
					'sales_order_detail_ppn_status'    => $get_row->sales_order_detail_ppn_status,
					'sales_order_detail_ppn_total'     => $ppn_total_large,
					'sales_order_detail_total'         => $total_large,
				];
			}
			if($get_row->sales_order_detail_medium_unit_quantity > 0){

				$ppn_total_medium = 0;
				$total_medium     = $get_row->sales_order_detail_total;
				
				if($get_row->sales_order_detail_ppn_status == "2"){
					$ppn_total_medium = $get_row->sales_order_detail_result_medium * ($tax_percentage/100);
					$total_medium     = $get_row->sales_order_detail_result_medium + $ppn_total_medium;
				}

				$detail_data[] = [
					'sales_order_detail_header_id'     => $get_row->sales_order_detail_header_id,
					'sales_order_detail_item_id'       => $get_row->sales_order_detail_item_id,
					'sales_order_detail_item_name'     => $get_row->sales_order_detail_item_name,
					'sales_order_detail_unit'          => $get_row->sales_order_detail_medium_unit,
					'sales_order_detail_unit_quantity' => $get_row->sales_order_detail_medium_unit_quantity,
					'sales_order_detail_unit_price'    => $get_row->sales_order_detail_medium_unit_price,
					'sales_order_detail_result'        => $get_row->sales_order_detail_result_medium,
					'sales_order_detail_ppn_status'    => $get_row->sales_order_detail_ppn_status,
					'sales_order_detail_ppn_total'     => $ppn_total_medium,
					'sales_order_detail_total'         => $total_medium,
				];
			}

			if($get_row->sales_order_detail_small_unit_quantity > 0){

				$ppn_total_small = 0;
				$total_small     = $get_row->sales_order_detail_total;
				
				if($get_row->sales_order_detail_ppn_status == "2"){
					$ppn_total_small = $get_row->sales_order_detail_result_small * ($tax_percentage/100);
					$total_small     = $get_row->sales_order_detail_result_small + $ppn_total_small;
				}

				$detail_data[] = [
					'sales_order_detail_header_id'     => $get_row->sales_order_detail_header_id,
					'sales_order_detail_item_id'       => $get_row->sales_order_detail_item_id,
					'sales_order_detail_item_name'     => $get_row->sales_order_detail_item_name,
					'sales_order_detail_unit'          => $get_row->sales_order_detail_small_unit,
					'sales_order_detail_unit_quantity' => $get_row->sales_order_detail_small_unit_quantity,
					'sales_order_detail_unit_price'    => $get_row->sales_order_detail_small_unit_price,
					'sales_order_detail_result'        => $get_row->sales_order_detail_result_small,
					'sales_order_detail_ppn_status'    => $get_row->sales_order_detail_ppn_status,
					'sales_order_detail_ppn_total'     => $ppn_total_small,
					'sales_order_detail_total'         => $total_small,
				];
			}
			

		}

		$save = $this->Sales_orders_model->save_stored_invoice($detail_data, true);
			
		$status = false;
		if($save){
			$status = true;
		}

		return $status;
	}

	public function print_out2($id)
	{	
		date_default_timezone_set('Asia/Jakarta');
		$where_header = array('sales_order_header_id' => $id);
		$where_config1 = array('ppn_status' => '1', 'is_active' => '1');
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');
		$where_config3 = array('ppn_status' => '3', 'is_active' => '1');
		
		$header          = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$config_receipt1 = $this->Configuration_model->get_data_invoice($where_config1)->row_array();
		$config_receipt2 = $this->Configuration_model->get_data_invoice($where_config2)->row_array();
		$config_receipt3 = $this->Configuration_model->get_data_invoice($where_config3)->row_array();
		// $user_handle = $this->Users_model->get_data_advance($header['sales_order_header_user_id'])->row()->fullname;
		$customer_name = $header['customer_name'];
		$customer_ktp  = $header['customer_ktp'];
		$customer_npwp = $header['customer_npwp'];
		$printed_date = date('H:i:s');

		$where_nonppn = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => 1);
		$where_ppn    = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => 2);
		$where_khusus = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => 3);

		$order = 'large_unit_pr asc, medium_unit_pr asc, small_unit_pr asc';

		$getdata_nonppn = $this->Sales_orders_model->salesorder_detail($where_nonppn, $order)->result();
		$getdata_ppn    = $this->Sales_orders_model->salesorder_detail($where_ppn, $order)->result();
		$getdata_khusus = $this->Sales_orders_model->salesorder_detail($where_khusus, $order)->result();
		
		if($getdata_nonppn)
		{
			$no = 1;
			$a = 0;
			$b = 0;
			$c = 0;
			$d = 0;

			foreach($getdata_nonppn as $get_row)
			{
				$data_nonppn[] = array(
					'number'          => $no,
					'item_name'       => $get_row->sales_order_detail_item_name,
					'unit_large'      => $get_row->sales_order_detail_large_unit,
					'quantity_large'  => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'price_large'     => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'    => number_format($get_row->sales_order_detail_result_large),
					'unit_medium'     => $get_row->sales_order_detail_medium_unit,
					'quantity_medium' => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'price_medium'    => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'   => number_format($get_row->sales_order_detail_result_medium),
					'unit_small'      => $get_row->sales_order_detail_small_unit,
					'quantity_small'  => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'price_small'     => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'    => number_format($get_row->sales_order_detail_result_small),
					'dppTotal'        => number_format($a += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small)),
					'ppnTotal'        => number_format($b += ($get_row->sales_order_detail_ppn_total)),
					'ppndppTotal'     => number_format($d += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small + $get_row->sales_order_detail_ppn_total)),
					'grandTotal'      => number_format($c += ($get_row->sales_order_detail_total))
				);
				$no++;
			}
		}

		if($getdata_ppn)
		{
			$no = 1;
			$a = 0;
			$b = 0;
			$c = 0;
			$d = 0;

			foreach($getdata_ppn as $get_row)
			{
				$data_ppn[] = array(
					'number'          => $no,
					'item_name'       => $get_row->sales_order_detail_item_name,
					'unit_large'      => $get_row->sales_order_detail_large_unit,
					'quantity_large'  => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'price_large'     => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'    => number_format($get_row->sales_order_detail_result_large),
					'unit_medium'     => $get_row->sales_order_detail_medium_unit,
					'quantity_medium' => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'price_medium'    => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'   => number_format($get_row->sales_order_detail_result_medium),
					'unit_small'      => $get_row->sales_order_detail_small_unit,
					'quantity_small'  => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'price_small'     => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'    => number_format($get_row->sales_order_detail_result_small),
					'dppTotal'        => number_format($a += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small)),
					'ppnTotal'        => number_format($b += ($get_row->sales_order_detail_ppn_total)),
					'ppndppTotal'     => number_format($d += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small + $get_row->sales_order_detail_ppn_total)),
					'grandTotal'      => number_format($c += ($get_row->sales_order_detail_total))
				);
				$no++;
			}
		}

		if($getdata_khusus)
		{
			$no = 1;
			$a = 0;
			$b = 0;
			$c = 0;
			$d = 0;

			foreach($getdata_khusus as $get_row)
			{
				$data_khusus[] = array(
					'number'          => $no,
					'item_name'       => $get_row->sales_order_detail_item_name,
					'unit_large'      => $get_row->sales_order_detail_large_unit,
					'quantity_large'  => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'price_large'     => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'    => number_format($get_row->sales_order_detail_result_large),
					'unit_medium'     => $get_row->sales_order_detail_medium_unit,
					'quantity_medium' => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'price_medium'    => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'   => number_format($get_row->sales_order_detail_result_medium),
					'unit_small'      => $get_row->sales_order_detail_small_unit,
					'quantity_small'  => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'price_small'     => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'    => number_format($get_row->sales_order_detail_result_small),
					'dppTotal'        => number_format($a += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small)),
					'ppnTotal'        => number_format($b += ($get_row->sales_order_detail_ppn_total)),
					'ppndppTotal'     => number_format($d += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small + $get_row->sales_order_detail_ppn_total)),
					'grandTotal'      => number_format($c += ($get_row->sales_order_detail_total))
				);
				$no++;
			}
		}
		
		
		$data['content_title']     = 'Print Penjualan';
		$data['header']            = $header;
		$data['config_receipt1']   = $config_receipt1;
		$data['config_receipt2']   = $config_receipt2;
		$data['config_receipt3']   = $config_receipt3;
		$data['customer_name']     = $customer_name;
		$data['customer_nik']      = $customer_ktp;
		$data['customer_npwp']     = $customer_npwp;
		$data['printed_date']      = $printed_date;
		// $data['maintenance_data']  = $get_data;
		// $data['data_nonppn']          = $data_nonppn;
		// $data['data_ppn']          = $data_ppn;
		$data['data_khusus']          = $data_khusus;
		// $data['ppn_not_exist']     = $ppn_not_exist;
		// $data['nonppn_not_exist']  = $nonppn_not_exist;
		// $data['special_not_exist'] = $special_not_exist;

		$this->twiggy_display('adm/sales_orders/receipt2', $data);
	}

	public function checkpoint($s_trx, $transaction_id, $transaction_date='', $customer_id='')
	{
		$where       = array('sales_order_detail_header_id' => $transaction_id);

		$data     = [];
		$data_req = [];
		$get_data = $this->Sales_orders_model->salesorder_detail($where)->result();
		$ttl_pts = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			
			foreach($get_data as $get_row)
			{
				$item_id = $get_row->sales_order_detail_item_id;
				$lg_qty  = to_decimal($get_row->sales_order_detail_large_unit_quantity);
				$lg_prc  = $get_row->sales_order_detail_total;

				$data[] = array(
					'id'                 => $get_row->sales_order_detail_item_id,
					'name'               => $get_row->sales_order_detail_item_name,
					'lg_unit'            => $get_row->sales_order_detail_large_unit,
					'lg_unit_qty'        => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'lg_unit_prc'        => number_format($get_row->sales_order_detail_total)
				);

				$where_requirements = array('ptsreq_detail_item_id' => $item_id);
				$where_period = '';
				if(isset($transaction_date) && $transaction_date != '')
				{
					$where_period   = change_format_date($transaction_date);
				}
				
				$get_data_requirements = $this->Ptsreqs_model->ptsreq_advance($where_requirements, $where_period)->result();
				foreach($get_data_requirements as $key => $get_row_requirements)
				{
					
					$get_header = $this->Ptsreqs_model->ptsreq_advance(array('ptsreq_detail_header_id' => $get_row_requirements->ptsreq_detail_header_id))->row();
					$calculate  = 0;
					if($get_row_requirements->ptsreq_detail_large_quantity > 0){
						$calculate  = ($lg_qty / to_decimal($get_row_requirements->ptsreq_detail_large_quantity));
					}else{
						$calculate  = ($lg_prc / $get_row_requirements->ptsreq_detail_large_unit_price);
					}

					$data_req[] = array(
						'id'             => $get_row_requirements->ptsreq_detail_id,
						'header_id'      => $get_row_requirements->ptsreq_detail_header_id,
						'item_id'        => $get_row_requirements->ptsreq_detail_item_id,
						'item_name'      => $get_row_requirements->ptsreq_detail_item_name,
						'lg_unit'        => $get_row_requirements->ptsreq_detail_large_unit,
						'lg_unit_qty'    => to_decimal($get_row_requirements->ptsreq_detail_large_quantity),
						'lg_unit_prc'    => number_format($get_row_requirements->ptsreq_detail_large_unit_price),
						'multiples'      => floor($calculate),
						'point_earned'   => floor($calculate * $get_header->ptsreq_header_total)
					);

					$header_id = $get_row_requirements->ptsreq_detail_header_id;
					$array_row = array_count_values(array_column($data_req, 'header_id'))[$header_id];
					$data_row  = count($this->Ptsreqs_model->ptsreq_advance(array('ptsreq_detail_header_id' => $get_row_requirements->ptsreq_detail_header_id))->result());

					if($array_row == $data_row){
						$filtered = array_filter($data_req, function($v) use ($header_id) { 
							return $v['header_id'] == $header_id; 
						});

						$get_multiples  = (min(array_column( $filtered, 'multiples' )));
						$get_pts        = floor($get_multiples) * $get_header->ptsreq_header_total;
						$ttl_pts       += $get_pts;
					}
					
				}
				
			}
		}

		// echo json_encode($data);
		// die();
		if($s_trx == 'new'){

			$where       = array('log_point_customer_id' => $customer_id);
			$log_data    = $this->Log_points_model->get_data_last($where)->row_array();
			$point_total = 0;
			$last_point_total  = 0;

			if(!empty($log_data)){
				$last_point_total = $log_data['log_point_total'];
			}

			$point_total = ($last_point_total + $ttl_pts);
			$header_data = [
				'log_point_type'           => 'SO',
				'log_point_transaction_id' => $transaction_id,
				'log_point_customer_id'    => $customer_id,
				'log_point_earned'         => $ttl_pts,
				'log_point_total'          => $point_total,
			];

			$save_header = $this->Log_points_model->save($header_data);

		}

		if($s_trx == 'update'){
			
			$where_1          = array('log_point_type' => 'SO', 'log_point_transaction_id' => $transaction_id, 'log_point_customer_id' => $customer_id);
			$log_point_id     = $this->Log_points_model->get_data($where_1)->row()->log_point_id;
			$where_2          = array('log_point_customer_id' => $customer_id, 'log_point_id <' => $log_point_id);
			$log_data_before  = $this->Log_points_model->get_data_last($where_2)->row_array();
			$point_total      = 0;
			$last_point_total = 0;

			if(!empty($log_data_before)){
				$last_point_total = $log_data_before['log_point_total'];
			}

			$point_total = ($last_point_total + $ttl_pts);
			$header_data = [
				'log_point_type'           => 'SO',
				'log_point_transaction_id' => $transaction_id,
				'log_point_customer_id'    => $customer_id,
				'log_point_earned'         => $ttl_pts,
				'log_point_total'          => $point_total,
			];
			
			$update_item  = $this->Log_points_model->update($where_1, $header_data);

			if($update_item){
				$where_3 = array('log_point_customer_id' => $customer_id, 'log_point_id >' => $log_point_id);
				$get_data_all_logs_by_customer = $this->Log_points_model->get_data($where_3)->result();

				if($get_data_all_logs_by_customer){
					foreach ($get_data_all_logs_by_customer as $row) {

						$where_3              = array('log_point_customer_id' => $row->log_point_customer_id, 'log_point_id <' => $row->log_point_id);
						$log_data_off         = $this->Log_points_model->get_data_last($where_3)->row_array();
						$point_total_off      = 0;
						$last_point_total_off = 0;

						if(!empty($log_data_off)){
							$last_point_total_off = $log_data_off['log_point_total'];
						}

						$point_total_off = ($last_point_total_off + $row->log_point_earned);
						$update_after = array(
							'log_point_total'  => $point_total_off,
						);

						$where_after = array(
							'log_point_id' => $row->log_point_id
						);

						$save_header = $this->Log_points_model->update($where_after, $update_after);

					}
				}else{
					return true;
				}
			}else{
				$save_header = false;
			}

		}

		if($s_trx == 'delete'){
			$save_header = false;
			$where = array('log_point_type' => 'SO', 'log_point_transaction_id' => $transaction_id);
			$get_data_log = $this->Log_points_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {
				
				$where_after = array('log_point_customer_id' => $row_list->log_point_customer_id, 'log_point_id >' => $row_list->log_point_id);
				$get_after   = $this->Log_points_model->get_data($where_after)->result();

				if($get_after){

					foreach ($get_after as $row_list_detail) {
						
						$where_delete = array('log_point_id' => $row_list->log_point_id);
						$delete  = $this->Log_points_model->delete($where_delete);

						$where_this   = array('log_point_id' => $row_list_detail->log_point_id, 'log_point_customer_id' => $row_list_detail->log_point_customer_id);
						$log_point_id = $this->Log_points_model->get_data($where_this)->row()->log_point_id;
						
						$where_3              = array('log_point_customer_id' => $row_list_detail->log_point_customer_id, 'log_point_id <' => $log_point_id);
						$log_data_off         = $this->Log_points_model->get_data_last($where_3)->row_array();
						$point_total_off      = 0;
						$last_point_total_off = 0;

						if(!empty($log_data_off)){
							$last_point_total_off = $log_data_off['log_point_total'];
						}

						$point_total_off = ($last_point_total_off + $row_list_detail->log_point_earned);
						$update_after = array(
							'log_point_total'  => $point_total_off,
						);

						$where_after = array(
							'log_point_id' => $row_list_detail->log_point_id
						);

						$save_header = $this->Log_points_model->update($where_after, $update_after);
					}
					
				}else{
					$where_delete = array('log_point_id' => $row_list->log_point_id);
					$save_header  = $this->Log_points_model->delete($where_delete);
				}
			}

		}
		
		if($save_header){
			return true;
		}else{
			return false;
		}
	}


	public function export_excel($id) {

		$where    = [];
		$where['sales_order_header_id'] = $id;

		$get_data = $this->Sales_orders_model->salesorder_detail_advance($where)->result();

		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PENJUALAN")
							   ->setSubject("PENJUALAN")
							   ->setDescription("PENJUALAN")
							   ->setKeywords("PENJUALAN");


	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "nomor");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "customer");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "grup");
	    $excel->setActiveSheetIndex(0)->setCellValue('E1', "levelgrup");
	    $excel->setActiveSheetIndex(0)->setCellValue('F1', "nama");
	    $excel->setActiveSheetIndex(0)->setCellValue('G1', "besar");
	    $excel->setActiveSheetIndex(0)->setCellValue('H1', "levelbsr");
	    $excel->setActiveSheetIndex(0)->setCellValue('I1', "qtybesar");
	    $excel->setActiveSheetIndex(0)->setCellValue('J1', "hjbesar");
	    $excel->setActiveSheetIndex(0)->setCellValue('K1', "discbsr");
		$excel->setActiveSheetIndex(0)->setCellValue('L1', "sedang");
	    $excel->setActiveSheetIndex(0)->setCellValue('M1', "levelsdg");
	    $excel->setActiveSheetIndex(0)->setCellValue('N1', "qtysedang");
	    $excel->setActiveSheetIndex(0)->setCellValue('O1', "hjsedang");
	    $excel->setActiveSheetIndex(0)->setCellValue('P1', "discsdg");
		$excel->setActiveSheetIndex(0)->setCellValue('Q1', "kecil");
	    $excel->setActiveSheetIndex(0)->setCellValue('R1', "levelkcl");
	    $excel->setActiveSheetIndex(0)->setCellValue('S1', "qtykecil");
	    $excel->setActiveSheetIndex(0)->setCellValue('T1', "hjkecil");
	    $excel->setActiveSheetIndex(0)->setCellValue('U1', "disckcl");
	    $excel->setActiveSheetIndex(0)->setCellValue('V1', "totalharga");
	    $excel->setActiveSheetIndex(0)->setCellValue('W1', "grandtotal");
	    $excel->setActiveSheetIndex(0)->setCellValue('X1', "bayar");
	    $excel->setActiveSheetIndex(0)->setCellValue('Y1', "sisa");
	    $excel->setActiveSheetIndex(0)->setCellValue('Z1', "status");
	    $excel->setActiveSheetIndex(0)->setCellValue('AA1', "username");
	    $excel->setActiveSheetIndex(0)->setCellValue('AB1', "keterangan");
		

	

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 9
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$grup = $this->Groups_model->get_data(array('group_id' => $get_row->item_group_id))->row();

			$unit_large  = $this->Units_model->get_data(array('unit_name' => $get_row->sales_order_detail_large_unit))->row_array();
			$unit_medium = $this->Units_model->get_data(array('unit_name' => $get_row->sales_order_detail_medium_unit))->row_array();
			$unit_small  = $this->Units_model->get_data(array('unit_name' => $get_row->sales_order_detail_small_unit))->row_array();

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->sales_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->printed_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $grup->group_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $grup->group_order);

			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $get_row->sales_order_detail_item_name);

			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? $get_row->sales_order_detail_large_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? (!empty($unit_large) ? $unit_large['unit_priority'] : '') : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? to_decimal($get_row->sales_order_detail_large_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? ($get_row->sales_order_detail_large_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? ($get_row->sales_order_detail_large_unit_discount) : ''));

			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? $get_row->sales_order_detail_medium_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity  > 0 ? (!empty($unit_medium) ? $unit_medium['unit_priority'] : '') : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? to_decimal($get_row->sales_order_detail_medium_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? ($get_row->sales_order_detail_medium_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('P'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity  > 0 ? ($get_row->sales_order_detail_medium_unit_discount) : ''));

			$excel->setActiveSheetIndex(0)->setCellValue('Q'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? $get_row->sales_order_detail_small_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('R'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? (!empty($unit_small) ? $unit_small['unit_priority'] : '') : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('S'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? to_decimal($get_row->sales_order_detail_small_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('T'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? ($get_row->sales_order_detail_small_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('U'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? ($get_row->sales_order_detail_small_unit_discount) : ''));

			$excel->setActiveSheetIndex(0)->setCellValue('V'.$numrow, ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small));
			
			$excel->setActiveSheetIndex(0)->setCellValue('W'.$numrow, $get_row->sales_order_header_grand_total);
			$excel->setActiveSheetIndex(0)->setCellValue('X'.$numrow, $get_row->sales_order_header_paid_total);
			$excel->setActiveSheetIndex(0)->setCellValue('Y'.$numrow, $get_row->sales_order_header_change_total);

			$excel->setActiveSheetIndex(0)->setCellValue('Z'.$numrow, $get_row->sales_order_detail_ppn_status);

			$username = $this->Users_model->get_data_advance($get_row->sales_order_header_user_id)->row()->fullname;
			$excel->setActiveSheetIndex(0)->setCellValue('AA'.$numrow, $username);
			$excel->setActiveSheetIndex(0)->setCellValue('AB'.$numrow, rtrim($get_row->sales_order_header_description));


			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			// $ppn_status       = $get_row->sales_order_detail_ppn_status;

			// $excel->getActiveSheet()->getStyle('A'.$numrow.':O'.$numrow)->applyFromArray($style_row);
			// if($ppn_status == '2'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_success);
			// }
			// if($ppn_status == '3'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_warning);
			// }

			// $excel->getActiveSheet()->getStyle('G'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			// $excel->getActiveSheet()->getStyle('J'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			// $excel->getActiveSheet()->getStyle('M'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			// $excel->getActiveSheet()->getStyle('N'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PENJUALAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		// $date_now = change_format_date(date_now(), 'Ymd');
		$filename = $get_data[0]->sales_order_header_number.'.csv';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    // $write = PHPExcel_IOFactory::createWriter($excel, 'Excel5');
		$write = new PHPExcel_Writer_CSV($excel);
	    $write->save('php://output');
	}

}

?>
