<?php
/**
 * Users Controllers
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Dashboard extends BaseController
{
	/**
	 * Construcktor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();

		$this->auth->check_auth();

		$this->load->model("Dashboards_model");
		$this->load->model("Items_model");
		$this->load->model("Suppliers_model");
		$this->load->model("Customers_model");
		$this->load->model("Purchase_orders_model");
		$this->load->model("Sales_orders_model");
		$this->load->model("Debts_model");
		$this->load->model("Credits_model");
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */
	public function index()
	{	
		$data['content_title'] = 'Dashboard';
		
		$date_end = date('Y-m-d', strtotime(date_now(). '+3 day'));
		$where_1  = '(purchase_order_header_payment_due BETWEEN "'.date_now().'" AND "'.$date_end.'") AND status_paid = "0"';
		$order_1  = 'purchase_order_header_payment_due ASC';
 		$data['notif_debt']    = $this->Purchase_orders_model->purchaseorder_header($where_1, $order_1)->result();

		$items_total              = count($this->Items_model->get_data()->result());
		$items_total_new          = $this->Dashboards_model->get_new_entry('master_items')->row()->count;
		$suppliers_total          = count($this->Suppliers_model->get_data()->result());
		$suppliers_total_new      = $this->Dashboards_model->get_new_entry('master_suppliers')->row()->count;
		$customers_total          = count($this->Customers_model->get_data()->result());
		$customers_total_new      = $this->Dashboards_model->get_new_entry('master_customers')->row()->count;
		$purchaseorders_total     = count($this->Purchase_orders_model->purchaseorder_header()->result());
		$purchaseorders_total_new = $this->Dashboards_model->get_new_entry('purchase_order_headers')->row()->count;
		$salesorders_total        = count($this->Sales_orders_model->salesorder_header()->result());
		$salesorders_total_new    = $this->Dashboards_model->get_new_entry('sales_order_headers')->row()->count;

		$where             = array('status_paid' => 0);
		$debts_total       = count($this->Purchase_orders_model->purchaseorder_header($where)->result());
		$debts_total_new   = $this->Dashboards_model->get_new_entry('purchase_order_headers', $where)->row()->count;
		$credits_total     = count($this->Sales_orders_model->salesorder_header($where)->result());
		$credits_total_new = $this->Dashboards_model->get_new_entry('sales_order_headers', $where)->row()->count;
	
		$data['items_total']          = $items_total;
		$data['items_total_new']      = $items_total_new;
		$data['items_percentage']     = 'style="width:'. round(($items_total_new/($items_total ?: 1)) * 100).'%"';
		$data['suppliers_total']      = $suppliers_total;
		$data['suppliers_total_new']  = $suppliers_total_new;
		$data['suppliers_percentage'] = 'style="width:'. round(($suppliers_total_new/($suppliers_total ?: 1)) * 100).'%"';
		$data['customers_total']      = $customers_total;
		$data['customers_total_new']  = $customers_total_new;
		$data['customers_percentage'] = 'style="width:'. round(($customers_total_new/($customers_total ?: 1)) * 100).'%"';
		$data['purchase_total']       = $purchaseorders_total;
		$data['purchase_total_new']   = $purchaseorders_total_new;
		$data['purchase_percentage']  = 'style="width:'. round(($purchaseorders_total_new/($purchaseorders_total ?: 1)) * 100).'%"';
		$data['sales_total']          = $salesorders_total;
		$data['sales_total_new']      = $salesorders_total_new;
		$data['sales_percentage']     = 'style="width:'. round(($salesorders_total_new/($salesorders_total ?: 1)) * 100).'%"';
		$data['debts_total']          = $debts_total;
		$data['debts_total_new']      = $debts_total_new;
		$data['debts_percentage']     = 'style="width:'. round(($debts_total_new/($debts_total ?: 1)) * 100).'%"';
		$data['credits_total']        = $credits_total;
		$data['credits_total_new']    = $credits_total_new;
		$data['credits_percentage']   = 'style="width:'. round(($credits_total_new/($credits_total ?: 1)) * 100).'%"';

		// $data['ongoing_program']      = $this->get_ongoing_program();
		// $data['next_public_program']  = $this->get_next_public();
		// $data['next_inhouse_program'] = $this->get_next_inhouse();

		$this->twiggy_display('adm/dashboard/index', $data);
	}

	public function get_ongoing_program(){
		$response = [];
		$where = array(
			'batch_header_start <=' => date_now(),
			'batch_header_end >='   => date_now(),
		);
			
		$gets_data = $this->Dashboards_model->get_data_program($where)->result();
		$bgcolor = array("bg-wildgreen", "bg-cassandrayellow", "bg-pastelred", "bg-info", "bg-primary", "bg-success");

		foreach($gets_data as $get_row)
		{	
			$no = 0;
			$icon = ($get_row->program_header_type_id == 1 ? 'fas fa-random' : 'fa-compress-arrows-alt');
			$response[] = array(
				'no'         => $no,
				'id'         => $get_row->program_header_id,
				'name'       => $get_row->program_header_name,
				'batch'      => $get_row->batch_header_name,
				'type'       => $get_row->program_type_name,
				'start_date' => $get_row->batch_header_start,
				'end_date'   => $get_row->batch_header_end,
				'icon'       => $icon,
				'bgcolor'    => 'bg-info',
				'link'       => site_url('adm/grad_requirements/edit/'.$get_row->batch_header_id)
				// 'bgcolor'    => $bgcolor[rand(0,5)]
			);
			$no++;
		}
		
		return $response;
	}

	public function get_next_public(){
		$response = [];
		$where = array(
			'batch_header_start >'   => date_now(),
			'program_header_type_id' => '1',
		);
			
		$gets_data = $this->Dashboards_model->get_data_program($where)->result();
		$bgcolor = array("bg-wildgreen", "bg-cassandrayellow", "bg-pastelred", "bg-info", "bg-primary", "bg-success", "bg-oranges");

		foreach($gets_data as $get_row)
		{	
			$no = 0;
			$icon = ($get_row->program_header_type_id == 1 ? 'fas fa-random' : 'fa-compress-arrows-alt');
			$response[] = array(
				'no'         => $no,
				'id'         => $get_row->program_header_id,
				'name'       => $get_row->program_header_name,
				'batch'      => $get_row->batch_header_name,
				'type'       => $get_row->program_type_name,
				'start_date' => $get_row->batch_header_start,
				'end_date'   => $get_row->batch_header_end,
				'icon'       => $icon,
				'bgcolor'    => $bgcolor[rand(0,6)]
			);
			$no++;
		}
		
		return $response;
	}

	public function get_next_inhouse(){
		$response = [];
		$where = array(
			'batch_header_start >'   => date_now(),
			'program_header_type_id' => '2',
		);
			
		$gets_data = $this->Dashboards_model->get_data_program($where)->result();
		$bgcolor = array("bg-wildgreen", "bg-cassandrayellow", "bg-pastelred", "bg-info", "bg-primary", "bg-success", "bg-oranges");

		foreach($gets_data as $get_row)
		{	
			$no = 0;
			$icon = ($get_row->program_header_type_id == 1 ? 'fas fa-random' : 'fa-compress-arrows-alt');
			$response[] = array(
				'no'         => $no,
				'id'         => $get_row->program_header_id,
				'name'       => $get_row->program_header_name,
				'batch'      => $get_row->batch_header_name,
				'type'       => $get_row->program_type_name,
				'start_date' => $get_row->batch_header_start,
				'end_date'   => $get_row->batch_header_end,
				'icon'       => $icon,
				'bgcolor'    => $bgcolor[rand(0,6)]
			);
			$no++;
		}
		
		return $response;
	}


	/**
	 * Logout
	 */
	public function logout()
	{
		$this->session->sess_destroy();

		redirect('loginweb');
	}
}
?>
