<?php
/**
 * Log Points Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Log_points_model extends Model {

	public function get_data($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('log_points a');
	    $sql->join('master_customers b', 'b.customer_id = a.log_point_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_point_total($date='')
	{
		$sql = "
		SELECT *
		FROM log_points
		INNER JOIN master_customers on master_customers.customer_id = log_points.log_point_customer_id
		LEFT JOIN sales_order_headers on sales_order_headers.sales_order_header_id = log_points.log_point_transaction_id AND log_points.log_point_type='SO'
	    LEFT JOIN ptsredeems on ptsredeems.ptsredeem_id = log_points.log_point_transaction_id AND log_points.log_point_type='RD'
		WHERE log_point_id IN (
			SELECT MAX(log_point_id)
			FROM log_points
			WHERE log_point_total != 0
			GROUP BY log_point_customer_id
		) 
		
		ORDER BY customer_name
		";
		if($date){
			$sql = "
			SELECT *
			FROM log_points
			INNER JOIN master_customers on master_customers.customer_id = log_points.log_point_customer_id
			LEFT JOIN sales_order_headers on sales_order_headers.sales_order_header_id = log_points.log_point_transaction_id AND log_points.log_point_type='SO'
			LEFT JOIN ptsredeems on ptsredeems.ptsredeem_id = log_points.log_point_transaction_id AND log_points.log_point_type='RD'
			WHERE log_point_id IN (
				SELECT MAX(log_point_id)
				FROM log_points
				WHERE log_point_total != 0
				AND date(log_points.timestamp) <= '".$date."'
				GROUP BY log_point_customer_id
			) 
			
			ORDER BY customer_name
			";
		}

		return $this->db->query($sql);
	}


	public function get_data_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*, a.timestamp as tms_log');
	    $sql->from('log_points a');
		$sql->join('master_customers b', 'b.customer_id = a.log_point_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_advance($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*, a.timestamp as tms_log');
		$sql->from('log_points a');
		
	    $sql->join('master_customers b', 'b.customer_id = a.log_point_customer_id', 'left');
	    $sql->join('sales_order_headers c', 'c.sales_order_header_id = a.log_point_transaction_id AND a.log_point_type="SO"', 'left');
	    $sql->join('ptsredeems d', 'd.ptsredeem_id = a.log_point_transaction_id AND a.log_point_type="RD"', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_last($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('log_points a');
	    $sql->join('master_customers b', 'b.customer_id = a.log_point_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		$sql->order_by('a.timestamp', 'desc');
		$sql->limit(1);

		$get = $sql->get();

		return $get;
	}

	public function save($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('log_points', $data);
		}

		return $this->db->insert('log_points', $data);
	}

	public function update($where, $data) {
		$this->db->where($where);
		return $this->db->update('log_points', $data);
	}

	public function delete($where) {
		$this->db->where($where);
		return $this->db->delete("log_points");
	}

	public function truncate()
	{
		return $this->db->empty_table("log_points");
	}

}

?>
