<?php
/**
 * Requirements Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Requirements_model extends Model {

	public function get_data($id='') {
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_requirements');
		$sql->order_by('requirement_name');

		if ($id != "") {
			$sql->where('requirement_id', $id);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_advance($search='') {
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_requirements');
		$sql->order_by('requirement_name');

		if ($search != '')
		{
			$sql->like('requirement_code', $search);
			$sql->or_like('requirement_name', $search);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('master_requirements', $data);
	}

	public function update($id, $data) {
		$this->db->where('requirement_id', $id);
		return $this->db->update('master_requirements', $data);
	}

	public function delete($id) {
		$this->db->where('requirement_id', $id);
		return $this->db->delete('master_requirements');
	}

	public function check_id($where) {
		$this->db->select("*");
		$this->db->from('master_requirements');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}

}

?>
