<?php
/**
 * Access Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Access extends BaseController
{
    /**
     * Constructor CodeIgniter
     */
    public function __construct()
    {
        parent:: __construct();
        $this->auth->check_auth();

        // load model
        $this->load->model('Access_model');
    }

    /**
     * Halaman Index
     *
     * @return HTML
     */

    public function index()
    {
        $data['content_title'] = 'Manajemen Akses';

        $this->twiggy_display('adm/access/index', $data);
    }

    public function get_data_header()
    {
        $data     = [];
        $order    = 'header_id DESC';
        $get_data = $this->Access_model->access_header('', $order)->result();

        // ketika data tersedia
        // maka generate data json untuk Datatable
        if ($get_data) {
            $no = 1;
            foreach ($get_data as $get_row) {
                $data[] = [
                    'no'     => $no,
                    'id'     => $get_row->header_id,
                    'role'   => $get_row->header_role,
                    'desc'   => $get_row->header_description
                ];
                $no++;
            }
        }

        $response = [
            'data'         => $data,
            'recordsTotal' => count($data),
        ];

        output_json($response);
    }

    public function edit($id = 'new')
    {
        $title       = 'Tambah Manajemen Akses';
        $header_data = [null];

        if ($id != 'new') {
            $title       = 'Edit Manajemen Akses';
            $where       = ['header_id' => $id];
            $header_data = $this->Access_model->access_header($where)->row_array();
        }

        $data['id']            = $id;
        $data['content_title'] = $title;
        $data['header_data']   = $header_data;

        $this->twiggy_display('adm/access/edit', $data);
    }

    public function get_data_detail()
    {
        $id    = $this->input->post('id');
        $where = ['header_id' => $id];

        $data     = [];
        $get_data = $this->Access_model->access_detail($where)->result();

        // ketika data tersedia
        // maka generate data json untuk Datatable
        if ($get_data) {
            $no = 1;
            foreach ($get_data as $get_row) {
                $data[] = [
                    'no'        => $no,
                    'detail_id' => $get_row->detail_id,
                    'header_id' => $get_row->header_id,
                    'id'        => $get_row->menu_id,
                    'menu_head' => $get_row->menu_head,
                    'menu_sub'  => $get_row->menu_sub
                ];
                $no++;
            }
        }

        output_json($data);
    }

    public function get_embed()
    {
        $data = [];
        $data['content_title'] = 'Data Menu';
        
        $this->twiggy_display('adm/access/embed', $data);
    }

    public function get_data_embed()
    {
        $data     = [];
        $response = [];
        $search   = $this->input->post('search');

        $get_data = $this->Access_model->get_menu($search)->result();

        $no = 0;
        foreach ($get_data as $get_row) {
            $data[] = [
                'no'        => $no,
                'id'        => $get_row->menu_id,
                'menu_head' => $get_row->menu_head,
                'menu_sub'  => $get_row->menu_sub
            ];

            $no++;
        }

        $response = [
            'data'         => $data,
            'recordsTotal' => count($data),
        ];

        output_json($response);
    }

    public function save()
    {
        $id          = $this->input->post('id');
        $name        = $this->input->post('name');
        $description = $this->input->post('description');

        $vuedata   = $this->input->post('vuedata');
        $header_id = $id;

        $header_data = [
            'header_role'        => $name,
            'header_description' => $description
        ];

        $detail_data = [];

        // if save $id = new else update data
        if ($id == 'new') {
            // save header
            $save_header = $this->Access_model->save_header($header_data);
            if ($save_header) {

                $header_id = $this->db->insert_id();
                foreach ($vuedata as $row) {
                    $detail_data[] = [
                        'header_id' => $header_id,
                        'menu_id'   => $row['id']
                    ];
                }

                $save_detail = $this->Access_model->save_detail($detail_data, true);

                if ($save_detail) {
                    $msg    = 'Berhasil menyimpan data';
                    $status = 'success';
                } else {
                    $msg    = 'Gagal menyimpan data';
                    $status = 'error';
                }
            } else {
                $msg    = 'Gagal menyimpan data';
                $status = 'error';
            }
        } else {
            $delete_detail = $this->Access_model->delete_detail($id);

            if ($delete_detail) {
                $save_header = $this->Access_model->update_header($id, $header_data);

                if ($save_header) {
                    // $header_id = $this->db->insert_id();
                    foreach ($vuedata as $row) {
                        $detail_data[] = [
                            'header_id' => $header_id,
                            'menu_id'   => $row['id']
                        ];
                    }

                    $save_detail = $this->Access_model->save_detail($detail_data, true);

                    if ($save_detail) {
                        $msg    = 'Berhasil menyimpan data';
                        $status = 'success';
                    } else {
                        $msg    = 'Gagal menyimpan data';
                        $status = 'error';
                    }
                } else {
                    $msg    = 'Gagal menyimpan data';
                    $status = 'error';
                }
            } else {
                $msg    = 'Gagal menyimpan data';
                $status = 'error';
            }
        }

        $response = [
            'message' => $msg,
            'status'  => $status,
            'id'      => $header_id,
        ];
        output_json($response);
    }

    public function delete()
    {
        $id = $this->input->post('id');

        foreach ($id as $row) {

            $delete_header = $this->Access_model->delete_header($row);

            if ($delete_header) {
                $delete_type = $this->Access_model->delete_detail($row);
            }
        }

        $response = [
            'message' => 'Berhasil menghapus data',
            'status'  => 'success',
        ];

        output_json($response);
    }

}

?>
