<?php
/**
 * Report Averages Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_averages extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Logs_model');
		$this->load->model('Items_model');
		$this->load->model('Groups_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Rata - Rata';
        $data['item_data']     = $this->Items_model->get_data()->result();
        $data['group_data']    = $this->Groups_model->get_data()->result();
		
		$this->twiggy_display('adm/report_averages/index', $data);
	}

	public function get_data_detail()
	{	
		$item     = $this->input->post("item");
		$group    = $this->input->post("group");
		$date_log = $this->input->post("date_log");
		$status = $this->input->post("status");

        $data  = [];
		$where = [];
		$order = ("b.item_name, a.timestamp ASC");

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['a.log_item_id'] = $item;
		}
		if(isset($group) && $group != '' && $group != '(Semua)')
		{
			$where['b.item_group_id'] = $group;
		}
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where['date(a.timestamp) <='] = change_format_date($date_log);
		}
		
		$get_data = $this->Logs_model->get_data_detail($where, $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$status_name = "";
				if($get_row->log_type == "BUY"){
					$status_name = "Beli";
				}elseif($get_row->log_type == "SELL"){
					$status_name = "Jual";
				}elseif($get_row->log_type == "R-BUY"){
					$status_name = "Retur Beli";
				}elseif($get_row->log_type == "R-SELL"){
					$status_name = "Retur Jual";
				}else{
					$status_name = "Pengaturan Stok";
				}

				$lg_unit_cnt = ($get_row->log_large_unit  == "" ? "-" : to_decimal($get_row->log_large_unit_contain));
				$md_unit_cnt = ($get_row->log_medium_unit == "" ? "-" : to_decimal($get_row->log_medium_unit_contain));
				$sm_unit_cnt = ($get_row->log_small_unit  == "" ? "-" : to_decimal($get_row->log_small_unit_contain));

				$lg_unit_qty = ($get_row->log_large_unit  == "" ? "-" : to_decimal($get_row->log_large_unit_quantity));
				$md_unit_qty = ($get_row->log_medium_unit == "" ? "-" : to_decimal($get_row->log_medium_unit_quantity));
				$sm_unit_qty = ($get_row->log_small_unit  == "" ? "-" : to_decimal($get_row->log_small_unit_quantity));

				$lg_unit_pp  = ($get_row->log_large_unit  == "" ? "-" : number_format($get_row->log_large_unit_purchase_price));
				$md_unit_pp  = ($get_row->log_medium_unit == "" ? "-" : number_format($get_row->log_medium_unit_purchase_price));
				$sm_unit_pp  = ($get_row->log_small_unit  == "" ? "-" : number_format($get_row->log_small_unit_purchase_price));

				$lg_unit_sp  = ($get_row->log_large_unit  == "" ? "-" : number_format($get_row->log_large_unit_selling_price));
				$md_unit_sp  = ($get_row->log_medium_unit == "" ? "-" : number_format($get_row->log_medium_unit_selling_price));
				$sm_unit_sp  = ($get_row->log_small_unit  == "" ? "-" : number_format($get_row->log_small_unit_selling_price));

				$lg_unit_avg = ($get_row->log_large_unit  == "" || $lg_unit_cnt == 0 ? "-" : number_format($get_row->log_average_large_unit));
				$md_unit_avg = ($get_row->log_medium_unit == "" || $md_unit_cnt == 0 ? "-" : number_format($get_row->log_average_medium_unit));
				$sm_unit_avg = ($get_row->log_small_unit  == "" || $sm_unit_cnt == 0 ? "-" : number_format($get_row->log_average_small_unit));

				$data[] = array(
					'no'                  => $no,
					'log_id'              => $get_row->log_id,
					'date'                => change_format_date($get_row->tms_log, "d/m/y"),
					// 'status_name'         => $status_name,
					'status_name'         => $get_row->log_type,
					'item_name'           => $get_row->item_name,
					'group_name'          => $get_row->group_name,
					'lg_cnt'              => $lg_unit_cnt,
					'lg_qty'              => $lg_unit_qty,
					'lg_pp'               => $lg_unit_pp,
					'lg_sp'               => $lg_unit_sp,
					'md_cnt'              => $md_unit_cnt,
					'md_qty'              => $md_unit_qty,
					'md_pp'               => $md_unit_pp,
					'md_sp'               => $md_unit_sp,
					'sm_cnt'              => $sm_unit_cnt,
					'sm_qty'              => $sm_unit_qty,
					'sm_pp'               => $sm_unit_pp,
					'sm_sp'               => $sm_unit_sp,
					'total_trx'           => to_decimal($get_row->log_total_transaction_in_small_unit),
					'total_trx_rp'        => number_format($get_row->log_total_transaction_value),
					'total_stock'         => to_decimal($get_row->log_total_stock),
					'total_stock_rp'      => number_format($get_row->log_total_stock_value),
					'average_large_unit'  => $lg_unit_avg,
					'average_medium_unit' => $md_unit_avg,
					'average_small_unit'  => $sm_unit_avg,
				);
                $no++;
                
			}
		}
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('group', $group);
		$this->session->set_userdata('date_log', $date_log);
		$this->session->set_userdata('status', $status);

		output_json($data);
	}

	public function export_excel() {

		$item     = $this->session->userdata('item');
		$group    = $this->session->userdata('group');
		$date_log = $this->session->userdata('date_log');
		$status   = $this->session->userdata('status');

		$where = [];
		$order = ("b.item_name, a.log_id ASC");
		$item_name  = '-';
		$group_name = '-';

		$date_text = ($date_log == '' ? '-' : change_format_date($date_log, 'd/m/Y'));

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['a.log_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($group) && $group != '' && $group != '(Semua)')
		{
			$where['b.item_group_id'] = $group;
			$group_name = $this->Groups_model->get_data(array('group_id' => $group))->row()->group_name;
		}
		if(isset($status) && $status != '' && $status != '(Semua)')
		{
			$where['b.ppn_status'] = $status;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where['date(a.timestamp) <='] = change_format_date($date_log);
		}
		
		$get_data = $this->Logs_model->get_data_detail($where, $order)->result();

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("RATA RATA")
							   ->setSubject("RATA RATA")
							   ->setDescription("RATA RATA")
							   ->setKeywords("RATA RATA");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Rata - rata");
	    $excel->getActiveSheet()->mergeCells('A1:U1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3

		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Grup");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$group_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": ".$date_text);
		
		$excel->getActiveSheet()->mergeCells('A7:A8');
		$excel->getActiveSheet()->mergeCells('B7:B8');
		$excel->getActiveSheet()->mergeCells('C7:F7');
		$excel->getActiveSheet()->mergeCells('G7:J7');
		$excel->getActiveSheet()->mergeCells('K7:N7');

		$excel->getActiveSheet()->mergeCells('O7:O8');
		$excel->getActiveSheet()->mergeCells('P7:P8');
		$excel->getActiveSheet()->mergeCells('Q7:Q8');
		$excel->getActiveSheet()->mergeCells('R7:R8');
		$excel->getActiveSheet()->mergeCells('S7:S8');
		$excel->getActiveSheet()->mergeCells('T7:T8');
		$excel->getActiveSheet()->mergeCells('U7:U8');

	    $excel->setActiveSheetIndex(0)->setCellValue('A7', "Status");
	    $excel->setActiveSheetIndex(0)->setCellValue('B7', "Nama Barang");
	    $excel->setActiveSheetIndex(0)->setCellValue('C7', "Satuan Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('G7', "Satuan Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('K7', "Satuan Kecil");

		$excel->setActiveSheetIndex(0)->setCellValue('C8', "Isi");
		$excel->setActiveSheetIndex(0)->setCellValue('D8', "Qty");
		$excel->setActiveSheetIndex(0)->setCellValue('E8', "Beli");
		$excel->setActiveSheetIndex(0)->setCellValue('F8', "Jual");
		$excel->setActiveSheetIndex(0)->setCellValue('G8', "Isi");
		$excel->setActiveSheetIndex(0)->setCellValue('H8', "Qty");
		$excel->setActiveSheetIndex(0)->setCellValue('I8', "Beli");
		$excel->setActiveSheetIndex(0)->setCellValue('J8', "Jual");
		$excel->setActiveSheetIndex(0)->setCellValue('K8', "Isi");
		$excel->setActiveSheetIndex(0)->setCellValue('L8', "Qty");
		$excel->setActiveSheetIndex(0)->setCellValue('M8', "Beli");
		$excel->setActiveSheetIndex(0)->setCellValue('N8', "Jual");

		$excel->setActiveSheetIndex(0)->setCellValue('O7', "Total Transaksi (Qty Kecil)");
		$excel->setActiveSheetIndex(0)->setCellValue('P7', "Total Transaksi (Rupiah)");
		$excel->setActiveSheetIndex(0)->setCellValue('Q7', "Total Stok");
		$excel->setActiveSheetIndex(0)->setCellValue('R7', "Total Stok (Rupiah)");
		$excel->setActiveSheetIndex(0)->setCellValue('S7', "Average Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('T7', "Average Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('U7', "Average Kecil");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A7:A8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B7:B8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C7:F7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('G7:J7')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('K7:N7')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('C8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('F8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('G8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('J8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('K8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('L8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('M8')->applyFromArray($style_col);		
	    $excel->getActiveSheet()->getStyle('N8')->applyFromArray($style_col);

	    $excel->getActiveSheet()->getStyle('O7:O8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('P7:P8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('Q7:Q8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('R7:R8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('S7:S8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('T7:T8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('U7:U8')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 9; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$status_name = "";
			if($get_row->log_type == "BUY"){
				$status_name = "Beli";
			}elseif($get_row->log_type == "SELL"){
				$status_name = "Jual";
			}elseif($get_row->log_type == "R-BUY"){
				$status_name = "Retur Beli";
			}elseif($get_row->log_type == "R-SELL"){
				$status_name = "Retur Jual";
			}else{
				$status_name = "Pengaturan Stok";
			}

			// $lg_unit_cnt = ($get_row->log_large_unit  == "" ? "-" : to_decimal($get_row->log_large_unit_contain));
			// $md_unit_cnt = ($get_row->log_medium_unit == "" ? "-" : to_decimal($get_row->log_medium_unit_contain));
			// $sm_unit_cnt = ($get_row->log_small_unit  == "" ? "-" : to_decimal($get_row->log_small_unit_contain));

			// $lg_unit_qty = ($get_row->log_large_unit  == "" ? "-" : to_decimal($get_row->log_large_unit_quantity));
			// $md_unit_qty = ($get_row->log_medium_unit == "" ? "-" : to_decimal($get_row->log_medium_unit_quantity));
			// $sm_unit_qty = ($get_row->log_small_unit  == "" ? "-" : to_decimal($get_row->log_small_unit_quantity));

			// $lg_unit_pp  = ($get_row->log_large_unit  == "" ? "-" : number_format($get_row->log_large_unit_purchase_price));
			// $md_unit_pp  = ($get_row->log_medium_unit == "" ? "-" : number_format($get_row->log_medium_unit_purchase_price));
			// $sm_unit_pp  = ($get_row->log_small_unit  == "" ? "-" : number_format($get_row->log_small_unit_purchase_price));

			// $lg_unit_sp  = ($get_row->log_large_unit  == "" ? "-" : number_format($get_row->log_large_unit_selling_price));
			// $md_unit_sp  = ($get_row->log_medium_unit == "" ? "-" : number_format($get_row->log_medium_unit_selling_price));
			// $sm_unit_sp  = ($get_row->log_small_unit  == "" ? "-" : number_format($get_row->log_small_unit_selling_price));

			// $lg_unit_avg = ($get_row->log_large_unit  == "" ? "-" : number_format($get_row->log_average_large_unit));
			// $md_unit_avg = ($get_row->log_medium_unit == "" ? "-" : number_format($get_row->log_average_medium_unit));
			// $sm_unit_avg = ($get_row->log_small_unit  == "" ? "-" : number_format($get_row->log_average_small_unit));

			$lg_unit_cnt = ($get_row->log_large_unit  == "" ? "-" : to_decimal($get_row->log_large_unit_contain));
			$md_unit_cnt = ($get_row->log_medium_unit == "" ? "-" : to_decimal($get_row->log_medium_unit_contain));
			$sm_unit_cnt = ($get_row->log_small_unit  == "" ? "-" : to_decimal($get_row->log_small_unit_contain));

			$lg_unit_qty = ($get_row->log_large_unit  == "" ? "-" : to_decimal($get_row->log_large_unit_quantity));
			$md_unit_qty = ($get_row->log_medium_unit == "" ? "-" : to_decimal($get_row->log_medium_unit_quantity));
			$sm_unit_qty = ($get_row->log_small_unit  == "" ? "-" : to_decimal($get_row->log_small_unit_quantity));

			$lg_unit_pp  = ($get_row->log_large_unit  == "" ? "-" : $get_row->log_large_unit_purchase_price);
			$md_unit_pp  = ($get_row->log_medium_unit == "" ? "-" : $get_row->log_medium_unit_purchase_price);
			$sm_unit_pp  = ($get_row->log_small_unit  == "" ? "-" : $get_row->log_small_unit_purchase_price);

			$lg_unit_sp  = ($get_row->log_large_unit  == "" ? "-" : $get_row->log_large_unit_selling_price);
			$md_unit_sp  = ($get_row->log_medium_unit == "" ? "-" : $get_row->log_medium_unit_selling_price);
			$sm_unit_sp  = ($get_row->log_small_unit  == "" ? "-" : $get_row->log_small_unit_selling_price);

			$lg_unit_avg = ($get_row->log_large_unit  == "" ? "-" : $get_row->log_average_large_unit);
			$md_unit_avg = ($get_row->log_medium_unit == "" ? "-" : $get_row->log_average_medium_unit);
			$sm_unit_avg = ($get_row->log_small_unit  == "" ? "-" : $get_row->log_average_small_unit);

			
				
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $status_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $lg_unit_cnt);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $lg_unit_qty);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $lg_unit_pp);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $lg_unit_sp);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $md_unit_cnt);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $md_unit_qty);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $md_unit_pp);
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $md_unit_sp);
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, $sm_unit_cnt);
			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, $sm_unit_qty);
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, $sm_unit_pp);
			$excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, $sm_unit_sp);
			$excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, to_decimal($get_row->log_total_transaction_in_small_unit));
			$excel->setActiveSheetIndex(0)->setCellValue('P'.$numrow, $get_row->log_total_transaction_value);
			$excel->setActiveSheetIndex(0)->setCellValue('Q'.$numrow, to_decimal($get_row->log_total_stock));
			$excel->setActiveSheetIndex(0)->setCellValue('R'.$numrow, $get_row->log_total_stock_value);
			$excel->setActiveSheetIndex(0)->setCellValue('S'.$numrow, $lg_unit_avg);
			$excel->setActiveSheetIndex(0)->setCellValue('T'.$numrow, $md_unit_avg);
			$excel->setActiveSheetIndex(0)->setCellValue('U'.$numrow, $sm_unit_avg);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':U'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('C'.$numrow.':D'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			$excel->getActiveSheet()->getStyle('E'.$numrow.':F'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('G'.$numrow.':H'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			$excel->getActiveSheet()->getStyle('I'.$numrow.':J'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('K'.$numrow.':L'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			$excel->getActiveSheet()->getStyle('M'.$numrow.':N'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$excel->getActiveSheet()->getStyle('O'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			$excel->getActiveSheet()->getStyle('P'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('Q'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			$excel->getActiveSheet()->getStyle('R'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('S'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('T'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('U'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("RATA RATA");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'RATARATA_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
