<?php
/**
 * Special Prices Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Special_prices_model extends Model {

	public function get_data($where='', $order='', $group='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('master_special_prices a');
	    $sql->join('master_customers b', 'b.customer_id = a.customer_id', 'inner');
	    $sql->join('master_items c', 'c.item_id = a.item_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('master_special_prices', $data);
		}

		return $this->db->insert('master_special_prices', $data);
	}

	public function delete($id)
	{
		$this->db->where("customer_id", $id);
		return $this->db->delete("master_special_prices");
	}


}

?>
