<?php
/**
 * Imports Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Imports extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Stocks_model');
		$this->load->model('Logs_model');
		$this->load->model('Items_model');
		$this->load->model('Units_model');
		$this->load->model('Groups_model');
		$this->load->model('Group_customers_model');
		$this->load->model('Penerimaan_model');
		$this->load->model('Transfer_model');
		$this->load->model('Sales_orders_model');
	
		$this->load->model('Suppliers_model');
		$this->load->model('Customers_model');
		$this->load->model('Wholesale_prices_model');
		$this->load->model('Special_prices_model');
		$this->load->model('Group_prices_model');
	}
	
	public function index() {
		$data['content_title'] = 'Import Data';

		$data['msg_unit']      = $this->session->userdata('msg_unit');
		$data['msg_group']     = $this->session->userdata('msg_group');
		$data['msg_item']      = $this->session->userdata('msg_item');
		$data['msg_img_item']  = $this->session->userdata('msg_img_item');
		$data['msg_wholesale'] = $this->session->userdata('msg_wholesale');
		$data['msg_supplier']  = $this->session->userdata('msg_supplier');
		$data['msg_customer']  = $this->session->userdata('msg_customer');
		$data['msg_special']   = $this->session->userdata('msg_special');
		$data['msg_group_customer']   = $this->session->userdata('msg_group_customer');
		$data['msg_group_price']   = $this->session->userdata('msg_group_price');

		$this->twiggy_display('adm/imports/index', $data);
		$this->session->unset_userdata('msg_unit');
		$this->session->unset_userdata('msg_group');
		$this->session->unset_userdata('msg_item');
		$this->session->unset_userdata('msg_img_item');
		$this->session->unset_userdata('msg_wholesale');
		$this->session->unset_userdata('msg_supplier');
		$this->session->unset_userdata('msg_customer');
		$this->session->unset_userdata('msg_special');
		$this->session->unset_userdata('msg_group_customer');
		$this->session->unset_userdata('msg_group_price');
	}
	
	public function import_awal(){
	    $fileName_before = $_FILES['item_file_name']['name'];
		$fileName        = str_replace(" ", "_", $fileName_before);

		$path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';
        
         $upload_image = $_FILES['item_file_name']['name'];

        if ($upload_image) {
            $config['allowed_types'] = '*';
            $config['max_size']      = '4048'; //dalam kilo bite(kb)
            $config['upload_path']   = './assets/excels/upload_file/';

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('item_file_name')) {
                 $this->upload->data('item_file_name');
            } else {

                echo $this->upload->display_errors();
            }
        }
// 		if (!empty($_FILES['item_file_name']['name'])) {
// 			upload_file($path, $item_file_name, null, $allowedTypes);
// 		}

		$inputFileName = $path . $fileName;

		try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader     = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel   = $objReader->load($inputFileName);
		} catch (Exception $e) {
			die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
		}

		$sheet         = $objPHPExcel->getSheet(0);
		$highestRow    = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		$number_tr = 0;
		$header_id = 0;

		$no = 0;
		$insert = false;
		$save_detail = false;
		for ($row = 2; $row <= $highestRow; $row++) {                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);
            $no++;
			// $where = array("customer_name" => $rowData[0][40]);
			// $exist = $this->Customers_model->get_data($where)->row();
       

			if ($no == 1) {
			    $year = date('y');
		        $month = date('m');
			     $date_now = date_now();
			     $number_generator = '';
                $number_generator = $this->Penerimaan_model->purchaseorder_autonumber();
               $prefix     = 'PI';
		        $autonumber = $prefix . $year . $month . '-'.  $number_generator;
			    
			   
        		$header_data = [
        			'penerimaan_header_number'         => $autonumber,
        			'penerimaan_header_date'           => change_format_date($date_now),
        			'penerimaan_header_payment_due'    => '0000-00-00',
        			'penerimaan_header_customer_id'    => 1,
        			'penerimaan_header_purchase_id' => 0,
        			'penerimaan_header_sub_total'      => trims(0),
        			'penerimaan_header_ppn_id'         => 0,
        			'penerimaan_header_ppn_percentage' => 0,
        			'penerimaan_header_ppn_total'      => trims(0),
        			'penerimaan_header_grand_total'    => trims(0),
        			'penerimaan_header_description'    => "AWAL",
        			'penerimaan_header_warehouse_id'   => 7
        		];
				$insert = $this->db->insert("penerimaan_headers", $header_data);
				$header_id = $this->db->insert_id();
				$trheader_data = [
            			'header_number' => $autonumber,
            			'header_date'   => change_format_date($date_now),
            			'gudang_from'   => 0,
            			'gudang_to'     => 0
            		];
                $save_trheader = $this->Transfer_model->save_header($trheader_data);
				$trheader_id = $this->db->insert_id();

				$number_tr = $rowData[0][0];
			}

            $large_unit = 0;
            $medium_unit = 0;
            $small_unit = 0;
            $large_unit_contain = 0;
            $medium_unit_contain = 0;
            $small_unit_contain = 0;
            $large_unit_price = 0;
            $medium_unit_price = 0;
            $small_unit_price = 0;
			$item_id = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
			if($item_id != ""){
				$where_item_id    = array("item_name" => $item_id);
				$get_data_item = $this->Items_model->get_data($where_item_id)->row();
				if($get_data_item){
					$item_id = $get_data_item->item_id;
					$large_unit = $get_data_item->large_unit;
					$medium_unit = $get_data_item->medium_unit;
					$small_unit = $get_data_item->small_unit;
					$large_unit_contain = $get_data_item->large_unit_contain;
					$medium_unit_contain = $get_data_item->medium_unit_contain;
					$small_unit_contain = $get_data_item->small_unit_contain;
					$large_unit_price = $get_data_item->last_purchase_price_large_unit;
					$medium_unit_price = $get_data_item->last_purchase_price_medium_unit;
					$small_unit_price = $get_data_item->last_purchase_price_small_unit;
				// 	1 = $get_data_item->large_unit_contain;
				}
			}
			


			$detail_data[] = [
				'penerimaan_detail_header_id'            => $header_id,
				'penerimaan_detail_item_id'              => $item_id,
				'penerimaan_detail_item_name'            => ($rowData[0][1]  == NULL ? "" : $rowData[0][1]),
				'penerimaan_detail_large_unit'           => $large_unit,
				'penerimaan_detail_large_unit_quantity'  => ($rowData[0][6]  == NULL ? 0 : $rowData[0][6]),
				'penerimaan_detail_large_unit_price'     => ($rowData[0][5]  == NULL ? 0 : $rowData[0][5]),
				'penerimaan_detail_result_large'         => trims(($rowData[0][5]  == NULL ? 0 : $rowData[0][5]) * ($rowData[0][2]  == NULL ? 0 : $rowData[0][2])),
				// 'purchase_order_detail_medium_unit'          => $medium_unit,
				// 'purchase_order_detail_medium_unit_quantity' => ($rowData[0][2]  == NULL ? 0 : $rowData[0][2]),
				// 'purchase_order_detail_medium_unit_price'    => trims($medium_unit_price),
				// 'purchase_order_detail_result_medium'        => trims(($rowData[0][2]  == NULL ? 0 : ((int)$rowData[0][2] * (int)$medium_unit_price))),
				// 'purchase_order_detail_small_unit'           => $small_unit,
				// 'purchase_order_detail_small_unit_quantity'  => ($rowData[0][3]  == NULL ? 0 : $rowData[0][3]),
				// 'purchase_order_detail_small_unit_price'     => trims($small_unit_price),
				// 'purchase_order_detail_result_small'         => trims(($rowData[0][3]  == NULL ? 0 : ((int)$rowData[0][3] * (int)$small_unit_price))),
				'penerimaan_detail_discount_percentage'  => trims(0),
				'penerimaan_detail_discount_total'       => trims(0),
				'penerimaan_detail_total'                => trims(($rowData[0][5]  == NULL ? 0 : $rowData[0][5]) * ($rowData[0][2]  == NULL ? 0 : $rowData[0][2])),
			];

			$trdetail_data[] = [
				'header_id'      => $trheader_id,
				'transaction_id' => $header_id,
				'item_id'        => $item_id,
				'lg_qty'         => trims(($rowData[0][6]  == NULL ? 0 : $rowData[0][6])),
				// 'md_qty'         => trims(($rowData[0][2]  == NULL ? 0 : $rowData[0][2])),
				// 'sm_qty'         => trims(($rowData[0][3]  == NULL ? 0 : $rowData[0][3])),
				'status'         => "BUY",
			];

    	    $dtstamp                    = change_format_date($date_now) . " " . date("H:i:s");
			$where                      = array('log_item_id' => $item_id, 'a.timestamp <' => $dtstamp);
			$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
			$last_total_stock           = 0;
			$last_log_total_stock_value = 0;

			if (!empty($log_data_check)) {
				$last_total_stock      		= $log_data_check['log_total_stock'];
				$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
			}
        




			$log_total_transaction_in_small_unit = ((int)$large_unit_contain * (int)trims(($rowData[0][6]  == NULL ? 0 : $rowData[0][6])));
			$log_total_transaction_value = ((int)trims(($rowData[0][6]  == NULL ? 0 : $rowData[0][6])) * trims((int)($rowData[0][5]  == NULL ? 0 : $rowData[0][5])));
			$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
			$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
// 			$log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
// 			$log_average_medium_unit     = ($log_average_small_unit * $medium_unit_contain);
// 			$log_average_large_unit      = ($log_average_small_unit * $large_unit_contain);
			$log_data[] = [
				'log_type'                            => 'PNBUY',
				'log_transaction_id'                  => $header_id,
				'log_item_id'                         => $item_id,
				'log_large_unit'                      => $large_unit,
				'log_large_unit_contain'              => $large_unit_contain,
				'log_large_unit_quantity'             => trims(($rowData[0][6]  == NULL ? 0 : $rowData[0][6])),
				'log_large_unit_purchase_price'       => trims(($rowData[0][5]  == NULL ? 0 : $rowData[0][5])),
				'log_medium_unit'                     => $medium_unit,
				'log_medium_unit_contain'             => $medium_unit_contain,
				'log_medium_unit_quantity'            => trims(0),
				'log_medium_unit_purchase_price'      => trims($medium_unit_price),
				'log_small_unit'                      => $small_unit,
				'log_small_unit_contain'              => $small_unit_contain,
				'log_small_unit_quantity'             => trims(0),
				'log_small_unit_purchase_price'       => trims($small_unit_price),
				'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
				'log_total_transaction_value'         => $log_total_transaction_value,
				'log_total_stock'                     => $log_total_stock,
				'log_total_stock_value'               => $log_total_stock_value,
				'log_average_large_unit'              => (($rowData[0][5]  == NULL ? 0 : $rowData[0][5]) * ($rowData[0][2]  == NULL ? 0 : $rowData[0][2])),
				// 'log_average_medium_unit'             => ($rowData[0][5]  == '-'? 0 : $rowData[0][5]),
				// 'log_average_small_unit'              => ($rowData[0][6]  == '-' ? 0 : $rowData[0][6]),
				'timestamp'                           => $dtstamp
			];
    }

			

		if ($insert) {
			$save_detail = $this->Penerimaan_model->save_detail($detail_data, true);
			$save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);
            $save_log = $this->Logs_model->save($log_data, true);
		}

		unlink($inputFileName);

		$msg = '';
		if ($save_detail) {
			$msg = true;
			$this->session->set_userdata('msg_unit', $msg);
		}

		redirect('adm/imports/');
	}
	
    public function import_penjualan()
	{
		$fileName_before = $_FILES['item_file_name']['name'];
		$fileName        = str_replace(" ", "_", $fileName_before);

		$path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';
        
         $upload_image = $_FILES['item_file_name']['name'];

        if ($upload_image) {
            $config['allowed_types'] = '*';
            $config['max_size']      = '4048'; //dalam kilo bite(kb)
            $config['upload_path']   = './assets/excels/upload_file/';

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('item_file_name')) {
                 $this->upload->data('item_file_name');
            } else {

                echo $this->upload->display_errors();
            }
        }
// 		if (!empty($_FILES['item_file_name']['name'])) {
// 			upload_file($path, $item_file_name, null, $allowedTypes);
// 		}

		$inputFileName = $path . $fileName;

		try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader     = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel   = $objReader->load($inputFileName);
		} catch (Exception $e) {
			die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
		}

		$sheet         = $objPHPExcel->getSheet(0);
		$highestRow    = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		$number_tr = "TES";
		$header_id = 0;

// 		$number_generator = $this->Sales_model->sales_number();
		$no = 0;
		$insert = false;
		$save_detail = false;
		for ($row = 2; $row <= $highestRow; $row++) {                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);


			if ($number_tr != $rowData[0][1]) {
			    $prefix  = "J";
        		$datenow = date('Ym');
        		$year = date('y');
        		$month = date('m');
        		echo change_format_date((isset($rowData[0][0]) == NULL ? 0 : $rowData[0][0]));
        		echo strtolower($rowData[0][3]);
        		echo ($rowData[0][13]);
        		$number_generator = $this->Sales_orders_model->salesorder_autonumber();
        		$autonumber = $prefix . $year .$month.'-'. $number_generator;
                // $customer_name = strtolower(($rowData[0][3]));
                $raw_name = trim($rowData[0][3]);
                $words = explode(' ', $raw_name);
                $first_two = array_slice($words, 0, 2);
                $customer_name = strtolower(implode(' ', $first_two));
                
                $this->db->where("LOWER(TRIM(customer_name)) LIKE", '%' . $customer_name . '%');
                $query = $this->db->get('master_customers');
                $customer = $query->row();

                
        		$data = [
        			'sales_order_header_number'          => $autonumber,
        			'sales_order_header_date'            => change_format_date((isset($rowData[0][0]) == NULL ? 0 : $rowData[0][0])),
        			'sales_order_header_customer_id'     => $customer->customer_id,
        			'sales_order_header_payment_method'  => "Tunai",
        			'sales_order_header_payment_term'    => 0,
        			'sales_order_header_payment_due'     => "0000-00-00",
        			'sales_order_header_grand_total'     => trims((isset($rowData[0][9]) == NULL ? 0 : $rowData[0][9])),
        			'sales_order_header_ongkos'          => trims(0),
        			'sales_order_header_ppn_total'       => trims(0),
        			'sales_order_header_paid_total'      => trims((isset($rowData[0][9]) == NULL ? 0 : $rowData[0][9])),
        			'sales_order_header_change_total'    => trims(0),
        			'sales_order_header_remaining_total' => trims(0),
        			'sales_order_header_description'     => '',
        			'sales_order_header_user_id'         => 14,
        			'sales_order_header_sales_id'        => 6,
        			'status_paid'                        => 1,
        			'is_hold'                            => 0,
        			'printed_date'                       => change_format_date((isset($rowData[0][0]) == NULL ? 0 : $rowData[0][0])),
        			'ppn_amount'                         => 11.0
        		];

				$insert = $this->db->insert("sales_order_headers", $data);
				$header_id = $this->db->insert_id();

				$number_tr = $rowData[0][1];
			}

			$where_item_id    = array("item_id" => (isset($rowData[0][13]) == NULL ? 0 : $rowData[0][13]));
			
			$get_data_item = $this->Items_model->get_data($where_item_id)->row();
			$detail_data = [
					'sales_order_detail_header_id'            => $header_id,
					'sales_order_detail_item_id'              =>$get_data_item->item_id,
					'sales_order_detail_item_name'            => (isset($rowData[0][5]) == NULL ? 0 : $rowData[0][5]),
					'sales_order_detail_warehouse_id'            => 5,
					'sales_order_detail_large_unit'           => $get_data_item->large_unit,
					'sales_order_detail_large_unit_quantity'  => trims((isset($rowData[0][7]) == NULL ? 0 : $rowData[0][7])),
					'sales_order_detail_large_unit_price'     => trims((isset($rowData[0][8]) == NULL ? 0 : (int)$rowData[0][8])),
					'sales_order_detail_result_large'         => trims((isset($rowData[0][8]) == NULL ? 0 : (int)$rowData[0][8] * (int)$rowData[0][7])),
					'sales_order_detail_medium_unit'          => "",
					'sales_order_detail_medium_unit_quantity' => trims(0),
					'sales_order_detail_medium_unit_price'    => trims(0),
					'sales_order_detail_result_medium'        => trims(0),
					'sales_order_detail_small_unit'           => "",
					'sales_order_detail_small_unit_quantity'  => trims(0),
					'sales_order_detail_small_unit_price'     => trims(0),
					'sales_order_detail_result_small'         => trims(0),
					'sales_order_detail_ppn_status'           => 1,
					'sales_order_detail_ppn_total'            => trims(0),
					'sales_order_detail_total'                => trims((isset($rowData[0][8]) == NULL ? 0 : (int)$rowData[0][8] * (int)$rowData[0][7])),
					'sales_order_detail_large_unit_discount'  => trims(0),
					'sales_order_detail_medium_unit_discount' => trims(0),
					'sales_order_detail_small_unit_discount'  => trims(0),
					
					'sales_order_detail_discount_percentage'  => trims(0),
                    'sales_order_detail_discount_total'    => trims(0),
				];
				
					$dtstamp                    = change_format_date((isset($rowData[0][0]) == NULL ? 0 : $rowData[0][0])). " " .date("H:i:s");
								$where                      = array('log_item_id' => $get_data_item->item_id, 'a.timestamp <' => $dtstamp);
								$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
								$last_total_stock           = 0;
								$last_log_total_stock_value = 0;
								$last_log_avg_large         = 0;
								$last_log_avg_medium        = 0;
								$last_log_avg_small         = 0;
		
								if(!empty($log_data_check)){
									$last_total_stock           = $log_data_check['log_total_stock'];
									$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
									$last_log_avg_large         = $log_data_check['log_average_large_unit'];
									$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
									$last_log_avg_small         = $log_data_check['log_average_small_unit'];
								}
		
								$medium_purchase_price = (0 == 0 ? 0 : ($last_log_avg_medium));
								$small_purchase_price  = (0 == 0 ? 0 : ($last_log_avg_small));
		
								$log_total_transaction_in_small_unit = ($get_data_item->large_unit_contain * (- trims((isset($rowData[0][7]) == NULL ? 0 : $rowData[0][7]))) + (0 * (- 0))) + (0 * (- trims(0)));
								$log_total_transaction_value = ((- trims((isset($rowData[0][7]) == NULL ? 0 : $rowData[0][7]))) * $last_log_avg_large) + ((- 0) * $medium_purchase_price) + ((- trims(0)) * $small_purchase_price);
								$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
								$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
								$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
								$log_average_medium_unit     = ($log_average_small_unit * 0);
								$log_average_large_unit      = ($log_average_small_unit * $get_data_item->large_unit_contain);
		
								$log_data = [
									'log_type'                            => 'SELL',
									'log_transaction_id'                  => $header_id,
									'log_item_id'                         => $get_data_item->item_id,
									'log_large_unit'                      => $get_data_item->large_unit,
									'log_large_unit_contain'              => $get_data_item->large_unit_contain,
									'log_large_unit_quantity'             => (- trims((isset($rowData[0][7]) == NULL ? 0 : $rowData[0][7]))),
									'log_large_unit_purchase_price'       => $last_log_avg_large,
									'log_large_unit_selling_price'        => trims((isset($rowData[0][8]) == NULL ? 0 : (int)$rowData[0][8])),
									'log_medium_unit'                     => "",
									'log_medium_unit_contain'             => 0,
									'log_medium_unit_quantity'            => (- 0),
									'log_medium_unit_purchase_price'      => $medium_purchase_price,
									'log_medium_unit_selling_price'       => trims(0),
									'log_small_unit'                      => "",
									'log_small_unit_contain'              => 0,
									'log_small_unit_quantity'             => (- trims(0)),
									'log_small_unit_purchase_price'       => $small_purchase_price,
									'log_small_unit_selling_price'        => trims(0),
									'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
									'log_total_transaction_value'         => $log_total_transaction_value,
									'log_total_stock'                     => $log_total_stock,
									'log_total_stock_value'               => $log_total_stock_value,
									'log_average_large_unit'              => $log_average_large_unit,
									'log_average_medium_unit'             => $log_average_medium_unit,
									'log_average_small_unit'              => $log_average_small_unit,
									'timestamp'                           => $dtstamp
								];
									$save_detail = $this->Sales_orders_model->save_detail($detail_data);
			                    $save_log = $this->Logs_model->save($log_data);
		}

		if ($insert) {
		
		}

		unlink($inputFileName);

		$msg = '';
		if ($save_detail) {
			$msg = true;
			$this->session->set_userdata('msg_unit', $msg);
		}

// 		redirect('adm/imports/');
	}

	public function import_units() {
		$fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

			$where = array("unit_name" => $rowData[0][0]);
			$exist = $this->Units_model->get_data($where)->row();

			if($exist == null){
				$data = [
					"unit_name" => $rowData[0][0],
					"unit_priority" => $rowData[0][1],
				];
				$insert = $this->db->insert("master_units", $data);
			}
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_unit', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_groups() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet         = $objPHPExcel->getSheet(0);
		$highestRow    = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

			// Start Save Group
			$where = array("group_name" => $rowData[0][0]);
			$exist = $this->Groups_model->get_data($where)->row();

			if($exist == null){
				$data = [
					"group_name" => $rowData[0][0],
				// 	"group_order" => $rowData[0][2]
				];
				$insert = $this->db->insert("master_groups", $data);
			}
			// End

			//Start Save Sub Group
// 			$group_name = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
// 			$group_id   = 0;
// 			if($group_name != ""){
// 				$where_group    = array("group_name" => $group_name);
// 				$get_data_group = $this->Groups_model->get_data($where_group)->row();
// 				if($get_data_group){
// 					$group_id = $get_data_group->group_id;
// 				}
// 			}

// 			$where_2 = array("group_child_name" => $rowData[0][0], "a.group_id" => $group_id);
// 			$exist_2 = $this->Groups_model->get_data_child($where_2)->row();

// 			if($exist_2 == null){
// 				$data_2 = [
// 					"group_child_name" => $rowData[0][0],
// 					"group_id"         => $group_id
// 				];
// 				$insert_2 = $this->db->insert("master_group_childs", $data_2);
// 			}
			// End
		}

		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_group', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_group_customers() {
		$fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

			$where = array("group_customer_name" => $rowData[0][0]);
			$exist = $this->Group_customers_model->get_data($where)->row();

			if($exist == null){
				$data = [
					"group_customer_name" => $rowData[0][0]
				];
				$insert = $this->db->insert("master_group_customers", $data);
			}
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_group_customer', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_items() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		$prefix           = "STO";
		$datenow          = date('Ym');
		$number_generator = $this->Stocks_model->stock_autonumber();
		$autonumber       = $prefix.$datenow.$number_generator;

		$header_data = [
			'stock_header_number'         => $autonumber,
			'stock_header_date'           => date_now(),
			'stock_header_payment_due'    => date_now(),
			'stock_header_supplier_id'    => 0,
			'stock_header_sub_total'      => 0,
			'stock_header_ppn_id'         => 0,
			'stock_header_ppn_percentage' => 0,
			'stock_header_ppn_total'      => 0,
			'stock_header_grand_total'    => 0,
			'stock_header_description'    => '',
		];

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("item_name" => $rowData[0][0]);
				$exist = $this->Items_model->get_data($where)->row();

				if($exist == null){

					// Sesuaikan key array dengan nama kolom di database
					$group_name       = ($rowData[0][7]  == NULL ? "" : $rowData[0][7]);
				// 	$group_child_name = ($rowData[0][2]  == NULL ? "" : $rowData[0][2]);
					if($group_name != ""){
						$where_group    = array("group_name" => $group_name);
						$get_data_group = $this->Groups_model->get_data($where_group)->row();
						if($get_data_group){
							$group_name = $get_data_group->group_id;
						}
					}

				// 	if($group_child_name != ""){
				// 		$where_group_child    = array("group_child_name" => $group_child_name);
				// 		$get_data_group_child = $this->Groups_model->get_data_child($where_group_child)->row();
				// 		if($get_data_group_child){
				// 			$group_child_name = $get_data_group_child->group_child_id;
				// 		}
				// 	}


					$data = [
						"item_code"                       =>($rowData[0][0]  == NULL ? "" : $rowData[0][0]),
						"item_name"                       => ($rowData[0][1]  == NULL ? "" : $rowData[0][1]),
						"item_group_id"                   => 46,
				// 		"item_group_child_id"             => $group_child_name,
						"large_unit"                      => ($rowData[0][2]  == NULL ? "" : $rowData[0][2]),
						"large_unit_contain"              => ($rowData[0][3]  == NULL ? "" : $rowData[0][3]),
				// 		"medium_unit"                     => ($rowData[0][3]  == NULL ? "" : $rowData[0][3]),
				// 		"medium_unit_contain"             => ($rowData[0][9]  == NULL ? 0 : $rowData[0][9]),
				// 		"small_unit"                      => ($rowData[0][7]  == NULL ? "" : $rowData[0][7]),
				// 		"small_unit_contain"              => ($rowData[0][8]  == NULL ? 0 : $rowData[0][8]),
						"last_purchase_price_large_unit"  => ($rowData[0][4]  == NULL ? 0 : $rowData[0][4]),
				// 		"last_purchase_price_medium_unit" => ($rowData[0][5] == NULL ? 0 : $rowData[0][5]),
				// 		"last_purchase_price_small_unit"  => ($rowData[0][11] == NULL ? 0 : $rowData[0][11]),
						"last_selling_price_large_unit"   => ($rowData[0][5] == NULL ? 0 : $rowData[0][5]),
				// 		"last_selling_price_medium_unit"  => ($rowData[0][7] == NULL ? 0 : $rowData[0][7]),
				// 		"last_selling_price_small_unit"   => ($rowData[0][14] == NULL ? 0 : $rowData[0][14]),
				// 		"minimum_stock"                   => ($rowData[0][15] == NULL ? 0 : $rowData[0][15]),
				// 		"ppn_status"                      => ($rowData[0][16] == NULL ? 0 : $rowData[0][16]),
				// 		"img_filename"                    => ($rowData[0][17] == NULL ? "default.jpg" : $rowData[0][17])
					];
					$insert = $this->db->insert("master_items", $data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	
	public function import_update_items() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		$prefix           = "STO";
		$datenow          = date('Ym');
		$number_generator = $this->Stocks_model->stock_autonumber();
		$autonumber       = $prefix.$datenow.$number_generator;

		$header_data = [
			'stock_header_number'         => $autonumber,
			'stock_header_date'           => date_now(),
			'stock_header_payment_due'    => date_now(),
			'stock_header_supplier_id'    => 0,
			'stock_header_sub_total'      => 0,
			'stock_header_ppn_id'         => 0,
			'stock_header_ppn_percentage' => 0,
			'stock_header_ppn_total'      => 0,
			'stock_header_grand_total'    => 0,
			'stock_header_description'    => '',
		];

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("item_id" => $rowData[0][0]);
				$exist = $this->Items_model->get_data($where)->row();

				if($exist){

					// Sesuaikan key array dengan nama kolom di database
				// 	$group_name       = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
				// 	$group_child_name = ($rowData[0][2]  == NULL ? "" : $rowData[0][2]);
				// 	if($group_name != ""){
				// 		$where_group    = array("group_name" => $group_name);
				// 		$get_data_group = $this->Groups_model->get_data($where_group)->row();
				// 		if($get_data_group){
				// 			$group_name = $get_data_group->group_id;
				// 		}
				// 	}

				// 	if($group_child_name != ""){
				// 		$where_group_child    = array("group_child_name" => $group_child_name);
				// 		$get_data_group_child = $this->Groups_model->get_data_child($where_group_child)->row();
				// 		if($get_data_group_child){
				// 			$group_child_name = $get_data_group_child->group_child_id;
				// 		}
				// 	}


					$data = [
				// 		"item_name"                       => $rowData[0][0],
				// 		"item_group_id"                   => $group_name,
				// 		"item_group_child_id"             => $group_child_name,
				// 		"large_unit"                      => ($rowData[0][3]  == NULL ? "" : $rowData[0][3]),
				// 		"large_unit_contain"              => ($rowData[0][4]  == NULL ? 0 : $rowData[0][4]),
				// 		"medium_unit"                     => ($rowData[0][5]  == NULL ? "" : $rowData[0][5]),
				// 		"medium_unit_contain"             => ($rowData[0][6]  == NULL ? 0 : $rowData[0][6]),
				// 		"small_unit"                      => ($rowData[0][7]  == NULL ? "" : $rowData[0][7]),
				// 		"small_unit_contain"              => ($rowData[0][8]  == NULL ? 0 : $rowData[0][8]),
						"last_purchase_price_large_unit"  => ($rowData[0][3]  == NULL ? 0 : $rowData[0][3]),
				// 		"last_purchase_price_medium_unit" => ($rowData[0][10] == NULL ? 0 : $rowData[0][10]),
				// 		"last_purchase_price_small_unit"  => ($rowData[0][11] == NULL ? 0 : $rowData[0][11]),
						"last_selling_price_large_unit"   => ($rowData[0][4] == NULL ? 0 : $rowData[0][4]),
				// 		"last_selling_price_medium_unit"  => ($rowData[0][13] == NULL ? 0 : $rowData[0][13]),
				// 		"last_selling_price_small_unit"   => ($rowData[0][14] == NULL ? 0 : $rowData[0][14]),
				// 		"minimum_stock"                   => ($rowData[0][15] == NULL ? 0 : $rowData[0][15]),
				// 		"ppn_status"                      => ($rowData[0][16] == NULL ? 0 : $rowData[0][16]),
				// 		"img_filename"                    => ($rowData[0][17] == NULL ? "default.jpg" : $rowData[0][17])
					];
					$insert = $this->Items_model->update($exist->item_id,$data);
				// 	$insert = $this->db->insert("master_items", $data);update

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	
	public function import_image_items() {
		if(!empty($_FILES['image_name']['name'])){
	    	$ImageCount = count($_FILES['image_name']['name']);

	        for($i = 0; $i < $ImageCount; $i++){
	            $_FILES['file']['name']       = $_FILES['image_name']['name'][$i];
	            $_FILES['file']['type']       = $_FILES['image_name']['type'][$i];
	            $_FILES['file']['tmp_name']   = $_FILES['image_name']['tmp_name'][$i];
	            $_FILES['file']['error']      = $_FILES['image_name']['error'][$i];
	            $_FILES['file']['size']       = $_FILES['image_name']['size'][$i];

	            // File upload configuration
	            $uploadPath = './assets/images/upload_file/items/';
	            $config['upload_path'] = $uploadPath;
	            $config['allowed_types'] = 'jpg|jpeg|png';

	            // Load and initialize upload library
	            $this->load->library('upload', $config);
	            $this->upload->initialize($config);

	            // Upload file to server
	            if($this->upload->do_upload('file')){
	                $imageData = $this->upload->data();
	                $uploadImgData[$i]['image_name'] = $imageData['file_name'];
	            }
			}
			
			$msg2 = true;
			$this->session->set_userdata('msg_img_item', $msg2);

        	redirect('adm/imports/');
		}
	}

	public function import_wholesale_prices() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				// Sesuaikan key array dengan nama kolom di database
				$item_name = ($rowData[0][0]  == NULL ? "" : $rowData[0][0]);
				$item_id    = 0;
				if($item_name != ""){
					$where    = array("item_name" => $item_name);
					$get_data = $this->Items_model->get_data($where)->row();
					if($get_data){
						$item_id = $get_data->item_id;
					}
				}
				
				$data = array(
					"item_id"       => $item_id,
					"minimum_order" => $rowData[0][1],
					"maximum_order" => $rowData[0][2],
					"price"         => $rowData[0][3],
					"is_active"     => 1,
				);

			$insert = $this->db->insert("master_wholesale_prices", $data);
			unlink($inputFileName);
					
		}

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_wholesale', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_suppliers() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

			$where = array("supplier_code" => $rowData[0][0]);
			$exist = $this->Suppliers_model->get_data($where)->row();

			if($exist == null){
				$data = [
				// 	"supplier_code"         => $rowData[0][0],
					"supplier_name"         => $rowData[0][0],
				// 	"supplier_telephone"    => $rowData[0][2],
				// 	"supplier_address"      => $rowData[0][3],
				// 	"supplier_payment_term" => $rowData[0][4]
				];
				$insert = $this->db->insert("master_suppliers", $data);
			}
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_supplier', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_customers() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);

			$group_customer       = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
			if($group_customer != ""){
				$where_group    = array("group_customer_name" => $group_customer);
				$get_data_group = $this->Group_customers_model->get_data($where_group)->row();
				if($get_data_group){
					$group_customer = $get_data_group->group_customer_id;
				}
			}

			if($this->isEmptyRow(reset($rowData))) { continue; }

			$data = [
				"customer_name"         => ($rowData[0][0]  == NULL ? "" : $rowData[0][0]),
				// "group_customer_id"     => $group_customer,
				"customer_ktp"          => ($rowData[0][1]  == NULL ? "" : $rowData[0][1]),
				"customer_npwp"         => ($rowData[0][5]  == NULL ? "" : $rowData[0][5]),
				"customer_telephone"    => ($rowData[0][4]  == NULL ? "" : $rowData[0][4]),
				"customer_address"      => ($rowData[0][2]  == NULL ? "" : $rowData[0][2]),
				"customer_address2"      => ($rowData[0][3]  == NULL ? "" : $rowData[0][3]),
				// "customer_payment_term" => $rowData[0][6],
				// "customer_username"     => $rowData[0][7],
				"customer_alamat_npwp"     => ($rowData[0][3]  == NULL ? "" : $rowData[0][3]),
				"customer_nama_npwp"          => ($rowData[0][5]  == NULL ? "" : $rowData[0][5])
			];
			$insert = $this->db->insert("master_customers", $data);
// 			$insert = $this->db->insert("master_customers", $data);
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_customer', $msg);
		}
		
        redirect('adm/imports/');
	}
	
	public function import_update_customers() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();


		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("customer_id" => $rowData[0][0]);
				$exist = $this->Customers_model->get_data($where)->row();

				if($exist){



					$data = [

						"customer_npwp"         => ($rowData[0][2]  == NULL ? "" : $rowData[0][2]),
                        "customer_alamat_npwp"     => ($rowData[0][3]  == NULL ? "" : $rowData[0][3]),
                        "customer_nama_npwp"          => ($rowData[0][4]  == NULL ? "" : $rowData[0][4])

					];
					$insert = $this->Customers_model->update($exist->customer_id,$data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}

	function isEmptyRow($row) {
		foreach($row as $cell){
			if (null !== $cell) return false;
		}
		return true;
	}

	public function import_special_prices() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				// Sesuaikan key array dengan nama kolom di database
				$customer_name = ($rowData[0][0]  == NULL ? "" : $rowData[0][0]);
				$customer_id    = 0;
				if($customer_name != ""){
					$where    = array("customer_name" => $customer_name);
					$get_data = $this->Customers_model->get_data($where)->row();
					if($get_data){
						$customer_id = $get_data->customer_id;
					}
				}

				$item_name = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
				$item_id    = 0;
				if($item_name != ""){
					$where    = array("item_name" => $item_name);
					$get_data = $this->Items_model->get_data($where)->row();
					if($get_data){
						$item_id = $get_data->item_id;
					}
				}
				
				$data = array(
					"customer_id" => $customer_id,
					"item_id"     => $item_id,
					"large_unit"  => $rowData[0][2],
					"price"       => $rowData[0][3],
					"is_active"   => 1,
				);

			$insert = $this->db->insert("master_special_prices", $data);
			unlink($inputFileName);
					
		}

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_special', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function import_group_prices() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				// Sesuaikan key array dengan nama kolom di database
				$group_customer_name = ($rowData[0][0]  == NULL ? "" : $rowData[0][0]);
				$group_customer_id    = 0;
				if($group_customer_name != ""){
					$where    = array("group_customer_name" => $group_customer_name);
					$get_data = $this->Group_customers_model->get_data($where)->row();
					if($get_data){
						$group_customer_id = $get_data->group_customer_id;
					}
				}

				$item_name = ($rowData[0][1]  == NULL ? "" : $rowData[0][1]);
				$item_id    = 0;
				if($item_name != ""){
					$where    = array("item_name" => $item_name);
					$get_data = $this->Items_model->get_data($where)->row();
					if($get_data){
						$item_id = $get_data->item_id;
					}
				}
				
				$data = array(
					"group_customer_id" => $group_customer_id,
					"item_id"     => $item_id,
					"price"       => $rowData[0][2],
					"is_active"   => 1,
				);

			$insert = $this->db->insert("master_group_prices", $data);
			unlink($inputFileName);
					
		}

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_group_price', $msg);
		}
		
        redirect('adm/imports/');
	}

	public function export_units() {
		
		$get_data = $this->Units_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("SATUAN")
							   ->setSubject("SATUAN")
							   ->setDescription("SATUAN")
							   ->setKeywords("SATUAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA SATUAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "URUTAN");
	    $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->unit_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->unit_priority);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("SATUAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel

		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'SATUAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_groups() {
		
		$get_data = $this->Groups_model->get_data_child()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("GRUP")
							   ->setSubject("GRUP")
							   ->setDescription("GRUP")
							   ->setKeywords("GRUP");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA SUB GRUP");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "NAMA GRUP");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "ORDER GRUP");
	    $excel->getActiveSheet()->getStyle('A1:C1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->group_child_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->group_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->group_order);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("GRUP");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'GRUP_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_group_customers() {
		
		$get_data = $this->Group_customers_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("GRUP PELANGGAN")
							   ->setSubject("GRUP PELANGGAN")
							   ->setDescription("GRUP PELANGGAN")
							   ->setKeywords("GRUP PELANGGAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA GRUP PELANGGAN");
	    $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->group_customer_name);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("GRUP PELANGGAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'GRUP_PELANGGAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_items() {
		
		$get_data = $this->Items_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("BARANG")
							   ->setSubject("BARANG")
							   ->setDescription("BARANG")
							   ->setKeywords("BARANG");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA BARANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "GRUP");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "SUB GRUP");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "SATUAN BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('E1', "ISI BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('F1', "SATUAN SEDANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('G1', "ISI SEDANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('H1', "SATUAN KECIL");
	    $excel->setActiveSheetIndex(0)->setCellValue('I1', "ISI KECIL");
	    $excel->setActiveSheetIndex(0)->setCellValue('J1', "HARGA BELI BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('K1', "HARGA BELI SEDANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('L1', "HARGA BELI KECIL");
	    $excel->setActiveSheetIndex(0)->setCellValue('M1', "HARGA JUAL BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('N1', "HARGA JUAL SEDANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('O1', "HARGA JUAL KECIL");
	    $excel->setActiveSheetIndex(0)->setCellValue('P1', "MINIMUM STOK");
	    $excel->setActiveSheetIndex(0)->setCellValue('Q1', "STATUS PPN");
	    $excel->setActiveSheetIndex(0)->setCellValue('R1', "NAMA FILE GAMBAR");
	    $excel->getActiveSheet()->getStyle('A1:R1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->group_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->group_child_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->large_unit_contain);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $get_row->medium_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $get_row->medium_unit_contain);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $get_row->small_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $get_row->small_unit_contain);
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $get_row->last_purchase_price_large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, $get_row->last_purchase_price_medium_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, $get_row->last_purchase_price_small_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, $get_row->last_selling_price_large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, $get_row->last_selling_price_medium_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, $get_row->last_selling_price_small_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('P'.$numrow, $get_row->minimum_stock);
			$excel->setActiveSheetIndex(0)->setCellValue('Q'.$numrow, $get_row->ppn_status);
			$excel->setActiveSheetIndex(0)->setCellValue('R'.$numrow, $get_row->img_filename);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("BARANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'BARANG_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_wholesale_prices() {
		
		$get_data = $this->Wholesale_prices_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("HARGA GROSIR")
							   ->setSubject("HARGA GROSIR")
							   ->setDescription("HARGA GROSIR")
							   ->setKeywords("HARGA GROSIR");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA BARANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "MINIMUM ORDER");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "MAKSIMAL ORDER");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "HARGA");
	    $excel->getActiveSheet()->getStyle('A1:D1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->minimum_order);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->maximum_order);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->price);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HARGA GROSIR");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'HARGA_GROSIR_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_suppliers() {
		
		$get_data = $this->Suppliers_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("SUPPLIER")
							   ->setSubject("SUPPLIER")
							   ->setDescription("SUPPLIER")
							   ->setKeywords("SUPPLIER");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "KODE");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "NAMA SUPPLIER");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "TELEPON");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "ALAMAT");
	    $excel->setActiveSheetIndex(0)->setCellValue('E1', "JANGKA WAKTU PEMBAYARAN");
	    $excel->getActiveSheet()->getStyle('A1:E1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->supplier_code);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->supplier_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->supplier_telephone);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->supplier_address);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->supplier_payment_term);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("SUPPLIER");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'SUPPLIER_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_customers() {
		
		$get_data = $this->Customers_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PELANGGAN")
							   ->setSubject("PELANGGAN")
							   ->setDescription("PELANGGAN")
							   ->setKeywords("PELANGGAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA PELANGGAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "GRUP PELANGGAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "KTP");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "NPWP");
	    $excel->setActiveSheetIndex(0)->setCellValue('E1', "TELEPON");
	    $excel->setActiveSheetIndex(0)->setCellValue('F1', "ALAMAT");
	    $excel->setActiveSheetIndex(0)->setCellValue('G1', "JANGKA WAKTU PEMBAYARAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('H1', "USERNAME");
	    $excel->setActiveSheetIndex(0)->setCellValue('I1', "PASSWORD");
	    $excel->setActiveSheetIndex(0)->setCellValue('J1', "PIN");
	    $excel->getActiveSheet()->getStyle('A1:J1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->group_customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->customer_ktp);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->customer_npwp);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->customer_telephone);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $get_row->customer_address);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $get_row->customer_payment_term);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $get_row->customer_username);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $get_row->customer_password);
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $get_row->customer_pin);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PELANGGAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PELANGGAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_special_prices() {
		
		$get_data = $this->Special_prices_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("HARGA PELANGGAN")
							   ->setSubject("HARGA PELANGGAN")
							   ->setDescription("HARGA PELANGGAN")
							   ->setKeywords("HARGA PELANGGAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA PELANGGAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "NAMA BARANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "SATUAN BESAR");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "HARGA");
	    $excel->getActiveSheet()->getStyle('A1:D1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->price);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HARGA PELANGGAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'HARGA_PELANGGAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_group_prices() {
		
		$get_data = $this->Group_prices_model->get_data_group_price()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("HARGA GRUP PELANGGAN")
							   ->setSubject("HARGA GRUP PELANGGAN")
							   ->setDescription("HARGA GRUP PELANGGAN")
							   ->setKeywords("HARGA GRUP PELANGGAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "NAMA GRUP PELANGGAN");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "NAMA BARANG");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "HARGA");
	    $excel->getActiveSheet()->getStyle('A1:C1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->group_customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->price);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HARGA GRUP PELANGGAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'HARGA_GRUP_PELANGGAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
