<?php

/**
 * Purchase Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Penerimaan extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Penerimaan_model');
		$this->load->model('Purchase_orders_model');
		$this->load->model('Configuration_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Items_model');
		$this->load->model('Logs_model');
		$this->load->model('Ppn_model');
		$this->load->model('Groups_model');
		$this->load->model('Units_model');
		
		$this->load->model('Accounts_model');
		$this->load->model('Transfer_model');
		$this->load->model('Journals_model');
		$this->load->model('Warehouses_model');
		
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Penerimaan';

		$this->twiggy_display('adm/penerimaan/index', $data);
	}

	public function get_data_header()
	{
		$data = [];
		// $order = "penerimaan_header_date DESC, penerimaan_header_number DESC";
		$order = "a.timestamp DESC";
		$get_data = $this->Penerimaan_model->purchaseorder_header('', $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
			    $description = $get_row->penerimaan_header_description;
			    $get_data_purchase = $this->Purchase_orders_model->purchaseorder_header(array('purchase_order_header_id' => $get_row->penerimaan_header_purchase_id))->row();
			    if($get_data_purchase){
			        $description = $get_data_purchase->purchase_order_header_description;
			    }
				$data[] = array(
					'no'     => $no,
					'id'     => $get_row->penerimaan_header_id,
					'number' => $get_row->penerimaan_header_number,
					'date'   => indonesian_date($get_row->penerimaan_header_date),
					'customer'    => $get_row->supplier_name,
					'grand_total' => number_format($get_row->penerimaan_header_grand_total),
					'description' => $description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function get_autonumber()
	{
		$id      = $this->input->post('id');
		$datenow = date('ym');
		$number_generator = '';
		$where   = array('supplier_id' => $id);
		$customer_data  = $this->Suppliers_model->get_data($where)->row();

		if ($customer_data) {
			$number_generator = $this->Penerimaan_model->purchaseorder_autonumber();
		}

		$prefix     = 'PI';
		$autonumber = $prefix . $datenow . '-' . $number_generator;

		$response = [
			'autonumber'  => $autonumber,
			
		];

		echo json_encode($response);
	}


	public function edit($id = 'new')
	{
		$title       = "Tambah Penerimaan";
		$header_data = array(null);
		$purchase_data = array();
		$ppn_amount  = 0;
		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));
		// $prefix  = "SO100";
		// $datenow = date('Ym');
		// $number_generator = $this->Penerimaan_model->purchaseorder_autonumber();
		// $autonumber = $prefix.$datenow.'-'.$number_generator;
		$autonumber = '';

		$date_text = date_now();
		$tmstamp   = date("H:i:s");
		$purchase_header_data = $this->Purchase_orders_model->purchaseorder_header()->result();

		if ($id != 'new') {
			$title       = "Edit Penerimaan";
			$where       = array('penerimaan_header_id' => $id);
			$header_data = $this->Penerimaan_model->purchaseorder_header($where)->row_array();
			$autonumber  = $header_data['penerimaan_header_number'];
			$date_text   = $header_data['penerimaan_header_date'];
			$ppn_amount   = $header_data['penerimaan_header_ppn_percentage'];
			$tmstamp     = time24($header_data['tmstamp_po']);
			$purchase_data = $this->Purchase_orders_model->purchaseorder_header(array('purchase_order_header_id' => $header_data['penerimaan_header_purchase_id']))->result();
		}
// 		 $get_data = $this->Purchase_orders_model->purchaseorder_header()->result();
        foreach($purchase_header_data as $row){
            $terima = 0;
            $order = 0;
            $where       = array('penerimaan_header_purchase_id' => $row->purchase_order_header_id);
            $get_data_detail = $this->Penerimaan_model->purchaseorder_detail_advance($where)->result();
            $get_data_detail_po = $this->Purchase_orders_model->purchaseorder_detail_advance(array('purchase_order_detail_header_id' => $row->purchase_order_header_id))->result();
            foreach($get_data_detail_po as $detail_po){
                $order += $detail_po->purchase_order_detail_large_unit_quantity +  $detail_po->purchase_order_detail_medium_unit_quantity;
            }
            if($get_data_detail){
                 foreach($get_data_detail as $detail){
                $terima += $detail->penerimaan_detail_large_unit_quantity + $detail->penerimaan_detail_medium_unit_quantity;
                
                }
                if($terima != $order){
                    $purchase_data[] = [
                        'purchase_order_header_id' => $row->purchase_order_header_id,
                        'purchase_order_header_number' => $row->purchase_order_header_number,
                        'terima' => $terima,
                        'order' => $order,
                    ];
                }
            }else{
                $purchase_data[] = [
                        'purchase_order_header_id' => $row->purchase_order_header_id,
                        'purchase_order_header_number' => $row->purchase_order_header_number
                    ];
            }
           
        }
        
		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['suppliers_data'] = $this->Suppliers_model->get_data()->result();
		$data['purchase_data'] = $purchase_data;
// 		$data['salesman_data'] = $this->Salesman_model->get_data()->result();
		$data['warehouse_data'] = $this->Warehouses_model->get_data()->result();
		$data['ppn_amount']    = $ppn_amount;
 

		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;
		$data['tmstamp']    = $tmstamp;

		$this->twiggy_display('adm/penerimaan/edit', $data);
	}

	public function get_data_ppn()
	{
		$id = $this->input->post("id");

		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : $ppn_data->amount);

		if ($id != 'new') {
			$where       = array('penerimaan_header_id' => $id);
			$header_data = $this->Penerimaan_model->purchaseorder_header($where)->row_array();
			$ppn_amount   = $header_data['penerimaan_header_ppn_percentage'];
		}

		echo json_encode(to_decimal($ppn_amount));
	}
	
	public function get_purchase_detail()
	{
		$id = $this->input->post("id");
		$where       = array('purchase_order_detail_header_id' => $id);
		$order       = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Purchase_orders_model->purchaseorder_detail_advance($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
		    $data_supplier = 0;
		    $data_warehouse = 0;
			$no = 1;
			foreach ($get_data as $get_row) {
			    $where       = array('penerimaan_header_purchase_id' => $get_row->purchase_order_header_id,'penerimaan_detail_item_id' => $get_row->purchase_order_detail_item_id);
                $get_data_detail_penerimaan = $this->Penerimaan_model->purchaseorder_detail_advance($where)->result();
                $data_supplier = $get_row->supplier_id;
                $data_warehouse = $get_row->purchase_order_header_warehouse_id;
                $terima_besar = 0;
                $terima_sedang = 0;
                $terima_kecil = 0;
                if($get_data_detail_penerimaan){
                    foreach($get_data_detail_penerimaan as $row){
                        $terima_besar += $row->penerimaan_detail_large_unit_quantity;
                        $terima_sedang += $row->penerimaan_detail_medium_unit_quantity;
                        $terima_kecil += $row->penerimaan_detail_small_unit_quantity;
                    }
                    
                }
                $update_item = $this->Items_model->get_data(array('item_id' => $get_row->purchase_order_detail_item_id))->row();
                $item_id = $get_row->purchase_order_detail_item_id;
                if($update_item){
                    $item_id = $update_item->item_id;
                }
                if($get_row->purchase_order_detail_large_unit_quantity - $terima_besar != 0 || $get_row->purchase_order_detail_medium_unit_quantity - $terima_sedang != 0 || $get_row->purchase_order_detail_small_unit_quantity - $terima_kecil != 0){
                    $data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->purchase_order_detail_id,
					'detail_header_id' => $get_row->purchase_order_detail_header_id,
					'id'               => $item_id,
					'name'             => $get_row->purchase_order_detail_item_name,
				// 	'warehouse'             => $get_row->purchase_order_detail_warehouse_id,
				// 	'expired'             => $get_row->purchase_order_detail_expired,
					'lg_unit'          => $get_row->purchase_order_detail_large_unit,
					'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty_po'      => to_decimal($get_row->purchase_order_detail_large_unit_quantity - $terima_besar),
					'lg_unit_qty'      => to_decimal($get_row->purchase_order_detail_large_unit_quantity - $terima_besar),
					'lg_unit_qty_old'      => to_decimal($get_row->purchase_order_detail_large_unit_quantity),
					'lg_unit_prc'      => number_format($get_row->purchase_order_detail_large_unit_price),
					'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
					'result_large'     => $get_row->purchase_order_detail_result_large,
					'md_unit'          => $get_row->purchase_order_detail_medium_unit,
					'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty_po'      => to_decimal($get_row->purchase_order_detail_medium_unit_quantity - $terima_sedang),
					'md_unit_qty'      => to_decimal($get_row->purchase_order_detail_medium_unit_quantity - $terima_sedang),
					'md_unit_qty_old'      => to_decimal($get_row->purchase_order_detail_medium_unit_quantity),
					'md_unit_prc'      => number_format($get_row->purchase_order_detail_medium_unit_price),
					'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
					'result_medium'    => $get_row->purchase_order_detail_result_medium,
					'sm_unit'          => $get_row->purchase_order_detail_small_unit,
					'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty'      => to_decimal($get_row->purchase_order_detail_small_unit_quantity),
					'sm_unit_qty_po'      => to_decimal($get_row->purchase_order_detail_small_unit_quantity - $terima_kecil),
					'sm_unit_qty_old'      => to_decimal($get_row->purchase_order_detail_small_unit_quantity),
					'sm_unit_prc'      => number_format($get_row->purchase_order_detail_small_unit_price),
					'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
					'result_small'     => $get_row->purchase_order_detail_result_small,
					'discount'         => to_decimal($get_row->purchase_order_detail_discount_percentage),
					'discount_total'   => number_format($get_row->purchase_order_detail_discount_total),
				// 	'disc1'            => number_format($get_row->purchase_order_detail_disc1),
				// 	'disc2'            => number_format($get_row->purchase_order_detail_disc2),
				// 	'disc3'            => number_format($get_row->purchase_order_detail_disc3),
				// 	'subtotal'            => number_format($get_row->purchase_order_detail_subtotal),
					'total'            => number_format($get_row->purchase_order_detail_total),

					'overprice_lg' => 0,
					'overprice_md' => 0,
					'overprice_sm' => 0,
				);
				$no++;
                }
				
			}
		}
		
		$response = [
		    'data' => $data,
		    'supplier' => $data_supplier,
		    'warehouse' => $data_warehouse
		];

		output_json($response);
	}

	public function get_data_detail()
	{
		$id = $this->input->post("id");
		$where       = array('penerimaan_detail_header_id' => $id);
		$order       = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Penerimaan_model->purchaseorder_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
                // if($get_row->penerimaan_detail_large_unit_quantity != $get_row->purchase_detail_large_unit_quantity || $get_row->penerimaan_detail_medium_unit_quantity != $get_row->purchase_detail_medium_unit_quantity || $get_row->penerimaan_detail_small_unit_quantity != $get_row->purchase_detail_small_unit_quantity){
                    
                
				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->penerimaan_detail_id,
					'detail_header_id' => $get_row->penerimaan_detail_header_id,
					'id'               => $get_row->penerimaan_detail_item_id,
					'name'             => $get_row->penerimaan_detail_item_name,
					'warehouse'             => $get_row->penerimaan_detail_warehouse_id,
					'expired'             => $get_row->penerimaan_detail_expired,
					'lg_unit'          => $get_row->penerimaan_detail_large_unit,
					'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty_po'      => to_decimal($get_row->purchase_detail_large_unit_quantity),
				// 	'lg_unit_qty_po'      => 0,
					'lg_unit_qty'      => to_decimal($get_row->penerimaan_detail_large_unit_quantity),
					'lg_unit_qty_old'      => to_decimal($get_row->penerimaan_detail_large_unit_quantity),
					'lg_unit_prc'      => number_format($get_row->penerimaan_detail_large_unit_price),
					'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
					'result_large'     => $get_row->penerimaan_detail_result_large,
					'md_unit'          => $get_row->penerimaan_detail_medium_unit,
					'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty'      => to_decimal($get_row->penerimaan_detail_medium_unit_quantity),
				// 	'md_unit_qty_po'      => ($get_row->purchase_order_detail_medium_unit_quantity ? to_decimal($get_row->purchase_order_detail_medium_unit_quantity) : 0),
					'md_unit_qty_po'      => 0,
					'md_unit_qty_old'      => to_decimal($get_row->purchase_detail_medium_unit_quantity),
					'md_unit_prc'      => number_format($get_row->penerimaan_detail_medium_unit_price),
					'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
					'result_medium'    => $get_row->penerimaan_detail_result_medium,
					'sm_unit'          => $get_row->penerimaan_detail_small_unit,
					'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty'      => to_decimal($get_row->penerimaan_detail_small_unit_quantity),
				// 	'sm_unit_qty_po'      => ($get_row->purchase_detail_small_unit_quantity ? to_decimal($get_row->purchase_detail_small_unit_quantity) : 0),
					'sm_unit_qty_po'      => 0,
					'sm_unit_qty_old'      => to_decimal($get_row->penerimaan_detail_small_unit_quantity),
					'sm_unit_prc'      => number_format($get_row->penerimaan_detail_small_unit_price),
					'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
					'result_small'     => $get_row->penerimaan_detail_result_small,
					'discount'         => to_decimal($get_row->penerimaan_detail_discount_percentage),
					'discount_total'   => number_format($get_row->penerimaan_detail_discount_total),
					'subtotal'            => number_format($get_row->penerimaan_detail_subtotal),
					'total'            => number_format($get_row->penerimaan_detail_total),

					'overprice_lg' => 0,
					'overprice_md' => 0,
					'overprice_sm' => 0,
				);
                // }
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		
		$this->twiggy_display('adm/penerimaan/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		$get_data  = $this->Items_model->get_data_search($search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			$therest      = $get_row->stock_total;
			$total_large  = ($get_row->large_unit_contain == 0 ? '-' : floor($get_row->stock_total / $get_row->large_unit_contain));
			$therest      = ($get_row->large_unit_contain == 0 ? '-' : $therest - ($total_large * $get_row->large_unit_contain));
			$total_medium = ($get_row->medium_unit_contain == 0 ? '-' : floor($therest / $get_row->medium_unit_contain));
			$therest      = ($get_row->medium_unit_contain == 0 ? '-' : $therest - ($total_medium * $get_row->medium_unit_contain));
			$total_small  = ($get_row->small_unit_contain == 0 ? '-' : floor($therest / $get_row->small_unit_contain));
			$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'name'             => $get_row->item_name,
				'group_id'         => $get_row->group_id,
				'group_name'       => $get_row->group_name,
				'group_child_id'   => $get_row->group_child_id,
				'group_child_name' => $get_row->group_child_name,
				'lg_unit'          => $get_row->large_unit,
				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
				'lg_unit_qty_old'=> 0,
				'lg_unit_prc'      => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_selling_hpp_large_unit - $get_row->large_disc_harga) : 0),
				'lg_unit_prc_hpp'      => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_selling_hpp_large_unit) : 0),
				'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
				'md_unit'          => $get_row->medium_unit,
				'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
				'md_unit_qty_old'=> 0,
				'md_unit_prc'      => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_selling_hpp_medium_unit - $get_row->medium_disc_harga) : 0),
				'md_unit_prc_hpp'      => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_selling_hpp_medium_unit) : 0),
				'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
				'sm_unit'          => $get_row->small_unit,
				'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
				'sm_unit_qty_old'=> 0,
				'sm_unit_prc'      => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_selling_price_small_unit) : 0),
				'sm_unit_prc_hpp'      => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_selling_hpp_small_unit) : 0),
				'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
				'disc1'      => $get_row->large_disc_harga_percent,
				'disc2'      => $get_row->large_disc_harga_percent2,
				'disc3'      => $get_row->large_disc_harga_percent3,
				'total_small' => $total_small,
				'total_medium' => $total_medium,
				'total_large' => $total_large,
				'btncolor'         => '',
				'btnicon'          => '',
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	

	public function save()
	{
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$date           = $this->input->post("date");
		$customer       = $this->input->post("customer");
		$sub_total      = $this->input->post("sub_total");
		$ppn_id         = $this->input->post("ppn_id");
		$ppn_percentage = $this->input->post("ppn_percentage");
		$ppn_total      = $this->input->post("ppn_total");
		$grand_total    = $this->input->post("grand_total");
		$description    = $this->input->post("description");
		$purchase_id      = $this->input->post("purchase");
		$warehouse      = $this->input->post("warehouse");
		

		$salesman       = $this->input->post("salesman");

		$tmstamp         = $this->input->post("tmstamp");

		$vuedata = $this->input->post('vuedata');
		$ppn_type = ($ppn_id == NULL ? 0 : 1);

		$payment_due   = $this->input->post("payment_due");
		// $where         = array('supplier_id' => $supplier);
		// $supplier_data = $this->Suppliers_model->get_data($where)->row();
		// if($supplier_data){
		// 	$payment_due = date('Y-m-d', strtotime($date. ' + '. $supplier_data->supplier_payment_term .' days'));
		// }

		$header_id         = $id;
// 		$trheader_id       = 0;
		// $default_warehouse = $this->Warehouses_model->get_data(array('is_default' => '1'))->row_array();

// 		$prefix            = 'TF';
// 		$datenow           = date('ym');
// 		$transfer_number   = $this->Transfer_model->transfer_autonumber();
// 		$autonumber        = $prefix . $datenow . '-' . $transfer_number;



		$header_data = [
			'penerimaan_header_number'         => $number,
			'penerimaan_header_warehouse_id' => $warehouse,
			'penerimaan_header_date'           => change_format_date($date),
			'penerimaan_header_payment_due'    => change_format_date($payment_due),
			'penerimaan_header_customer_id'    => $customer,
		    'penerimaan_header_purchase_id' => $purchase_id,
			'penerimaan_header_sub_total'      => trims($sub_total),
			'penerimaan_header_ppn_id'         => $ppn_type,
			'penerimaan_header_ppn_percentage' => $ppn_percentage,
			'penerimaan_header_ppn_total'      => trims($ppn_total),
			'penerimaan_header_grand_total'    => trims($grand_total),
			'penerimaan_header_description'    => $description,
		];

// 		$trheader_data = [
// 			'header_number' => $autonumber,
// 			'header_date'   => change_format_date($date),
// 			'header_from'   => 0,
// 			'header_to'     => $customer
// 		];

		$detail_data = [];
		$log_data = [];
		$newprice_data = [];

		// if save $id = new else update data
		if ($vuedata) {
			if ($id == "new") {
				// save header
				$save_header  = $this->Penerimaan_model->save_header($header_data);

				if ($save_header) {
					$header_id = $this->db->insert_id();
				// 	$save_trheader = $this->Transfer_model->save_header($trheader_data);
				// 	$trheader_id = $this->db->insert_id();
					foreach ($vuedata as $row) {
						$detail_data[] = [
							'penerimaan_detail_header_id'            => $header_id,
							'penerimaan_detail_item_id'              => $row['id'],
				// 			'penerimaan_detail_warehouse_id'              => $row['warehouse'],
				// 			'penerimaan_detail_expired'              => $row['expired'],
							'penerimaan_detail_item_name'            => $row['name'],
							'penerimaan_detail_large_unit'           => $row['lg_unit'],
							'purchase_detail_large_unit_quantity'  => trims($row['lg_unit_qty_po']),
							'penerimaan_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
							'penerimaan_detail_large_unit_price'     => trims($row['lg_unit_prc']),
							'penerimaan_detail_result_large'         => trims($row['result_large']),
							'penerimaan_detail_medium_unit'          => $row['md_unit'],
							'purchase_detail_medium_unit_quantity' => trims($row['md_unit_qty_po']),
							'penerimaan_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
							'penerimaan_detail_medium_unit_price'    => trims($row['md_unit_prc']),
							'penerimaan_detail_result_medium'        => trims($row['result_medium']),
							'penerimaan_detail_small_unit'           => $row['sm_unit'],
							'penerimaan_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
							'purchase_detail_small_unit_quantity'  => trims($row['sm_unit_qty_po']),
							'penerimaan_detail_small_unit_price'     => trims($row['sm_unit_prc']),
							'penerimaan_detail_result_small'         => trims($row['result_small']),
							'penerimaan_detail_discount_percentage'  => trims($row['discount']),
							'penerimaan_detail_discount_total'       => trims($row['discount_total']),
				// 			'penerimaan_detail_disc1'                => trims($row['disc1']),
				// 			'penerimaan_detail_disc2'                => trims($row['disc2']),
				// 			'penerimaan_detail_disc3'                => trims($row['disc3']),
				// 			'penerimaan_detail_subtotal'                => trims($row['subtotal']),
							'penerimaan_detail_total'                => trims($row['total'])
						];

				// 		$trdetail_data[] = [
				// 			'header_id'      => $trheader_id,
				// 			'transaction_id' => $header_id,
				// 			'item_id'        => $row['id'],
				// 			'lg_qty'         => trims($row['lg_unit_qty']),
				// 			'md_qty'         => trims($row['md_unit_qty']),
				// 			'sm_qty'         => trims($row['sm_unit_qty']),
				// 			'status'         => "BUY",
				// 		];

			            $dtstamp                    = change_format_date($date) . " " . date("H:i:s");
						$where                      = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
						$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
						$last_total_stock           = 0;
						$last_log_total_stock_value = 0;

						if (!empty($log_data_check)) {
							$last_total_stock      		= $log_data_check['log_total_stock'];
							$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
						}

						$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * trims($row['lg_unit_qty'])) + ($row['md_unit_cnt'] * trims($row['md_unit_qty'])) + ($row['sm_unit_cnt'] * trims($row['sm_unit_qty']));
						$log_total_transaction_value = (trims($row['lg_unit_qty']) * trims($row['lg_unit_prc'])) + (trims($row['md_unit_qty']) * trims($row['md_unit_prc'])) + (trims($row['sm_unit_qty']) * trims($row['sm_unit_prc']));
						$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
						$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
						$log_average_small_unit      = 0;
						$log_average_medium_unit     = 0;
						$log_average_large_unit      = 0;
						$log_data[] = [
							'log_type'                            => 'PNBUY',
							'log_transaction_id'                  => $header_id,
							'log_item_id'                         => $row['id'],
							'log_large_unit'                      => $row['lg_unit'],
							'log_large_unit_contain'              => $row['lg_unit_cnt'],
							'log_large_unit_quantity'             => trims($row['lg_unit_qty']),
							'log_large_unit_purchase_price'       => trims($row['lg_unit_prc']),
							'log_medium_unit'                     => $row['md_unit'],
							'log_medium_unit_contain'             => $row['md_unit_cnt'],
							'log_medium_unit_quantity'            => trims($row['md_unit_qty']),
							'log_medium_unit_purchase_price'      => trims($row['md_unit_prc']),
							'log_small_unit'                      => $row['sm_unit'],
							'log_small_unit_contain'              => $row['sm_unit_cnt'],
							'log_small_unit_quantity'             => trims($row['sm_unit_qty']),
							'log_small_unit_purchase_price'       => trims($row['sm_unit_prc']),
							'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
							'log_total_transaction_value'         => $log_total_transaction_value,
							'log_total_stock'                     => $log_total_stock,
							'log_total_stock_value'               => $log_total_stock_value,
							'log_average_large_unit'              => $log_average_large_unit,
							'log_average_medium_unit'             => $log_average_medium_unit,
							'log_average_small_unit'              => $log_average_small_unit,
							'timestamp'                           => $dtstamp
						];

						$newprice_data[] = [
							'item_id'                         => $row['id'],
							'last_purchase_price_large_unit'  => trims($row['lg_unit_prc']),
							'last_purchase_price_medium_unit' => trims($row['md_unit_prc']),
							'last_purchase_price_small_unit'  => trims($row['sm_unit_prc'])
						];

				
					}

					$save_detail = $this->Penerimaan_model->save_detail($detail_data, true);
				// 	$save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);



					if ($save_detail) {
						$save_log = $this->Logs_model->save($log_data, true);

						if ($save_log) {
				            $update_log = $this->update_log($vuedata, $header_id, $date);
							// $update_log = true;
							if ($update_log) {
								// $s_trx = 'update';
    								$update_master_item = $this->Purchase_orders_model->update_master_item_batch($newprice_data);
    								$save_journal = $this->save_journal($header_id, $sub_total, $number,trims(0));
								// // if($update_master_item)
								// // {
								// $prefix_jr           = "JR";
								// $datenow_jr          = date('Ym');
								// $number_generator_jr = $this->Journals_model->journal_autonumber();
								// $autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;

								// $header_data_jr = [
								// 	'journal_header_number'       => $autonumber_jr,
								// 	'journal_header_trx_id'       => $header_id,
								// 	'journal_header_trx_type'     => "BUY",
								// 	'journal_header_date'         => change_format_date($date),
								// 	'journal_header_total_debit'  => trims($grand_total),
								// 	'journal_header_total_credit' => trims($grand_total),
								// 	'journal_header_description'  => $number,
								// ];

								// $save_header_jr = $this->Journals_model->save_header($header_data_jr);
								// $header_id_jr = $this->db->insert_id();

								// $detail_data_jr = [
								// 	[
								// 		'journal_detail_header_id'      => $header_id_jr,
								// 		'journal_detail_account_id'     => '20',
								// 		'journal_detail_account_number' => '11000035',
								// 		'journal_detail_account_name'   => 'Persediaan Material',
								// 		'journal_detail_debit'          => trims($grand_total),
								// 		'journal_detail_credit'         => 0,
								// 		'journal_detail_description'    => ''
								// 	],
								// 	[
								// 		'journal_detail_header_id'      => $header_id_jr,
								// 		'journal_detail_account_id'     => '24',
								// 		'journal_detail_account_number' => '210000019',
								// 		'journal_detail_account_name'   => 'Utang Usaha',
								// 		'journal_detail_debit'          => 0,
								// 		'journal_detail_credit'         => trims($grand_total),
								// 		'journal_detail_description'    => ''
								// 	]
								// ];

								// $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);

								$msg    = "Berhasil menyimpan data";
								$status = "success";
								}else{
									$msg    = "Gagal menyimpan data #CKP-U01";
									$status = "error";	
								}
							} else {
								$msg    = "Gagal menyimpan data #CKP-U01";
								$status = "error";
							}
				// 		} else {
				// 			$msg    = "Gagal menyimpan data";
				// 			$status = "error";
				// 		}
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				// $id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $id, 'status' => 'BUY'))->row()->header_id;

				$delete_detail = $this->Penerimaan_model->delete_detail($id);

				// $tf_delheader = $this->Transfer_model->delete_header($id_transfer);
				// $tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);

				// $jr_delheader = $this->Journals_model->delete_headerbytrxid($header_id, "BUY");
				// $jr_deldetail = $this->Journals_model->delete_detailbytrxid($header_id, "BUY");

				if ($delete_detail) {

				    $delete_log = $this->Logs_model->delete(array('log_transaction_id' => $id, 'log_type' => 'PNBUY'));
					if ($delete_log) {

						$save_header  = $this->Penerimaan_model->update_header($id, $header_data);
						$delete_journal = $this->delete_journal($id);

						if ($save_header) {
				// 			$save_trheader = $this->Transfer_model->save_header($trheader_data);
				// 			$trheader_id = $this->db->insert_id();

							foreach ($vuedata as $row) {
								$detail_data[] = [
										'penerimaan_detail_header_id'            => $header_id,
							'penerimaan_detail_item_id'              => $row['id'],
				// 			'penerimaan_detail_warehouse_id'              => $row['warehouse'],
				// 			'penerimaan_detail_expired'              => $row['expired'],
							'penerimaan_detail_item_name'            => $row['name'],
							'penerimaan_detail_large_unit'           => $row['lg_unit'],
							'purchase_detail_large_unit_quantity'  => trims($row['lg_unit_qty_po']),
							'penerimaan_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
							'penerimaan_detail_large_unit_price'     => trims($row['lg_unit_prc']),
							'penerimaan_detail_result_large'         => trims($row['result_large']),
							'penerimaan_detail_medium_unit'          => $row['md_unit'],
							'purchase_detail_medium_unit_quantity' => trims($row['md_unit_qty_po']),
							'penerimaan_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
							'penerimaan_detail_medium_unit_price'    => trims($row['md_unit_prc']),
							'penerimaan_detail_result_medium'        => trims($row['result_medium']),
							'penerimaan_detail_small_unit'           => $row['sm_unit'],
							'penerimaan_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
							'purchase_detail_small_unit_quantity'  => trims($row['sm_unit_qty_po']),
							'penerimaan_detail_small_unit_price'     => trims($row['sm_unit_prc']),
							'penerimaan_detail_result_small'         => trims($row['result_small']),
							'penerimaan_detail_discount_percentage'  => trims($row['discount']),
							'penerimaan_detail_discount_total'       => trims($row['discount_total']),
				// 			'penerimaan_detail_disc1'                => trims($row['disc1']),
				// 			'penerimaan_detail_disc2'                => trims($row['disc2']),
				// 			'penerimaan_detail_disc3'                => trims($row['disc3']),
				// 			'penerimaan_detail_subtotal'                => trims($row['subtotal']),
							'penerimaan_detail_total'                => trims($row['total'])
								];
								

								$dtstamp                    = change_format_date($date) . " " . $tmstamp;
								$where                      = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
								$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
								$last_total_stock           = 0;
								$last_log_total_stock_value = 0;
								$last_log_avg_large         = 0;
								$last_log_avg_medium        = 0;
								$last_log_avg_small         = 0;

								if (!empty($log_data_check)) {
									$last_total_stock           = $log_data_check['log_total_stock'];
									$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
									$last_log_avg_large         = $log_data_check['log_average_large_unit'];
									$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
									$last_log_avg_small         = $log_data_check['log_average_small_unit'];
								}

								$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * trims($row['lg_unit_qty'])) + ($row['md_unit_cnt'] * trims($row['md_unit_qty'])) + ($row['sm_unit_cnt'] * trims($row['sm_unit_qty']));
								$log_total_transaction_value = (trims($row['lg_unit_qty']) * trims($row['lg_unit_prc'])) + (trims($row['md_unit_qty']) * trims($row['md_unit_prc'])) + (trims($row['sm_unit_qty']) * trims($row['sm_unit_prc']));
								$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
								$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
								$log_average_small_unit      = 0;
								$log_average_medium_unit     = 0;
								$log_average_large_unit      = 0;
								$log_data[] = [
									'log_type'                            => 'BUY',
									'log_transaction_id'                  => $header_id,
									'log_item_id'                         => $row['id'],
									'log_large_unit'                      => $row['lg_unit'],
									'log_large_unit_contain'              => $row['lg_unit_cnt'],
									'log_large_unit_quantity'             => trims($row['lg_unit_qty']),
									'log_large_unit_purchase_price'       => trims($row['lg_unit_prc']),
									'log_medium_unit'                     => $row['md_unit'],
									'log_medium_unit_contain'             => $row['md_unit_cnt'],
									'log_medium_unit_quantity'            => trims($row['md_unit_qty']),
									'log_medium_unit_purchase_price'      => trims($row['md_unit_prc']),
									'log_small_unit'                      => $row['sm_unit'],
									'log_small_unit_contain'              => $row['sm_unit_cnt'],
									'log_small_unit_quantity'             => trims($row['sm_unit_qty']),
									'log_small_unit_purchase_price'       => trims($row['sm_unit_prc']),
									'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
									'log_total_transaction_value'         => $log_total_transaction_value,
									'log_total_stock'                     => $log_total_stock,
									'log_total_stock_value'               => $log_total_stock_value,
									'log_average_large_unit'              => $log_average_large_unit,
									'log_average_medium_unit'             => $log_average_medium_unit,
									'log_average_small_unit'              => $log_average_small_unit,
									'timestamp'                           => $dtstamp
								];

								$newprice_data[] = [
									'item_id'                         => $row['id'],
									'last_purchase_price_large_unit'  => trims($row['lg_unit_prc']),
									'last_purchase_price_medium_unit' => trims($row['md_unit_prc']),
									'last_purchase_price_small_unit'  => trims($row['sm_unit_prc']),
								];
								
							}

							$save_detail = $this->Penerimaan_model->save_detail($detail_data, true);
				// 			$save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);

				// 			if(trims($row['sm_unit_qty']) != 0 || trims($row['md_unit_qty']) != 0 || trims($row['lg_unit_qty'] != 0)){
								if ($save_detail) {

								    $save_log = $this->Logs_model->save($log_data, true);
	
									if ($save_log) {
										$update_log = $this->update_log($vuedata, $header_id, $date);
										// $update_log = true;
										if ($update_log) {
											// $s_trx = 'update';
											$update_master_item = $this->Penerimaan_model->update_master_item_batch($newprice_data);
	                                        $save_journal = $this->save_journal($header_id, $sub_total, $number,trims(0));
								// 			$prefix_jr           = "JR";
								// 			$datenow_jr          = date('Ym');
								// 			$number_generator_jr = $this->Journals_model->journal_autonumber();
								// 			$autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;
	
								// 			$header_data_jr = [
								// 				'journal_header_number'       => $autonumber_jr,
								// 				'journal_header_trx_id'       => $header_id,
								// 				'journal_header_trx_type'     => "BUY",
								// 				'journal_header_date'         => change_format_date($date),
								// 				'journal_header_total_debit'  => trims($grand_total),
								// 				'journal_header_total_credit' => trims($grand_total),
								// 				'journal_header_description'  => $number,
								// 			];
	
								// 			$save_header_jr = $this->Journals_model->save_header($header_data_jr);
								// 			$header_id_jr = $this->db->insert_id();
	
								// 			$detail_data_jr = [
								// 				[
								// 					'journal_detail_header_id'      => $header_id_jr,
								// 					'journal_detail_account_id'     => '20',
								// 					'journal_detail_trx_id'         => $header_id,
								// 					'journal_detail_trx_type'       => "BUY",
								// 					'journal_detail_account_number' => '11000035',
								// 					'journal_detail_account_name'   => 'Persediaan Material',
								// 					'journal_detail_debit'          => trims($grand_total),
								// 					'journal_detail_credit'         => 0,
								// 					'journal_detail_description'    => ''
								// 				],
								// 				[
								// 					'journal_detail_header_id'      => $header_id_jr,
								// 					'journal_detail_account_id'     => '24',
								// 					'journal_detail_trx_id'         => $header_id,
								// 					'journal_detail_trx_type'       => "BUY",
								// 					'journal_detail_account_number' => '210000019',
								// 					'journal_detail_account_name'   => 'Utang Usaha',
								// 					'journal_detail_debit'          => 0,
								// 					'journal_detail_credit'         => trims($grand_total),
								// 					'journal_detail_description'    => ''
								// 				]
								// 			];
	
								// 			$save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);
											// if($update_master_item)
											// {
											$msg    = "Berhasil menyimpan data";
											$status = "success";
											// }else{
											// 	$msg    = "Gagal menyimpan data #CKP-U01";
											// 	$status = "error";	
											// }
										} else {
											$msg    = "Gagal menyimpan data #CKP-U01";
											$status = "error";
										}
									} else {
										$msg    = "Gagal menyimpan data #LOG-S01";
										$status = "error";
									}
								} else {
									$msg    = "Gagal menyimpan data #LOG-U01";
									$status = "error";
								}
				// 			}else {
				// 				$msg    = "Berhasil menyimpan data";
				// 				$status = "success";
				// 			}
							
						}
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			}
		} else {
			$msg    = "Gagal menyimpan data";
			$status = "error";
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}
	
	public function save_journal($header_id, $sub_total, $number,$ppn)
	{
		$prefix           = "JR";
		$datenow          = date('Ym');
		$number_generator = $this->Journals_model->journal_autonumber();
		$autonumber       = $prefix . $datenow . $number_generator;

		$header_data = [
			// 'journal_header_number'       => ($id == "new" ? $autonumber : $number),
			'journal_header_trx_id'       => $header_id,
			'journal_header_trx_type'     => "PNBUY",
			'journal_header_number'       => ($autonumber),
			'journal_header_date'         => date_now(),
			'journal_header_total_debit'  => trims($sub_total),
			'journal_header_total_credit' => trims($sub_total),
			'journal_header_description'  => $number,
		];

		$detail_data = [];

		$account =  $this->Accounts_model->get_data_settings_advance(array('trx_type' => 'PO'))->result();

		$save_header_jr = $this->Journals_model->save_header($header_data);
		$header_id_jr = $this->db->insert_id();

		foreach ($account as $get_row) {

			$status = $get_row->status;
			$detail_data[] = [
				'journal_detail_trx_id'         => $header_id,
				'journal_detail_trx_type'       => "PNBUY",
				'journal_detail_header_id'      => $header_id_jr,
				'journal_detail_account_id'     => $get_row->account_id,
				'journal_detail_account_number' => $get_row->account_number,
				'journal_detail_account_name'   => $get_row->account_name,
				'journal_detail_account_group'      => $get_row->account_group_name,
				'journal_detail_debit'          => ($get_row->account_name != "PPN MASUKAN"  ? ($status == "D" ? trims($sub_total)  : 0) : ($status == "D" ? $ppn : 0)),
				'journal_detail_credit'         => ($status == "K" ? trims($sub_total) + $ppn : 0),
				'journal_detail_description'    => ""
			];
		}

		$save_detail = $this->Journals_model->save_detail($detail_data, true);
	}

	public function delete_journal($id)
	{
		$type = "BUY";
		$delete_header = $this->Journals_model->delete_headerbytrxid($id, $type);

		if ($delete_header) {
			$delete_type = $this->Journals_model->delete_headerbytrxid($id, $type);
		}
	}

	public function update_log($vuedata, $header_id = '', $date = '')
	{
		$data_log = [];
		$data_where = [];

		$updateData = array();

		$total_stok = 0;
		$total_stok_rupiah = 0;
		$avg_lg = 0;
		$avg_md = 0;
		$avg_sm = 0;

		foreach ($vuedata as $rowes) {

			$where_1         = array('log_item_id' => $rowes['id']);
			$get_first       = $this->Logs_model->cek_data($where_1)->result();

			if (count($get_first) > 1) {
				$get_first       = $this->Logs_model->get_data_first($where_1)->row();

				$logs_id         = $get_first->tmslog;

				$total_stok      = $get_first->log_total_stock;
				$total_stok_rupiah = $get_first->log_total_stock_value;

				$avg_lg  = ($get_first->log_average_large_unit);
				$avg_md  = ($get_first->log_average_medium_unit);
				$avg_sm  = ($get_first->log_average_small_unit);

				$log_total_transaction_value = 0;

				$where_2 = array('log_item_id' => $rowes['id'], 'a.timestamp >' => $logs_id);
				$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2, 'a.timestamp asc')->result();

				foreach ($get_data_all_logs_by_item as $row) {


					$total_stok      += $row->log_total_transaction_in_small_unit;

					if ($row->log_type == "PNBUY" || $row->log_type == "R-SELL") {
						$log_total_transaction_value = (($row->log_large_unit_quantity * ($row->log_large_unit_purchase_price)) + ($row->log_medium_unit_quantity * ($row->log_medium_unit_purchase_price)) + ($row->log_small_unit_quantity * ($row->log_medium_unit_purchase_price)));
					} else {
						$log_total_transaction_value = (($row->log_large_unit_quantity * ($avg_lg)) + ($row->log_medium_unit_quantity * ($avg_md)) + ($row->log_small_unit_quantity * ($avg_sm)));
					}
					$total_stok_rupiah += $log_total_transaction_value;


					$log_average_small_unit  = ($total_stok == 0 ? 0 : ($total_stok_rupiah / $total_stok));
					$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
					$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);

					// $log_total_transaction_value = a;

					if ($row->log_type == "PNBUY" || $row->log_type == "R-SELL") {
						$avg_lg  = ($log_average_large_unit);
						$avg_md  = ($log_average_medium_unit);
						$avg_sm  = ($log_average_small_unit);
						$data_log[] = array(
							'log_id'                        => $row->log_id,
							// 'log_medium_unit_purchase_price' => $medium_purchase_price,
							// 'log_small_unit_purchase_price'  => $small_purchase_price,
							// 'log_total_transaction_value' => $log_total_transaction_value,
							'log_total_stock'             => $total_stok,
							'log_total_stock_value'       => $total_stok_rupiah,
							'log_average_large_unit'      => $log_average_large_unit,
							'log_average_medium_unit'     => $log_average_medium_unit,
							'log_average_small_unit'      => $log_average_small_unit,
							// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
						);
					} else {

						$data_log[] = array(
							'log_id'                         => $row->log_id,
							'log_large_unit_purchase_price'  => $avg_lg,
							'log_medium_unit_purchase_price' => $avg_md,
							'log_small_unit_purchase_price'  => $avg_sm,
							'log_total_transaction_value'    => $log_total_transaction_value,
							'log_total_stock'                => $total_stok,
							'log_total_stock_value'          => $total_stok_rupiah,
							'log_average_large_unit'         => $log_average_large_unit,
							'log_average_medium_unit'        => $log_average_medium_unit,
							'log_average_small_unit'         => $log_average_small_unit,
							// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
						);
					}
				}

				$after_row_log_update = $this->Logs_model->update_item_batch($data_log);
			} else {
				return true;
			}
		}

		// if(!empty($data_log)){

		// }

		return true;
	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach ($id as $row) {
			$where = array('log_type' => 'PNBUY', 'log_transaction_id' => $row);
			$get_data_log = $this->Logs_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {

				// Get Data After This Item ID :::
				$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
				$get_after_data = $this->Logs_model->get_data($where_after)->result();

				if ($get_after_data) {
					foreach ($get_after_data as $row_list_detail) {

						$where_log_delete = array(
							'log_item_id' => $row_list->log_item_id,
							'log_id' => $row_list->log_id
						);

						$delete_logs = $this->Logs_model->delete($where_log_delete);

						// $where_this = array('log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
						$where_this = array('log_id' => $row_list_detail->log_id, 'log_item_id' => $row_list_detail->log_item_id);
						$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;

						$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
						$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
						$one_line_before_total     = 0;
						$one_line_before_log_total = 0;
						$one_line_before_log_avg_large = 0;
						$one_line_before_log_avg_medium = 0;
						$one_line_before_log_avg_small = 0;

						if (!empty($one_line_before_log_data)) {
							$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
							$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
							$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
							$one_line_before_log_avg_medium = $one_line_before_log_data['log_average_medium_unit'];
							$one_line_before_log_avg_small = $one_line_before_log_data['log_average_small_unit'];
						}

						$purchase_price              = $row_list_detail->log_large_unit_purchase_price;
						$log_total_transaction_value = $row_list_detail->log_total_transaction_value;
						$medium_purchase_price       = $row_list_detail->log_medium_unit_purchase_price;
						$small_purchase_price        = $row_list_detail->log_small_unit_purchase_price;
						$log_total_stock             = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
						$log_total_stock_value       = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit     = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
						$log_average_large_unit      = ($log_average_small_unit * $row_list_detail->large_unit_contain);

						if ($row_list_detail->log_type == 'SELL') {
							$purchase_price              = $one_line_before_log_avg_large;
							// $medium_purchase_price       = ($row_list_detail->log_medium_unit_contain == 0 ? 0 : ($one_line_before_log_avg_medium));
							// $small_purchase_price        = ($row_list_detail->log_small_unit_contain == 0 ? 0 : ($one_line_before_log_avg_small));
							$medium_purchase_price       = ($row_list_detail->log_medium_unit_contain == 0 ? 0 : ($one_line_before_log_avg_medium));
							$small_purchase_price        = ($row_list_detail->log_small_unit_contain == 0 ? 0 : ($one_line_before_log_avg_small));
							$log_total_transaction_value = ($row_list_detail->log_large_unit_quantity * $one_line_before_log_avg_large) + ($row_list_detail->log_medium_unit_quantity * $medium_purchase_price) + ($row_list_detail->log_small_unit_quantity * $small_purchase_price);
							$log_total_stock_value       = ($one_line_before_log_total + $log_total_transaction_value);
							$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
							$log_average_medium_unit     = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
							$log_average_large_unit      = ($log_average_small_unit * $row_list_detail->large_unit_contain);
						}
						$after_row_data_update = array(
							'log_id'                         => $row_list_detail->log_id,
							'log_large_unit_purchase_price'  => $purchase_price,
							'log_medium_unit_purchase_price' => $medium_purchase_price,
							'log_small_unit_purchase_price'  => $small_purchase_price,
							'log_total_transaction_value'    => $log_total_transaction_value,
							'log_total_stock'                => $log_total_stock,
							'log_total_stock_value'          => $log_total_stock_value,
							'log_average_large_unit'         => $log_average_large_unit,
							'log_average_medium_unit'        => $log_average_medium_unit,
							'log_average_small_unit'         => $log_average_small_unit
						);

						$after_row_where_update = array(
							'log_id' => $row_list_detail->log_id,
						);

						// echo json_encode($one_line_before_log_data);
						$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
					}
				} else {
					$where_log_delete = array(
						'log_item_id' => $row_list->log_item_id,
						'log_id' => $row_list->log_id
					);

					$delete_logs = $this->Logs_model->delete($where_log_delete);
				}
			}

			$delete_header = $this->Penerimaan_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Penerimaan_model->delete_detail($row);
			}

			$jr_delheader = $this->Journals_model->delete_headerbytrxid($row, "PNBUY");
			$jr_deldetail = $this->Journals_model->delete_detailbytrxid($row, "PNBUY");

// 			$id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $row, 'status' => 'BUY'))->row()->header_id;

// 			$tf_delheader = $this->Transfer_model->delete_header($id_transfer);
// 			$tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function delete_item()
	{
		$id        = $this->input->post('id');
		$item      = $this->input->post('item');
		$total      = $this->input->post('total');
		$data_item = [];

		$delete_type = $this->Penerimaan_model->delete_detail_advance(array('penerimaan_detail_header_id' => $id, 'penerimaan_detail_item_id' => $item['id']));
		if ($delete_type) {
			$delete_log = $this->Logs_model->delete(array('log_transaction_id' => $id, 'log_type' => 'BUY', 'log_item_id' => $item['id']));
		}

		if ($delete_log) {
			$whereH = array('penerimaan_header_id' => $id);
			$header_data_check   = $this->Penerimaan_model->purchaseorder_header($whereH)->row_array();
			$header_data = [
				
				'penerimaan_header_grand_total'    => $header_data_check['penerimaan_header_grand_total'] - (int)trims($total),
			];
			$save_header  = $this->Penerimaan_model->update_header($id, $header_data);
			$whereI = array('item_id' => $item['id']);
			$item_data_check   = $this->Items_model->get_data($whereI)->row_array();
			$where_item = $item['id'];
			
			$data_item = array(
				'item_in_total'  =>  $item_data_check['item_in_total'] - ((int)trims($item['sm_unit_qty_old']) *  $item_data_check['small_unit_contain']) - ((int)trims($item['md_unit_qty_old']) *  $item_data_check['medium_unit_contain']) - ((int)trims($item['lg_unit_qty_old'] *  $item_data_check['large_unit_contain'])),		
				// 'stock_total' => $item_data_check['item_in_total'] - $item_data_check['item_out_total'],
				// 'stock_besar' => $item_data_check['stock_total'] / $item_data_check['large_unit_contain'],
				//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
				//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
			);


			$update_item =  $this->Items_model->update($where_item, $data_item);
			if($update_item){
				$whereI2               = array('item_id' => $item['id']);
				$item_data_check2             = $this->Items_model->get_data($whereI2)->row_array();
				$where_item = $item['id'];
				
				$data_item2 = array(
					'stock_total' => $item_data_check2['item_in_total'] - $item_data_check2['item_out_total'],
					//	'stock_sedang' => $item_data_check['stock_total'] / $item_data_check['medium_unit_contain'],
					//	'stock_kecil' => $item_data_check['stock_total'] / $item_data_check['small_unit_contain'],
				);
				$this->Items_model->update($where_item, $data_item2);
			}

			$response = array(
				'message' => 'Berhasil menghapus data',
				'status'  => 'success'
			);
		}



		output_json($response);
	}

	public function print_out($id)
	{
		$where_header  = array('penerimaan_header_id' => $id);
		$where_detail  = array('penerimaan_detail_header_id' => $id);
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');

		$config_receipt2 = $this->Configuration_model->get_data_invoice($where_config2)->row_array();

		$header = $this->Penerimaan_model->purchaseorder_header($where_header)->row_array();
		$detail = $this->Penerimaan_model->purchaseorder_detail2($where_detail, 'group_order asc, item_name')->result();

		$data['content_title'] = 'Print Pembelian';
		$data['header'] = $header;
		$data['detail'] = $detail;
		$data['config_receipt2'] = $config_receipt2;

		$this->twiggy_display('adm/penerimaan/print_out', $data);
	}

	public function export_excel($id)
	{

		$where    = [];
		$where['penerimaan_header_id'] = $id;

		$get_data = $this->Penerimaan_model->purchaseorder_detail_advance($where)->result();


		// Class PHPExcel
		$excel = new PHPExcel();
		// Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
			->setLastModifiedBy('TOKO TEST INDONESIA')
			->setTitle("PEMBELIAN")
			->setSubject("PEMBELIAN")
			->setDescription("PEMBELIAN")
			->setKeywords("PEMBELIAN");


		$excel->setActiveSheetIndex(0)->setCellValue('A1', "nomor");
		$excel->setActiveSheetIndex(0)->setCellValue('B1', "tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('C1', "supplier");
		$excel->setActiveSheetIndex(0)->setCellValue('D1', "grup");
		$excel->setActiveSheetIndex(0)->setCellValue('E1', "levelgrup");
		$excel->setActiveSheetIndex(0)->setCellValue('F1', "nama");
		$excel->setActiveSheetIndex(0)->setCellValue('G1', "besar");
		$excel->setActiveSheetIndex(0)->setCellValue('H1', "levelbsr");
		$excel->setActiveSheetIndex(0)->setCellValue('I1', "qtybesar");
		$excel->setActiveSheetIndex(0)->setCellValue('J1', "hbbesar");
		$excel->setActiveSheetIndex(0)->setCellValue('K1', "sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('L1', "levelsdg");
		$excel->setActiveSheetIndex(0)->setCellValue('M1', "qtysedang");
		$excel->setActiveSheetIndex(0)->setCellValue('N1', "hbsedang");
		$excel->setActiveSheetIndex(0)->setCellValue('O1', "kecil");
		$excel->setActiveSheetIndex(0)->setCellValue('P1', "levelkcl");
		$excel->setActiveSheetIndex(0)->setCellValue('Q1', "qtykecil");
		$excel->setActiveSheetIndex(0)->setCellValue('R1', "hbkecil");
		$excel->setActiveSheetIndex(0)->setCellValue('S1', "disc");
		$excel->setActiveSheetIndex(0)->setCellValue('T1', "totalharga");
		$excel->setActiveSheetIndex(0)->setCellValue('U1', "subtotal");
		$excel->setActiveSheetIndex(0)->setCellValue('V1', "ppn");
		$excel->setActiveSheetIndex(0)->setCellValue('W1', "grandtotal");
		$excel->setActiveSheetIndex(0)->setCellValue('X1', "keterangan");

		$no = 1; // Untuk penomoran tabel, di awal set dengan 1
		$numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 9
		foreach ($get_data as $get_row) { // Lakukan looping pada variabel row

			$grup = $this->Groups_model->get_data(array('group_id' => $get_row->item_group_id))->row();

			$unit_large  = $this->Units_model->get_data(array('unit_name' => $get_row->penerimaan_detail_large_unit))->row_array();
			$unit_medium = $this->Units_model->get_data(array('unit_name' => $get_row->penerimaan_detail_medium_unit))->row_array();
			$unit_small  = $this->Units_model->get_data(array('unit_name' => $get_row->penerimaan_detail_small_unit))->row_array();

			$excel->setActiveSheetIndex(0)->setCellValue('A' . $numrow, $get_row->penerimaan_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B' . $numrow, change_format_date($get_row->penerimaan_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C' . $numrow, $get_row->supplier_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D' . $numrow, $grup->group_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E' . $numrow, $grup->group_order);

			$excel->setActiveSheetIndex(0)->setCellValue('F' . $numrow, $get_row->penerimaan_detail_item_name);

			$excel->setActiveSheetIndex(0)->setCellValue('G' . $numrow, ($get_row->penerimaan_detail_large_unit_quantity  > 0 ? $get_row->penerimaan_detail_large_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('H' . $numrow, ($get_row->penerimaan_detail_large_unit_quantity  > 0 ? (!empty($unit_large) ? $unit_large['unit_priority'] : '') : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('I' . $numrow, ($get_row->penerimaan_detail_large_unit_quantity  > 0 ? to_decimal($get_row->penerimaan_detail_large_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('J' . $numrow, ($get_row->penerimaan_detail_large_unit_quantity  > 0 ? ($get_row->penerimaan_detail_large_unit_price) : ''));

			$excel->setActiveSheetIndex(0)->setCellValue('K' . $numrow, ($get_row->penerimaan_detail_medium_unit_quantity > 0 ? $get_row->penerimaan_detail_medium_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('L' . $numrow, ($get_row->penerimaan_detail_medium_unit_quantity > 0 ? (!empty($unit_medium) ? $unit_medium['unit_priority'] : '') : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('M' . $numrow, ($get_row->penerimaan_detail_medium_unit_quantity > 0 ? to_decimal($get_row->penerimaan_detail_medium_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('N' . $numrow, ($get_row->penerimaan_detail_medium_unit_quantity > 0 ? ($get_row->penerimaan_detail_medium_unit_price) : ''));

			$excel->setActiveSheetIndex(0)->setCellValue('O' . $numrow, ($get_row->penerimaan_detail_small_unit_quantity  > 0 ? $get_row->penerimaan_detail_small_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('P' . $numrow, ($get_row->penerimaan_detail_small_unit_quantity  > 0 ? (!empty($unit_small) ? $unit_small['unit_priority'] : '') : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('Q' . $numrow, ($get_row->penerimaan_detail_small_unit_quantity  > 0 ? to_decimal($get_row->penerimaan_detail_small_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('R' . $numrow, ($get_row->penerimaan_detail_small_unit_quantity  > 0 ? ($get_row->penerimaan_detail_small_unit_price) : ''));

			$excel->setActiveSheetIndex(0)->setCellValue('S' . $numrow, ($get_row->penerimaan_detail_discount_total));
			$excel->setActiveSheetIndex(0)->setCellValue('T' . $numrow, ($get_row->penerimaan_detail_result_large + $get_row->penerimaan_detail_result_medium + $get_row->penerimaan_detail_result_small));

			$excel->setActiveSheetIndex(0)->setCellValue('U' . $numrow, $get_row->penerimaan_header_sub_total);
			$excel->setActiveSheetIndex(0)->setCellValue('V' . $numrow, $get_row->penerimaan_header_ppn_total);
			$excel->setActiveSheetIndex(0)->setCellValue('W' . $numrow, $get_row->penerimaan_header_grand_total);

			$excel->setActiveSheetIndex(0)->setCellValue('X' . $numrow, $get_row->penerimaan_header_description);

			// $username = $this->Users_model->get_data_advance($get_row->sales_order_header_user_id)->row()->fullname;
			// $excel->setActiveSheetIndex(0)->setCellValue('AA'.$numrow, $username);
			// $excel->setActiveSheetIndex(0)->setCellValue('AB'.$numrow, rtrim($get_row->sales_order_header_description));


			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			// $ppn_status       = $get_row->sales_order_detail_ppn_status;

			// $excel->getActiveSheet()->getStyle('A'.$numrow.':O'.$numrow)->applyFromArray($style_row);
			// if($ppn_status == '2'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_success);
			// }
			// if($ppn_status == '3'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_warning);
			// }

			// $excel->getActiveSheet()->getStyle('G'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			// $excel->getActiveSheet()->getStyle('J'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			// $excel->getActiveSheet()->getStyle('M'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			// $excel->getActiveSheet()->getStyle('N'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$no++; // Tambah 1 setiap kali looping
			$numrow++; // Tambah 1 setiap kali looping
		}

		// Set width
		$excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

		// Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);

		// Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);

		// Set judul file excel
		$excel->getActiveSheet(0)->setTitle("PEMBELIAN");
		$excel->setActiveSheetIndex(0);

		// Proses file excel
		// $date_now = change_format_date(date_now(), 'Ymd');
		$filename = $get_data[0]->penerimaan_header_number . '.csv';

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment; filename="' . $filename . '"'); // Set nama file excel nya
		header('Cache-Control: max-age=0');
		// $write = PHPExcel_IOFactory::createWriter($excel, 'Excel5');
		$write = new PHPExcel_Writer_CSV($excel);
		$write->save('php://output');
	}

	public function ex_average($id = '')
	{
		// $where_header = array('penerimaan_header_id' => $id);
		// $where_detail = array('penerimaan_detail_header_id' => $id);

		$order = ("b.item_name, a.log_id ASC");
		$detail = $this->Logs_model->get_data('', $order)->result();

		$data['content_title'] = 'Hasil Perhitungan Average';
		// $data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/penerimaan/print_avg', $data);
	}

	public function ed_average($id = '')
	{
		$detail = $this->Logs_model->get_data()->result();
		foreach ($detail as $key => $get_row) {
			$data[] = array(
				'log_total_transaction_in_small_unit' => $get_row[$key]->log_total_transaction_in_small_unit,
				'log_total_transaction_value'         => $get_row->log_total_transaction_value,
				'log_total_stock'                     => $get_row->log_total_stock,
				'log_total_stock_value'               => $get_row->log_total_stock_value,
				'log_average_large_unit'              => $get_row->log_average_large_unit,
				'log_average_medium_unit'             => $get_row->log_average_medium_unit,
				'log_average_small_unit'              => $get_row->log_average_small_unit
			);
		}

		echo json_encode($data);
	}
}
