/**
 * Javascript Cash_transfers
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.MASTER = (function ($) {

	var renderCheckbox = function (data, type, full, meta) {
		// return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
		// var checkbox = '';
		// if (full['so_data'] == false){
			checkbox = '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
		// }
		return checkbox;
	}

	var renderEdit = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/cash_transfers/edit/' + full['id'];
		return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Click to Edit">' + data + '</a>';
	}

	var renderPrice = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/special_prices/edit/' + full['id'];
		return '<a href="'+ url +'" class="btn btn-sm btn-warning" data-id="' + full['id'] + '" data-toggle="tooltip" data-placement="right" title="Click to Edit Special Prices"><i class="fas fa-tags"></i></a>';
	}

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elForm: '.master-form',
		elEdit: '.master-edit',
		elTable: '#master-table',
		elModal: '.master-modal',
		elBtnDelete: '.master-delete',
		elModalClose: '.master-cancel',
		elBtnFilter: '.master-filter',
		elSubCheckbox: '.check-sub-master',
		elParentCheckbox: '.check-all-master',
		elModalContent: '.master-modal-content',
		urlDeleteData: window.APP.siteUrl + 'adm/cash_transfers/delete',
		urlRequestData: window.APP.siteUrl + 'adm/cash_transfers/get_data',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var parentThis = this;
		},

		// Master
		handleVueMaster: function () {
			var parentThis = this;

			// Vue Js
			new Vue({
				el: parentThis.elVue,
				delimiters: ['<%', '%>'],
				methods: {
					addRowType: function () {
						var vue = this;
					}
				},
				mounted: function () {
					parentThis.handleDataTable();
				}
			});

		},

		handleCheckbox: function () {
			var parentThis = this;

			$(parentThis.elTable).on("click", parentThis.elSubCheckbox, function () {
				var row     = ($('#master-table tr').length - 1);
				var checked = $('#master-table').find('input[class="check-sub-master"]:checked');

				if(row == checked.length){
					$('#check-all-master').prop('checked', true);
				}else{
					$('#check-all-master').prop('checked', false);
				}

			});

			$('select[name="master-table_length"]').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
				
			});

			$('#master-table_paginate').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
			});

		},

		// Cash_transfers : handleDataTable
		handleDataTable: function () {
			var parentThis = this;

			var fromdate = $('#fromdate').val();
            var todate = $('#todate').val();
            console.log(fromdate);
            console.log(todate);
			parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					type: "POST",
					dataType: 'json',
					url: parentThis.urlRequestData,
					data: {
						fromdate: fromdate,
						todate: todate,
					},
				},
				columns: [{
						data: 'no',
						width: '20',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'from_name',
					},
					{
						data: 'to_name',
					},
					{
						data: 'amount',
					},
					{
						data: 'description',
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {

					// handle form
					window.FORM.handleEditModal(
						parentThis.elForm,
						parentThis.elEdit,
						parentThis.elModal,
						parentThis.elModalContent,
						parentThis.elModalClose,
						parentThis.elDatatable
					);

					parentThis.handleDelete();
					parentThis.handleCheckbox();
					parentThis.handleFilter();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},
		
		handleFilter: function () {
			var parentThis = this;

			$(parentThis.elBtnFilter).click(function () {
			 //   if ($.fn.DataTable.isDataTable(parentThis.elTable)) {
                    parentThis.elDatatable.destroy();
                // }
                parentThis.handleDataTable();
			});
		},

		// Cash_transfers : handleDelete
		handleDelete: function () {
			var parentThis = this;

			$(parentThis.elBtnDelete).click(function () {

				var Items = $(parentThis.elTable).find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteData,
								data: {
									id: types,
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									parentThis.elDatatable.ajax.reload();

									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},

	}

})(jQuery);