/**
 * Javascript Embed
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

window.EMBED = (function ($) {
	return {

		initVue: null,
		elVue: '#embed-vue',
		elTable: "#embed-table",
		elClose: '.embed-close',

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		urlGetData: window.APP.siteUrl + 'adm/sales_orders/get_data_embed',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					listData: [],
					a:'',
				},
				methods: {
					getDataEmbed: function (Event) {
                        var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						var value = $("#search").val();
						var customer = $("#customer-select").val();
						
						$.ajax({
                            url: that.urlGetData,
                            type: 'post',
                            data: {
                                'search': value,
                                'customer': customer
                            },
							dataType: "json",
							success: function (response) {
								// vue.$set(vue, 'listData', response.data);
								
								var items = response.data;
								var listData = {};

								for (i = 0; i < items.length; i++) {
									var item = items[i];

									var lg_unit     = item.lg_unit;
									var md_unit     = item.md_unit;
									var sm_unit     = item.sm_unit;
									var lg_unit_cnt = item.lg_unit_cnt;
									var md_unit_cnt = item.md_unit_cnt;
									var sm_unit_cnt = item.sm_unit_cnt;
									var lg_unit_qty = 0;
									var md_unit_qty = 0;
									var sm_unit_qty = 0;
									var lg_unit_prc = item.lg_unit_prc;
									var md_unit_prc = item.md_unit_prc;
									var sm_unit_prc = item.sm_unit_prc;
										var ppn_status = item.ppn_status;
									var ppn_status_color = item.ppn_status_color;
									// var discount = 0;
									// var discount_total = 0;
									var result_large = 0;
									var result_medium = 0;
									var result_small = 0;
									var total = 0;

									var btncolor = 'btn-default';
									var btnicon = '';

									if (vue.checkValue_isExists(item.id, vue.a) == 'Exist') {
										btncolor = 'btn-success';
										btnicon = 'fa fa-check';
										index = editVueInit.detailData.map(function (item) {
											return item.id
										}).indexOf(item.id);

										lg_unit_qty = editVueInit.detailData[index].lg_unit_qty;
										md_unit_qty = editVueInit.detailData[index].md_unit_qty;
										sm_unit_qty = editVueInit.detailData[index].sm_unit_qty;
										lg_unit_prc = editVueInit.detailData[index].lg_unit_prc;
										md_unit_prc = editVueInit.detailData[index].md_unit_prc;
										sm_unit_prc = editVueInit.detailData[index].sm_unit_prc;
											ppn_status = editVueInit.detailData[index].ppn_status;
										ppn_status_color = editVueInit.detailData[index].ppn_status_color;
										// discount = editVueInit.detailData[index].discount;
										// discount_total = editVueInit.detailData[index].discount_total;
										result_large = editVueInit.detailData[index].result_large;
										result_medium = editVueInit.detailData[index].result_medium;
										result_small = editVueInit.detailData[index].result_small;
										total = editVueInit.detailData[index].total;
									}
									listData[i] = {
										'no'              : item.no,
										'id'              : item.id,
										'name'            : item.name,
										'group_name'      : item.group_name,
										'group_child_name': item.group_child_name,
										'lg_unit'         : lg_unit,
										'lg_unit_cnt'     : lg_unit_cnt,
										'lg_unit_qty'     : lg_unit_qty,
										'lg_unit_prc'     : lg_unit_prc,
										'md_unit'         : md_unit,
										'md_unit_cnt'     : md_unit_cnt,
										'md_unit_qty'     : md_unit_qty,
										'md_unit_prc'     : md_unit_prc,
										'sm_unit'         : sm_unit,
										'sm_unit_cnt'     : sm_unit_cnt,
										'sm_unit_qty'     : sm_unit_qty,
										'sm_unit_prc'     : sm_unit_prc,
											'ppn_status'        : ppn_status,
										'ppn_status_color'  : ppn_status_color,
										// 'discount'        : discount,
										// 'discount_total'        : discount_total,
										'result_large'    : result_large,
										'result_medium'   : result_medium,
										'result_small'    : result_small,
										'total'           : total,
										'remark'          : '',
										'btncolor'        : btncolor,
										'btnicon'         : btnicon,
									};
								}
								vue.listData = listData;
							}
						});
					},

					getSelectedData: function (row, idx) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							// toastr.warning('Data sudah tersedia!')
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);

							editVueInit.detailData.splice(index, 1);
							vue.$set(vue.listData[idx], 'btncolor', 'btn-default');
							vue.$set(vue.listData[idx], 'btnicon', '');
						}else{
							editVueInit.detailData.push({
								id: row.id,
								name: row.name,
								lg_unit         : row.lg_unit,
								lg_unit_cnt     : row.lg_unit_cnt,
								lg_unit_qty     : row.lg_unit_qty,
								lg_unit_prc     : row.lg_unit_prc,
								md_unit         : row.md_unit,
								md_unit_cnt     : row.md_unit_cnt,
								md_unit_qty     : row.md_unit_qty,
								md_unit_prc     : row.md_unit_prc,
								sm_unit         : row.sm_unit,
								sm_unit_cnt     : row.sm_unit_cnt,
								sm_unit_qty     : row.sm_unit_qty,
								sm_unit_prc     : row.sm_unit_prc,
								ppn_total         : row.ppn_total,
								ppn_status        : row.ppn_status,
								ppn_status_color  : row.ppn_status_color,
								// discount        : row.discount,
								// discount_total        : row.discount_total,
								result_large	: row.result_large,
								result_medium	: row.result_medium,
								result_small	: row.result_small,
								total           : row.total,
								remark: ''
							});
							vue.$set(vue.listData[idx], 'btncolor', 'btn-success');
							vue.$set(vue.listData[idx], 'btnicon', 'fa fa-check');
						}
						
						vue.checkData_isExists();
					},

					handlePrice: function (row, field_name, value) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						vue.$set(row, field_name, value);

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], field_name, value);
						}

						vue.handleCount(row, field_name, value);
					},

					handleCount: function (row, field_name, value, wholesale_done) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						// var discount = 0;
						// var sub_total = 0;

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);
							if (field_name == 'lg_unit_qty' && wholesale_done != 1) {
								vue.handleWholesalePrice(row, field_name, value);
							}
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc') {
							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc') {
							result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_small', result_small);
						}

						result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						total = (Number(result_large_total) + Number(result_medium_total) + Number(result_small_total));
                        var ppn_total = 0
				// 		if(row.ppn_status == '2'){
							var ppn_amount = $("#ppn_amount").val();
							    ppn_total  = (total * (ppn_amount/100));
				// 		}
						vue.$set(row, 'ppn_total', ppn_total);
						vue.$set(row, 'total', (total + ppn_total).toLocaleString("en-US"));
						// discount = total * row.discount / 100;
						// sub_total = total - discount;
				// 		vue.$set(row, 'total', total.toLocaleString("en-US"));
						// vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
						// vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], field_name, value);
							vue.$set(editVueInit.detailData[index], 'result_large', result_large_total);
							vue.$set(editVueInit.detailData[index], 'result_medium', result_medium_total);
							vue.$set(editVueInit.detailData[index], 'result_small', result_small_total);
							// vue.$set(editVueInit.detailData[index], 'discount_total', discount.toLocaleString("en-US"));
							// vue.$set(editVueInit.detailData[index], 'total', sub_total.toLocaleString("en-US"));
							vue.$set(editVueInit.detailData[index], 'total', (total + ppn_total).toLocaleString("en-US"));
							vue.$set(editVueInit.detailData[index], 'ppn_total', ppn_total);
						}
					},

					handleWholesalePrice: function (row, field_name, value) {
						var vue = this;

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/sales_orders/get_wholesale_price',
							dataType: "JSON",
							data: {
								customer: $("#customer-select").val(),
								item: row.id,
								quantity_large: value
							},
							success: function (data) {
								vue.$set(row, 'lg_unit_prc', data);
								vue.handleCount(row, field_name, value, 1);
							},
						});
					},

					closeModal: function () {
						$(that.elClose).click();
					},

					checkData_isExists: function () {
						var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						const a = [];
						const objectArray = Object.entries(editVueInit.detailData);

						objectArray.forEach(([key, value]) => {
							a.push(value.id);
						});

						vue.a = a;
					},	

					checkValue_isExists: function (value, arr) {
						var vue = this;

						var status = 'Not exist';

						for (var i = 0; i < arr.length; i++) {
							var contains = arr[i];
							if (contains == value) {
								status = 'Exist';
								break;
							}
						}

						return status;
					}
				},
				mounted: function () {
					var vue = this;

					vue.getDataEmbed();
					vue.checkData_isExists();
					
				}
			});

		},
	}
})(jQuery);