/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elItem: '.select-item',
		elOrder: '.select-order',
		elGroup: '.select-group',
		elStatus: '.select-status',
		elSupplier: '.select-supplier',
		elCustomer: '.select-customer',
		elDate: '.date-log',
		elDate2: '.date-log2',

		urlRequestData: window.APP.siteUrl + 'adm/report_purchase_price/get_data_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					item_name: '',
					group_name: '',
					date_log: '',
					date_log2: '',
					status_name: '',
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;
						var val_item   = $(that.elItem).val();
						var val_group  = $(that.elGroup).val();
						var val_date   = $(that.elDate).val();
						var val_date2   = $(that.elDate2).val();
						var val_status   = $(that.elStatus).val();
						var val_supplier   = $(that.elSupplier).val();
						var val_customer   = $(that.elCustomer).val();
						var val_order   = $(that.elOrder).val();

						var text_item  = $(that.elItem + ' option:selected').text();
						var text_group = $(that.elGroup + ' option:selected').text();
						var text_status = $(that.elStatus + ' option:selected').text();

						vue.$set(vue, 'item_name', text_item);
						vue.$set(vue, 'group_name', text_group);
						vue.$set(vue, 'date_log', val_date);
						vue.$set(vue, 'date_log2', val_date2);
						vue.$set(vue, 'status_name', val_status);

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'item'    : val_item,
								'group'   : val_group,
								'date_log': val_date,
								'date_log2': val_date2,
								'status': val_status,
								'supplier': val_supplier,
								'customer': val_customer,
								'order': val_order,
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_averages/export_excel';
						}, 500);
					},

					handleStatusTransaksi: function () {
						var vue = this;

						$(".select-status").change(function (e) {
							var value = $(e.target).val();
							if(value == "Buy"){
								$("#el-customer").hide();
								$("#el-supplier").show();
							}else if(value == "Sell"){
								$("#el-customer").show();
								$("#el-supplier").hide();
							}else{
								$("#el-customer").hide();
								$("#el-supplier").hide();
							}

						});
					},
				},
				mounted: function () {
					var vue = this;
					$("#el-customer").hide();
					$("#el-supplier").hide();
					vue.handleStatusTransaksi();
				}
			});

		},

	}

})(jQuery);