/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elCustomer: '.select-customer',
		elSubCheckbox: '.check-sub-master',
		elPPN: '.select-ppn',
		elItem: '.select-item',
		elFromDate: '.fromdate',
		elToDate: '.todate',
		elTable: '.table',
        elBtnXML: '.master-xml',
        elParentCheckbox: '.check-all-master',

		urlRequestData: window.APP.siteUrl + 'adm/report_sales_orders/get_data_export',
		urlExportData: window.APP.siteUrl + 'adm/sales_orders/generate_xml',
		urlExportData2: window.APP.siteUrl + 'adm/sales_orders/generate_xml_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;
            
			that.handleVue();
		},
        
		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					customer: '',
					item_name: '',
					item: '',
					fromdate: '',
					todate: '',
					grand_total: 0,
					total_transaksi: 0,
					detailData: []
				},
				methods: {
					getData: function () {
						var vue           = this;
						var val_customer  = $(that.elCustomer).val();
						var val_ppn       = $(that.elPPN).val();
						var val_item      = $(that.elItem).val();
						var val_fromdate  = $(that.elFromDate).val();
						var val_todate    = $(that.elToDate).val();

						var text_customer = $(that.elCustomer + ' option:selected').text();
						var text_item     = $(that.elItem + ' option:selected').text();
						
						vue.$set(vue, 'customer', text_customer);
						vue.$set(vue, 'item_name', text_item);
						// vue.$set(vue, 'date', text_date);

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'customer': val_customer,
								'item'    : val_item,
								'ppn'     : val_ppn,
								'fromdate': val_fromdate,
								'todate'  : val_todate,
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response['detail_data']);
								// vue.$set(vue, 'grand_total', response['grand_total']);
								vue.$set(vue, 'total_transaksi', response['total_transaksi']);

								$(that.elVue).unblock();
							}
						});
					},
                    handleCheckAll: function () {
                        var that = this;
                        
                        console.log("Checked")
                        var isChecked = $("#check-all-master").prop('checked');
                        console.log($(this));
                        console.log(isChecked);
                        $('.check-sub-master').prop('checked', isChecked);
                        this.calculateCheckedTotal();

            
                    },
                    calculateCheckedTotal: function () {
                        var vue = this;
                        var checkedItems = document.querySelectorAll('.check-sub-master:checked');
                        var total = 0;
                
                        checkedItems.forEach(function (item) {
                            var id = item.value;
                            var selectedRow = vue.detailData.find(row => row.id == id);
                            if (selectedRow) {
                                total += parseFloat(selectedRow.grand_total.replace(/[^\w\s]/gi, '')) || 0;
                            }
                        });
                
                        vue.grand_total = total.toLocaleString("en-US"); // Update grand_total in Vue data
                    },

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_sales_orders/export_excel';
						}, 500);
					},
					
					handleExcel: function () {
			var parentThis = this;

// 			$(parentThis.elBtnXML).click(function () {

				var Items = $('.table').find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin export data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Export!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
						  var form = $('<form>', {
                                action: window.APP.siteUrl + 'adm/report_sales_orders/generate_xml_excel',
                                method: 'POST',
                                target: '_blank'
                            });
            
                            // Append multiple hidden inputs for each ID
                            types.forEach(function (id) {
                                form.append($('<input>', {
                                    type: 'hidden',
                                    name: 'id[]', // Send as an array
                                    value: id
                                }));
                            });
            
                            $('body').append(form);
                            form.submit();
                            form.remove();

						}
					})


				}
// 			});
		},
		
		handleExcel2: function () {
			var parentThis = this;

// 			$(parentThis.elBtnXML).click(function () {

				var Items = $('.table').find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin export data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Export!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
						  var form = $('<form>', {
                                action: window.APP.siteUrl + 'adm/report_sales_orders/generate_xml_header_excel',
                                method: 'POST',
                                target: '_blank'
                            });
            
                            // Append multiple hidden inputs for each ID
                            types.forEach(function (id) {
                                form.append($('<input>', {
                                    type: 'hidden',
                                    name: 'id[]', // Send as an array
                                    value: id
                                }));
                            });
            
                            $('body').append(form);
                            form.submit();
                            form.remove();

						}
					})


				}
// 			});
		},
		handleEfaktur: function () {
			var parentThis = this;

// 			$(parentThis.elBtnXML).click(function () {

				var Items = $('.table').find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin export data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Export!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
						  var form = $('<form>', {
                                action: window.APP.siteUrl + 'adm/report_sales_orders/generate_xml_efaktur',
                                method: 'POST',
                                target: '_blank'
                            });
            
                            // Append multiple hidden inputs for each ID
                            types.forEach(function (id) {
                                form.append($('<input>', {
                                    type: 'hidden',
                                    name: 'id[]', // Send as an array
                                    value: id
                                }));
                            });
            
                            $('body').append(form);
                            form.submit();
                            form.remove();

						}
					})


				}
// 			});
		},
					
					handleXml: function () {
			var parentThis = this;

// 			$(parentThis.elBtnXML).click(function () {

				var Items = $('.table').find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin export data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Export!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
						  var form = $('<form>', {
                                action: window.APP.siteUrl + 'adm/report_sales_orders/generate_xml',
                                method: 'POST',
                                target: '_blank'
                            });
            
                            // Append multiple hidden inputs for each ID
                            types.forEach(function (id) {
                                form.append($('<input>', {
                                    type: 'hidden',
                                    name: 'id[]', // Send as an array
                                    value: id
                                }));
                            });
            
                            $('body').append(form);
                            form.submit();
                            form.remove();
				// 			$.ajax({
				// 				type: "POST",
				// 				dataType: 'json',
				// 				url: parentThis.urlExportData,
				// 				data: {
				// 					id: types,
				// 				},
				// 				 xhrFields: {
    //                                 responseType: 'blob' // Ensures we handle the response as a file
    //                             },
    //                             success: function (response) {
    //                                 console.log("Success")
    //                                 var blob = new Blob([response], { type: 'application/xml' });
    //                                 var link = document.createElement('a');
    //                                 link.href = window.URL.createObjectURL(blob);
    //                                 link.download = 'RetailInvoice_' + new Date().toISOString().replace(/[:.]/g, '-') + '.xml';
    //                                 document.body.appendChild(link);
    //                                 link.click();
    //                                 document.body.removeChild(link);
    //                             }
				// 			});
						}
					})


				}
// 			});
		},
		
		handleXmlHeader: function () {
    			var parentThis = this;
    
    // 			$(parentThis.elBtnXML).click(function () {
    
    				var Items = $('.table').find('input[class="check-sub-master"]:checked');
    
    				var types = [];
    				for (var i = 0; i < Items.length; i++) {
    					types.push($(Items[i]).val());
    				}
    
    				if (!types.length) {
    
    					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
    
    					return false;
    
    				} else {
    
    					Swal.fire({
    						title: 'Anda yakin?',
    						text: "Ingin export data ini?",
    						type: 'warning',
    						showCancelButton: true,
    						confirmButtonColor: '#3085d6',
    						cancelButtonColor: '#d33',
    						confirmButtonText: 'Ya, Export!',
    						cancelButtonText: 'Batal'
    					}).then((result) => {
    						if (result.value) {
    						  var form = $('<form>', {
                                    action: window.APP.siteUrl + 'adm/report_sales_orders/generate_xml_header',
                                    method: 'POST',
                                    target: '_blank'
                                });
                
                                // Append multiple hidden inputs for each ID
                                types.forEach(function (id) {
                                    form.append($('<input>', {
                                        type: 'hidden',
                                        name: 'id[]', // Send as an array
                                        value: id
                                    }));
                                });
                
                                $('body').append(form);
                                form.submit();
                                form.remove();
    				// 			$.ajax({
    				// 				type: "POST",
    				// 				dataType: 'json',
    				// 				url: parentThis.urlExportData,
    				// 				data: {
    				// 					id: types,
    				// 				},
    				// 				 xhrFields: {
        //                                 responseType: 'blob' // Ensures we handle the response as a file
        //                             },
        //                             success: function (response) {
        //                                 console.log("Success")
        //                                 var blob = new Blob([response], { type: 'application/xml' });
        //                                 var link = document.createElement('a');
        //                                 link.href = window.URL.createObjectURL(blob);
        //                                 link.download = 'RetailInvoice_' + new Date().toISOString().replace(/[:.]/g, '-') + '.xml';
        //                                 document.body.appendChild(link);
        //                                 link.click();
        //                                 document.body.removeChild(link);
        //                             }
    				// 			});
    						}
    					})
    
    
    				}
    // 			});
    		},
		
		handleXmlDetail: function () {
    			var parentThis = this;
    
    // 			$(parentThis.elBtnXML).click(function () {
    
    				var Items = $('.table').find('input[class="check-sub-master"]:checked');
    
    				var types = [];
    				for (var i = 0; i < Items.length; i++) {
    					types.push($(Items[i]).val());
    				}
    
    				if (!types.length) {
    
    					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
    
    					return false;
    
    				} else {
    
    					Swal.fire({
    						title: 'Anda yakin?',
    						text: "Ingin export data ini?",
    						type: 'warning',
    						showCancelButton: true,
    						confirmButtonColor: '#3085d6',
    						cancelButtonColor: '#d33',
    						confirmButtonText: 'Ya, Export!',
    						cancelButtonText: 'Batal'
    					}).then((result) => {
    						if (result.value) {
    						  var form = $('<form>', {
                                    action: window.APP.siteUrl + 'adm/report_sales_orders/generate_xml_detail',
                                    method: 'POST',
                                    target: '_blank'
                                });
                
                                // Append multiple hidden inputs for each ID
                                types.forEach(function (id) {
                                    form.append($('<input>', {
                                        type: 'hidden',
                                        name: 'id[]', // Send as an array
                                        value: id
                                    }));
                                });
                
                                $('body').append(form);
                                form.submit();
                                form.remove();
    				// 			$.ajax({
    				// 				type: "POST",
    				// 				dataType: 'json',
    				// 				url: parentThis.urlExportData,
    				// 				data: {
    				// 					id: types,
    				// 				},
    				// 				 xhrFields: {
        //                                 responseType: 'blob' // Ensures we handle the response as a file
        //                             },
        //                             success: function (response) {
        //                                 console.log("Success")
        //                                 var blob = new Blob([response], { type: 'application/xml' });
        //                                 var link = document.createElement('a');
        //                                 link.href = window.URL.createObjectURL(blob);
        //                                 link.download = 'RetailInvoice_' + new Date().toISOString().replace(/[:.]/g, '-') + '.xml';
        //                                 document.body.appendChild(link);
        //                                 link.click();
        //                                 document.body.removeChild(link);
        //                             }
    				// 			});
    						}
    					})
    
    
    				}
    // 			});
    		},
    		
    		handleXmlDetail2: function () {
    			var parentThis = this;
    
    // 			$(parentThis.elBtnXML).click(function () {
    
    				var Items = $('.table').find('input[class="check-sub-master"]:checked');
    
    				var types = [];
    				for (var i = 0; i < Items.length; i++) {
    					types.push($(Items[i]).val());
    				}
    
    				if (!types.length) {
    
    					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
    
    					return false;
    
    				} else {
    
    					Swal.fire({
    						title: 'Anda yakin?',
    						text: "Ingin export data ini?",
    						type: 'warning',
    						showCancelButton: true,
    						confirmButtonColor: '#3085d6',
    						cancelButtonColor: '#d33',
    						confirmButtonText: 'Ya, Export!',
    						cancelButtonText: 'Batal'
    					}).then((result) => {
    						if (result.value) {
    						  var form = $('<form>', {
                                    action: window.APP.siteUrl + 'adm/report_sales_orders/generate_xml_detail_nik',
                                    method: 'POST',
                                    target: '_blank'
                                });
                
                                // Append multiple hidden inputs for each ID
                                types.forEach(function (id) {
                                    form.append($('<input>', {
                                        type: 'hidden',
                                        name: 'id[]', // Send as an array
                                        value: id
                                    }));
                                });
                
                                $('body').append(form);
                                form.submit();
                                form.remove();
    				// 			$.ajax({
    				// 				type: "POST",
    				// 				dataType: 'json',
    				// 				url: parentThis.urlExportData,
    				// 				data: {
    				// 					id: types,
    				// 				},
    				// 				 xhrFields: {
        //                                 responseType: 'blob' // Ensures we handle the response as a file
        //                             },
        //                             success: function (response) {
        //                                 console.log("Success")
        //                                 var blob = new Blob([response], { type: 'application/xml' });
        //                                 var link = document.createElement('a');
        //                                 link.href = window.URL.createObjectURL(blob);
        //                                 link.download = 'RetailInvoice_' + new Date().toISOString().replace(/[:.]/g, '-') + '.xml';
        //                                 document.body.appendChild(link);
        //                                 link.click();
        //                                 document.body.removeChild(link);
        //                             }
    				// 			});
    						}
    					})
    
    
    				}
    // 			});
    		},
				},
				mounted: function () {
				    // this.handleCheckAll();
                    // this.handleXml();
                    
				}
			});

		},

	}

})(jQuery);