/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
        urlList: window.APP.siteUrl + 'adm/special_prices/get_embed',
        urlRequestData: window.APP.siteUrl + 'adm/special_prices/get_data_detail',

		// initial
		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: []
				},
				methods: {
					detailAdd: function () {
						// show modal
						$(that.elModal).modal("show");
						$.ajax({
							url: that.urlList,
							success: function (response) {
								$(that.elModalC).html(response);
							}
						});
						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								ii.prop('checked', false);

							}, 100);
						}
						$('input[type="checkbox"]').prop('checked', false);
					},

                    handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();

                    	$.ajax({
                    		url: that.urlRequestData,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
					},
					
					handleInputMask: function (value, row, varname) {
						var vue = this;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 500);
						
						vue.$set(row, varname, value);
					},

					handleCheckbox: function () {

						$('#edit-table').on('click', '#check-sub', function () {
							var row     = ($('#edit-table tr').length - 1);
							var checked = $('#edit-table').find('input[class="check-sub"]:checked');
			
							if(row == checked.length){
								$('#check-all').prop('checked', true);
							}else{
								$('#check-all').prop('checked', false);
							}
						});
			
					},
                     
				},
				mounted: function () {
                    var vue = this;
					var id = $("#id").val();
					
                    if(id != 'new'){
						vue.handleData();
					}
					vue.handleCheckbox();
					
					setTimeout(function () {
						that.handleForm();
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);
					}, 500);
				}
			});

		},
        
		// form
		handleForm: function () {
			var that = this;

			window.DATETIME.initDatePicker();

			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				// beforeSend: function () {
				// 	$(that.elVue).block();

				// 	if (that.initVue.detailData.length == 0) {
				// 		toastr.warning('Silahkan isi data terlebih dahulu!')
				// 		$(that.elVue).unblock();
				// 		return false;
				// 	}
				// },
				data: {
					vuedata: that.initVue.detailData
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					window.FORM.showNotification(response.message, response.status);

					if (response.status == "success") {
						setTimeout(function () {
							window.location.href = window.APP.siteUrl + 'adm/customers'
						}, 1500);
					}

				}
			});

        },
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);