<?php
/**
 * Report Profits by Date Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_profits_byitem extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent:: __construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Reports_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Laba';
		
		$this->twiggy_display('adm/report_profits/byitem', $data);
	}

	public function get_data_detail()
	{	
		$date_1 = $this->input->post("date_1");
		$date_2 = $this->input->post("date_2");
		$status = $this->input->post("status");

		$data          = [];
		$where         = [];
		$total_sales   = 0;
		$total_capital = 0;
		$total_margin  = 0;

		$get_data = $this->Reports_model->get_profitByItem(change_format_date($date_1), change_format_date($date_2), $status)->result();

		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$margin = $get_row->total - $get_row->total_cap;

				$data[] = array(
					'no'      => $no,
					'date'    => change_format_date($get_row->sales_date, 'd/m/Y'),
					'item'    => $get_row->sales_order_detail_item_name,
					'sales'   => number_format($get_row->total),
					'capital' => number_format($get_row->total_cap),
					'margin'  => number_format($margin),
					'margin_txt'  => ($margin > 0 ? '' : 'bg-danger'),
				);
                $no++;

				$total_sales   += $get_row->total;
				$total_capital += $get_row->total_cap;
				$total_margin  += $margin;
			}
		}

		$response = [
			'data'          => $data,
			'status'        => $status,
			'date_1'        => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			'date_2'        => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'total_sales'   => number_format($total_sales),
			'total_capital' => number_format($total_capital),
			'total_margin'  => number_format($total_margin),
		];

		// $this->session->set_userdata('date_1', $date_1);
		// $this->session->set_userdata('date_2', $date_2);
		// $this->session->set_userdata('total_income', $total_income);

		output_json($response);
	}

}

?>
