<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Raja Holiday Header</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css" integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css">

    <style>
        /* Top bar */
        .top-bar {
            background: #1F3D2B;
            color: #fff;
            font-size: 13px;
        }

        .top-bar a {
            color: #fff;
            text-decoration: none;
            margin-left: 15px;
        }

        /* Main navbar */
        .main-navbar {
            background: #7FAF9A;
        }

        .navbar-brand img {
            height: 45px;
        }

        .navbar-nav .nav-link {
            color: #fff !important;
            font-weight: 500;
            padding: 15px;
        }

        .navbar-nav .nav-link:hover,
        .navbar-nav .dropdown-menu a:hover {
            background: rgba(255,255,255,0.1);
        }

        .dropdown-menu {
            background: #1E90FF;
            border: none;
        }

        .dropdown-menu a {
            color: #fff;
        }
        .heroimage{
            /*margin:0;*/
             min-height: 60vh;
              display: flex;
              align-items: center;
            background-image:url('<?php echo base_url().'assets/images/japan.jpg'?>');
            background-position: center; /* Center the image */
              background-repeat: no-repeat; /* Do not repeat the image */
              background-size: cover; /* Resize the background image to cover the entire container */
        }
        .icon{
            width:10vh;
            height:10vh;
            display: flex;
              justify-content: center;
              align-items: center;
            font-size:5vh;
            margin:auto;
            background-color:#7FAF9A;
            color:white;
            border-radius:50px;
        }
        .bordered-text{
            text-shadow: 1px 0 #636363, -1px 0 #636363, 0 1px #636363, 0 -1px #636363,
               0.5px 0.5px #636363, -0.5px -0.5px #636363, 0.5px -0.5px #636363, -0.5px 0.5px #636363;
        }
        
        .carousel img {
          width: 70px;
          max-height: 70px;
          border-radius: 50%;
          margin-right: 1rem;
          overflow: hidden;
        }
        .carousel-inner {
          padding: 1em;
        }
        
        @media screen and (min-width: 576px) {
          .carousel-inner {
            display: flex;
            width: 90%;
            margin-inline: auto;
            padding: 1em 0;
            overflow: hidden;
          }
          .carousel-item {
            display: block;
            margin-right: 0;
            flex: 0 0 calc(100% / 2);
          }
        }
        @media screen and (min-width: 1024px) {
          .carousel-item {
            display: block;
            margin-right: 0;
            flex: 0 0 calc(100% / 3);
          }
        }
        .carousel .card {
          margin: 0 0.5em;
          border: 0;
        }
        
        .carousel-control-prev,
        .carousel-control-next {
          width: 3rem;
          height: 3rem;
          background-color: grey;
          border-radius: 50%;
          top: 50%;
          transform: translateY(-50%);
        }
        .carousel-inner {
           scroll-behavior: smooth;
          overflow-x: hidden;
          scroll-behavior: smooth;
        }
        .carousel-item {
          transition: none !important;
        }
        #demo {
          height:100%;
          position:relative;
          overflow:hidden;
        }
        
        
        .green{
          background-color:#6fb936;
        }
                .thumb{
                    margin-bottom: 30px;
                }
                
                .page-top{
                    margin-top:85px;
                }
        
           
        img.zoom {
            width: 100%;
            height: 200px;
            border-radius:5px;
            object-fit:cover;
            -webkit-transition: all .3s ease-in-out;
            -moz-transition: all .3s ease-in-out;
            -o-transition: all .3s ease-in-out;
            -ms-transition: all .3s ease-in-out;
        }
                
         
        .transition {
            -webkit-transform: scale(1.2); 
            -moz-transform: scale(1.2);
            -o-transform: scale(1.2);
            transform: scale(1.2);
        }
            .modal-header {
           
             border-bottom: none;
        }
            .modal-title {
                color:#000;
            }
            .modal-footer{
              display:none;  
            }
            
            .fixed-button {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000; /* Ensure it's above other content */
        }

        .fixed-button .btn {
            padding: 10px 20px;
            font-size: 1rem;
            border-radius: 25px; /* Rounded corners */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* Add a shadow */
            transition: background-color 0.3s ease; /* Smooth hover effect */
        }

        .fixed-button .btn:hover {
            background-color: #218838; /* Darker green on hover */
        }
        @media screen and (max-width: 768px) {
            .fixed-button {
                bottom: 10px;
                right: 10px;
            }

            .fixed-button .btn {
                padding: 8px 16px;
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body style="background-color:#EAF4EF">

<!-- TOP BAR -->
<div class="top-bar py-1">
    <div class="container d-flex justify-content-end">
        <span>Call : 0822 1009 7777</span>
        <a href="mailto:rajaholiday.id@gmail.com">Email : rajaholiday.id@gmail.com</a>
    </div>
</div>

<!-- NAVBAR -->
<nav class="navbar navbar-expand-lg main-navbar">
    <div class="container">

        <!-- LOGO -->
        <a class="navbar-brand" href="#">
            <img src="assets/logo.png" alt="Raja Holiday">
        </a>

        <!-- TOGGLER -->
        <button class="navbar-toggler text-white" type="button" data-bs-toggle="collapse" data-bs-target="#mainMenu">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- MENU -->
        <div class="collapse navbar-collapse" id="mainMenu">
            <ul class="navbar-nav ms-auto">

                <li class="nav-item">
                    <a class="nav-link" href="#">HOME</a>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                        TOUR
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#">Domestic Tour</a></li>
                        <li><a class="dropdown-item" href="#">International Tour</a></li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                        DESTINASI
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#">Asia</a></li>
                        <li><a class="dropdown-item" href="#">Europe</a></li>
                        <li><a class="dropdown-item" href="#">Middle East</a></li>
                    </ul>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#">UMROH</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#">PROMO TOUR</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#">HOLIDAY SEASON</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#">GALERI</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#">PROFIL</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#">KONTAK</a>
                </li>

            </ul>
        </div>
        
    </div>
    
</nav>
<section class="header" style="background-color:#EAF4EF">
 <div class="container-fluid col-xxl-12 px-5 py-5 heroimage text-white">
  <div class="row flex-lg-row-reverse align-items-center px-5 g-5 h-100">
    <div class="col-10 col-sm-8 col-lg-6 ">
      <!-- image here if needed -->
    </div>
    <div class="col-lg-6">
      <h1 class="display-5 fw-bold lh-1 mb-3 bordered-text" >
        Lets Travel
      </h1>
      <p class="lead bordered-text">
        Quickly design and customize responsive mobile-first sites with Bootstrap,
        the world’s most popular front-end open source toolkit.
      </p>
      <div class="d-grid gap-2 d-md-flex justify-content-md-start">
        <button type="button" class="btn btn-lg px-4 me-md-2" style="background-color:#C9A24D;color:#FFF">
          View Tours
        </button>
        <!--<button type="button" class="btn btn-outline-secondary btn-lg px-4">-->
        <!--  Default-->
        <!--</button>-->
      </div>
    </div>
  </div>
</div>
</section>
<div class="content" >
    <div class="container-fluid " style="background-color:#EAF4EF;">
        <div class="container" style="margin-top:10vh">
            <section class="part1 text-center">
                <h2 class="mt-4">MENGAPA RAJA HOLIDAY ? </h2>
                <h6>BERPENGALAMAN & TERPERCAYA SEJAK 2011</h6>
                <div class="row" style="margin-top:5vh">
                    <div class="col-md-3 col-6">
                        <div class="card" style="border:0;text-align:justify-center;background-color:#EAF4EF;">
                              <div class="card-body">
                                <div class="icon">
                                    <i class="fas fa-plane-departure"></i>
                                </div>
                                 
                                <h6 class="card-title mt-3" style="font-size:2.1vh">Beragam Destinasi Wisata</h6>
                                <!--<h6 class="card-subtitle mb-2 text-muted">Card subtitle</h6>-->
                                <p class="card-text" style="font-size:2vh">Tersedia beragam destinasi wisata dari berbagai macam negara pilihan terbaik</p>
                               
                              </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-6">
                        <div class="card" style="border:0;text-align:justify-center;background-color:#EAF4EF;">
                              <div class="card-body">
                                <div class="icon">
                                    <i class="fa-solid fa-money-bill-1"></i>
                                </div>
                                 
                                <h6 class="card-title mt-3" style="font-size:2.1vh">Harga Tour Kompetitif</h6>
                                <!--<h6 class="card-subtitle mb-2 text-muted">Card subtitle</h6>-->
                                <p class="card-text" style="font-size:2vh">Kualitas layanan tour prioritas utama kami, bukan hanya sekedar harga murah</p>
                               
                              </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-6">
                        <div class="card" style="border:0;text-align:justify-center;background-color:#EAF4EF;">
                              <div class="card-body">
                                <div class="icon">
                                    <i class="fa-solid fa-clock"></i>
                                </div>
                                 
                                <h6 class="card-title mt-3" style="font-size:2.1vh">Jam Layanan Pelanggan</h6>
                                <!--<h6 class="card-subtitle mb-2 text-muted">Card subtitle</h6>-->
                                <p class="card-text" style="font-size:2vh">Layanan pelanggan setiap Senin - Jumat 08.00 - 17.00 WIB & Sabtu 08 - 15.00 WIB</p>
                               
                              </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-6">
                        <div class="card" style="border:0;text-align:justify-center;background-color:#EAF4EF;">
                              <div class="card-body">
                                <div class="icon">
                                    <i class="fa-solid fa-users"></i>
                                </div>
                                 
                                <h6 class="card-title mt-3" style="font-size:2.1vh">Group Tour & Gathering</h6>
                                <!--<h6 class="card-subtitle mb-2 text-muted">Card subtitle</h6>-->
                                <p class="card-text" style="font-size:2vh">Menerima Kustom Tour & Gathering untuk Perusahaan, Organisasi dan Keluarga Besar</p>
                               
                              </div>
                        </div>
                    </div>
                </div>
            </section>
            
        </div>
    </div>
    <div class="container-fluid " style="background-color:#FFF;">
        <div class="container" style="margin-top:10vh">
            <section class="part1">
                <br>
                <br>
                <!--<br>-->
                <h6 class="mt-4 text-center">PAKET TOUR</h6>
                <h2 class="text-center">TOUR KAMI </h2>
                
                <div class="row" style="margin-top:5vh">
                    <?php
                            foreach ($paketnew->result_array() as $h) {
                                $idpaketf=$h['idpaket'];
                                $namapaketf=$h['nama_paket'];
                                $gambarf=$h['gambar'];
                                $isi=substr($h['deskripsi'], 0, 50);
                            ?>
 
                    <div class="col-md-3 col-6">
                       <div class="card" style="width:100%;height:420px;margin-bottom:4vh;">
                          <img class="card-img-top" src="<?php echo base_url().'assets/gambars/'.$gambarf;?>" alt="Card image cap" style="height: 200px;object-fit: cover;">
                          <div class="card-body">
                            <h5 class="card-title"><a href="<?php echo base_url().'paket_tour/detail_paket/'.$idpaketf;?>" style="color:black;text-decoration:none"><?php echo $namapaketf;?></a></h5>
                            <a href="<?php echo base_url().'paket_tour/detail_paket/'.$idpaketf;?>" style="color:black;text-decoration:none"> <?= $isi ?>... </a>
                          </div>
                        </div>
                    </div>
                    <?php } ?>
                
                </div>
            </section>
            
        </div>
    </div>
    <div class="container-fluid " style="background-color:#FFF;">
        <div class="container">
            <section class="part1">
                <br>
                <br>
                <!--<br>-->
                <h6 class="mt-4 text-center">Testimony</h6>
                <h2 class="text-center">What our clients say </h2>
                
                <div class="row" style="margin-top:5vh">
                    <div id="testimonialCarousel" class="carousel slide">
                        <div class="carousel-inner">
                            <?php
                                $first = true;
                                foreach ($test->result_array() as $j):
                                $name=$j['nama'];
                                $tgl_post=$j['tgl_post'];
                                $pesan=$j['pesan'];
                            ?>

                            <div class="carousel-item <?= $first ? 'active' : '' ?>">
                                <div class="card shadow-sm rounded-3 p-2" style="height:420px;">
                                    <div class="quotes display-2 text-body-tertiary">
                                        <i class="bi bi-quote"></i>
                                    </div>
                                    <div class="card-body">
                                        <p class="card-text">"<?= $pesan ?>"</p>
                                        
                                    </div>
                                    <div class="card-footer">
                                        <div class="pt-3">
                                            <div>
                                                <h5 class="card-title fw-bold"><?= $name ?></h5>
                                                <span class="text-secondary"><?= $tgl_post ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                           <?php
                           $first = false;
                           endforeach ;?>
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>
            </section>
            
        </div>
    </div>
    
    <div class="container-fluid " style="background-color:#FFF;">
        <div class="container ">
            <section class="part1">
                <br>
                <br>
                <!--<br>-->
                <h2 class="text-center">Our Gallery</h2>
                
                <div class="row" style="margin-top:5vh">
                    <div class="col-lg-3 col-md-4 col-6 thumb">
                        <img src="https://images.pexels.com/photos/62307/air-bubbles-diving-underwater-blow-62307.jpeg"
                             class="zoom img-fluid gallery-img"
                             data-bs-toggle="modal"
                             data-bs-target="#imageModal"
                             data-img="https://images.pexels.com/photos/62307/air-bubbles-diving-underwater-blow-62307.jpeg"
                             alt="">
                    </div>
                
                    <div class="col-lg-3 col-md-4 col-6 thumb">
                        <img src="https://images.pexels.com/photos/38238/maldives-ile-beach-sun-38238.jpeg"
                             class="zoom img-fluid gallery-img"
                             data-bs-toggle="modal"
                             data-bs-target="#imageModal"
                             data-img="https://images.pexels.com/photos/38238/maldives-ile-beach-sun-38238.jpeg"
                             alt="">
                    </div>
                
                    <div class="col-lg-3 col-md-4 col-6 thumb">
                        <img src="https://images.pexels.com/photos/158827/field-corn-air-frisch-158827.jpeg"
                             class="zoom img-fluid gallery-img"
                             data-bs-toggle="modal"
                             data-bs-target="#imageModal"
                             data-img="https://images.pexels.com/photos/158827/field-corn-air-frisch-158827.jpeg"
                             alt="">
                    </div>
                
                    <div class="col-lg-3 col-md-4 col-6 thumb">
                        <img src="https://images.pexels.com/photos/302804/pexels-photo-302804.jpeg"
                             class="zoom img-fluid gallery-img"
                             data-bs-toggle="modal"
                             data-bs-target="#imageModal"
                             data-img="https://images.pexels.com/photos/302804/pexels-photo-302804.jpeg"
                             alt="">
                    </div>
                    
                    <div class="col-lg-3 col-md-4 col-6 thumb">
                        <img src="https://images.pexels.com/photos/62307/air-bubbles-diving-underwater-blow-62307.jpeg"
                             class="zoom img-fluid gallery-img"
                             data-bs-toggle="modal"
                             data-bs-target="#imageModal"
                             data-img="https://images.pexels.com/photos/62307/air-bubbles-diving-underwater-blow-62307.jpeg"
                             alt="">
                    </div>
                
                    <div class="col-lg-3 col-md-4 col-6 thumb">
                        <img src="https://images.pexels.com/photos/38238/maldives-ile-beach-sun-38238.jpeg"
                             class="zoom img-fluid gallery-img"
                             data-bs-toggle="modal"
                             data-bs-target="#imageModal"
                             data-img="https://images.pexels.com/photos/38238/maldives-ile-beach-sun-38238.jpeg"
                             alt="">
                    </div>
                
                    <div class="col-lg-3 col-md-4 col-6 thumb">
                        <img src="https://images.pexels.com/photos/158827/field-corn-air-frisch-158827.jpeg"
                             class="zoom img-fluid gallery-img"
                             data-bs-toggle="modal"
                             data-bs-target="#imageModal"
                             data-img="https://images.pexels.com/photos/158827/field-corn-air-frisch-158827.jpeg"
                             alt="">
                    </div>
                
                    <div class="col-lg-3 col-md-4 col-6 thumb">
                        <img src="https://images.pexels.com/photos/302804/pexels-photo-302804.jpeg"
                             class="zoom img-fluid gallery-img"
                             data-bs-toggle="modal"
                             data-bs-target="#imageModal"
                             data-img="https://images.pexels.com/photos/302804/pexels-photo-302804.jpeg"
                             alt="">
                    </div>

                    
                </div>
            </section>
            
        </div>
    </div>
    
</div>
   <div class="fixed-button">
        <a href="#" target="_blank" class="btn btn-success"><i class="fa-brands fa-whatsapp mr-2" style="font-size:1.2rem;"></i> Contact Us</a>
    </div>
<!-- Footer -->
<footer class="text-center text-lg-start text-muted" style="background-color:#EAF4EF">
  <!-- Section: Social media -->
  <section class="d-flex justify-content-center justify-content-lg-between p-4 border-bottom">
    <!-- Left -->

    <!-- Right -->
  </section>
  <!-- Section: Social media -->

  <!-- Section: Links  -->
  <section class="">
    <div class="container text-center text-md-start mt-5">
      <!-- Grid row -->
      <div class="row mt-3">
        <!-- Grid column -->
        <div class="col-md-3 col-lg-4 col-xl-3 mx-auto mb-4">
          <!-- Content -->
          <h6 class="text-uppercase fw-bold mb-4">
            <i class="fas fa-gem me-3"></i>Company name
          </h6>
          <p>
            Here you can use rows and columns to organize your footer content. Lorem ipsum
            dolor sit amet, consectetur adipisicing elit.
          </p>
        </div>
        <!-- Grid column -->

        <!-- Grid column -->
        <div class="col-md-2 col-lg-2 col-xl-2 mx-auto mb-4">
          <!-- Links -->
          <h6 class="text-uppercase fw-bold mb-4">
            Products
          </h6>
          <p>
            <a href="#!" class="text-reset">Angular</a>
          </p>
          <p>
            <a href="#!" class="text-reset">React</a>
          </p>
          <p>
            <a href="#!" class="text-reset">Vue</a>
          </p>
          <p>
            <a href="#!" class="text-reset">Laravel</a>
          </p>
        </div>
        <!-- Grid column -->

        <!-- Grid column -->
        <div class="col-md-3 col-lg-2 col-xl-2 mx-auto mb-4">
          <!-- Links -->
          <h6 class="text-uppercase fw-bold mb-4">
            Useful links
          </h6>
          <p>
            <a href="#!" class="text-reset">Pricing</a>
          </p>
          <p>
            <a href="#!" class="text-reset">Settings</a>
          </p>
          <p>
            <a href="#!" class="text-reset">Orders</a>
          </p>
          <p>
            <a href="#!" class="text-reset">Help</a>
          </p>
        </div>
        <!-- Grid column -->

        <!-- Grid column -->
        <div class="col-md-4 col-lg-3 col-xl-3 mx-auto mb-md-0 mb-4">
          <!-- Links -->
          <h6 class="text-uppercase fw-bold mb-4">Contact</h6>
          <p><i class="fas fa-home me-3"></i> New York, NY 10012, US</p>
          <p>
            <i class="fas fa-envelope me-3"></i>
            info@example.com
          </p>
          <p><i class="fas fa-phone me-3"></i> + 01 234 567 88</p>
          <p><i class="fas fa-print me-3"></i> + 01 234 567 89</p>
        </div>
        <!-- Grid column -->
      </div>
      <!-- Grid row -->
    </div>
  </section>
  <!-- Section: Links  -->

  <!-- Copyright -->
  <div class="text-center p-4" style="background-color: rgba(0, 0, 0, 0.05);">
    © 2026 Copyright:
    <a class="text-reset fw-bold" href="https://mdbootstrap.com/">Joshua Immanuel</a>
  </div>
  <!-- Copyright -->
</footer>
<!-- Footer -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content bg-transparent border-0">
            <div class="modal-body p-0 text-center">
                <img id="modalImage" src="" class="img-fluid rounded">
            </div>
        </div>
    </div>
</div>
<!-- Bootstrap JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
<script>
document.querySelectorAll('.gallery-img').forEach(img => {
    img.addEventListener('click', function () {
        document.getElementById('modalImage').src = this.dataset.img;
    });
});
$(document).ready(function () {
  const carouselInner = document.querySelector(".carousel-inner");

  const getCardWidth = () =>
    document.querySelector(".carousel-item").offsetWidth;

  const getMaxScroll = () =>
    carouselInner.scrollWidth - carouselInner.clientWidth;

  document.querySelector(".carousel-control-next")
    .addEventListener("click", (e) => {
      e.preventDefault();

      const cardWidth = getCardWidth();
      const maxScroll = getMaxScroll();

      if (carouselInner.scrollLeft >= maxScroll - 5) {
        // 🔁 LOOP TO START
        carouselInner.scrollLeft = 0;
      } else {
        carouselInner.scrollLeft += cardWidth;
      }
    });

  document.querySelector(".carousel-control-prev")
    .addEventListener("click", (e) => {
      e.preventDefault();

      const cardWidth = getCardWidth();
      const maxScroll = getMaxScroll();

      if (carouselInner.scrollLeft <= 5) {
        // 🔁 LOOP TO END
        carouselInner.scrollLeft = maxScroll;
      } else {
        carouselInner.scrollLeft -= cardWidth;
      }
    });
    
    $(".fancybox").fancybox({
        openEffect: "none",
        closeEffect: "none"
    });
    
    $(".zoom").hover(function(){
		
		$(this).addClass('transition');
	}, function(){
        
		$(this).removeClass('transition');
	});
});
</script>


</body>
</html>
